/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kd.bos.olapServer2.backup.sequenceLog.BigStreamCache;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0014\u0010\u000f\u001a\u00020\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileWriter;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "fileHead", "", "(Ljava/io/File;Ljava/lang/Object;)V", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "output", "Ljava/io/FileOutputStream;", "close", "", "flush", "write", "value", "Ljava/nio/ByteBuffer;", "cmdData", "", "items", "", "writeHead", "bos-olap-core2"})
public final class SeqLogFileWriter
implements Closeable {
    @Nullable
    private final Object fileHead;
    @NotNull
    private final FileOutputStream output;
    private final FileChannel channel;

    public SeqLogFileWriter(@NotNull File file, @Nullable Object fileHead) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileHead = fileHead;
        this.output = Paths.INSTANCE.createOutputStream(file, true);
        this.channel = this.output.getChannel();
        if (file.length() == 0L) {
            this.writeHead();
        }
    }

    private final void writeHead() {
        if (this.fileHead != null) {
            this.write(this.fileHead);
        }
    }

    public final void write(@NotNull Object cmdData) {
        Intrinsics.checkNotNullParameter((Object)cmdData, (String)"cmdData");
        Object object2 = cmdData;
        if (object2 instanceof ByteBuffer) {
            this.write((ByteBuffer)cmdData);
        } else if (object2 instanceof Iterable) {
            this.write((Iterable)cmdData);
        } else if (object2 instanceof File) {
            this.write((File)cmdData);
        } else if (object2 instanceof byte[]) {
            this.write((byte[])cmdData);
        } else {
            throw new NotSupportedException();
        }
    }

    private final void write(Iterable<?> items2) {
        for (Object item : items2) {
            if (item == null) continue;
            this.write(item);
        }
    }

    private final void write(byte[] value2) {
        this.output.write(value2);
    }

    private final void write(ByteBuffer value2) {
        this.channel.write(value2);
        BigStreamCache.Companion.release(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(File file) {
        long length = file.length();
        Closeable closeable = PathsKt.safeInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream otherStream = (FileInputStream)closeable;
            boolean bl = false;
            long l = this.channel.transferFrom(otherStream.getChannel(), this.channel.position(), length);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        file.delete();
    }

    public final void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.channel.close();
        this.output.close();
    }
}

