/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.time.LocalDate;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogFilter;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogRecordReader;
import kd.bos.olapServer2.backup.sequenceLog.NeedCloseThings;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogFileWriter;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV2FileEntry;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00060 j\u0002`!H\u0016J\u0006\u0010\"\u001a\u00020\u001eJ\u0012\u0010#\u001a\u00020 2\n\u0010$\u001a\u00060\u0007j\u0002`\bJ9\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0&\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,JD\u0010-\u001a\b\u0012\u0004\u0012\u0002H'0.\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+2\u0006\u0010/\u001a\u0002002\n\u00101\u001a\u00060 j\u0002`!H\u0016J\b\u00102\u001a\u00020\u001eH\u0002J\f\u00103\u001a\u00060\u0004j\u0002`\u0005H\u0002J\r\u00104\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b5J\u0006\u00106\u001a\u000207J\u001a\u00108\u001a\u00020\u001e2\n\u00109\u001a\u00060\u0007j\u0002`\b2\u0006\u0010:\u001a\u00020;R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileWriterEntry;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "Ljava/io/Closeable;", "logDirectory", "", "Lkd/bos/olapServer2/common/string;", "_start", "", "Lkd/bos/olapServer2/common/long;", "_end", "_file", "Ljava/io/File;", "strategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "(Ljava/lang/String;JJLjava/io/File;Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;)V", "_startTime", "Ljava/time/LocalDate;", "_writer", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileWriter;", "end", "getEnd", "()J", "endTime", "getEndTime", "()Ljava/time/LocalDate;", "start", "getStart", "startTime", "getStartTime", "close", "", "exists", "", "Lkd/bos/olapServer2/common/bool;", "flush", "needSplit", "fileMaxNumber", "read", "Lkotlinx/coroutines/flow/Flow;", "T", "entryFilter", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogFilter;", "reader", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecordReader;", "(Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogFilter;Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecordReader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readAsSequence", "Lkotlin/sequences/Sequence;", "needCloseThings", "Lkd/bos/olapServer2/backup/sequenceLog/NeedCloseThings;", "isPositive", "renameForWriting", "renameForWritten", "simulateCrash", "simulateCrash$bos_olap_core2", "splitFile", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileEntry;", "write", "id", "command", "", "bos-olap-core2"})
public final class SeqLogFileWriterEntry
extends SeqLogEntry
implements Closeable {
    @NotNull
    private final String logDirectory;
    private long _start;
    private long _end;
    @NotNull
    private File _file;
    @Nullable
    private LocalDate _startTime;
    @NotNull
    private SeqLogFileWriter _writer;

    public SeqLogFileWriterEntry(@NotNull String logDirectory, long _start, long _end, @NotNull File _file, @NotNull SeqLogNameStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        super(strategy, null);
        this.logDirectory = logDirectory;
        this._start = _start;
        this._end = _end;
        this._file = _file;
        String string2 = this._file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this._startTime = (LocalDate)strategy.getStartAndEndTime(string2).getFirst();
        this.renameForWriting();
        this._writer = new SeqLogFileWriter(this._file, strategy.getFileHead());
    }

    @Override
    public long getStart() {
        return this._start;
    }

    @Override
    public long getEnd() {
        return this._end;
    }

    @Override
    @Nullable
    public LocalDate getStartTime() {
        return this._startTime;
    }

    @Override
    @Nullable
    public LocalDate getEndTime() {
        return LocalDate.now();
    }

    public final void write(long id, @NotNull Object command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (id <= 0L) {
            throw new IllegalArgumentException("id(" + id + ") must >= 0");
        }
        this._writer.write(command);
        this._end = Math.max(this._end, id);
    }

    public final boolean needSplit(long fileMaxNumber) {
        return this.getEnd() % fileMaxNumber == fileMaxNumber - 1L;
    }

    @Override
    @Nullable
    public <T> Object read(@NotNull ISeqLogFilter<? super T> entryFilter, @NotNull ISeqLogRecordReader<? extends T> reader, @NotNull Continuation<? super Flow<? extends T>> $completion) {
        return entryFilter.matchEntry(this) ? FlowKt.flow((Function2)new Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object>(this, entryFilter, reader, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SeqLogFileWriterEntry this$0;
            final /* synthetic */ ISeqLogFilter<T> $entryFilter;
            final /* synthetic */ ISeqLogRecordReader<T> $reader;
            {
                this.this$0 = $receiver;
                this.$entryFilter = $entryFilter;
                this.$reader = $reader;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        var3_4 = PathsKt.safeInputStream(SeqLogFileWriterEntry.access$get_file$p(this.this$0));
                        var4_5 = this.this$0;
                        var5_6 = this.$entryFilter;
                        var6_7 = this.$reader;
                        var7_8 = null;
                        inputStream = (FileInputStream)var3_4;
                        $i$a$-use-SeqLogFileWriterEntry$read$2$1 = false;
                        var10_14 = $this$flow;
                        v0 = inputStream;
                        var11_15 = SeqLogFileWriterEntry.access$get_file$p(var4_5).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)var11_15, (String)"getName(...)");
                        var11_15 = SeqLogEntry.Companion.toRecords$bos_olap_core2(v0, (String)var11_15, var5_6, var6_7);
                        var12_16 = this;
                        $i$f$emitAll = false;
                        this.L$0 = var3_4;
                        this.label = 1;
                        v1 = flow$iv.collect((FlowCollector)$this$emitAll$iv, (Continuation)var12_16);
                        ** if (v1 != var14_2) goto lbl27
lbl26:
                        // 1 sources

                        return var14_2;
lbl27:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 1: {
                        $i$a$-use-SeqLogFileWriterEntry$read$2$1 = false;
                        $i$f$emitAll = false;
                        var7_8 = null;
                        var3_4 = (Closeable)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl38:
                            // 2 sources

                            var8_9 = Unit.INSTANCE;
                            ** GOTO lbl48
                        }
                        catch (Throwable var8_10) {
                            var7_8 = var8_10;
                            throw var8_10;
                        }
                    }
                    catch (Throwable var8_11) {
                        throw var8_11;
                    }
                    {
                        finally {
                            CloseableKt.closeFinally((Closeable)var3_4, (Throwable)var7_8);
                        }
lbl48:
                        // 1 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super T> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }) : FlowKt.emptyFlow();
    }

    @Override
    @NotNull
    public <T> Sequence<T> readAsSequence(@NotNull ISeqLogFilter<? super T> entryFilter, @NotNull ISeqLogRecordReader<? extends T> reader, @NotNull NeedCloseThings needCloseThings, boolean isPositive) {
        Intrinsics.checkNotNullParameter(entryFilter, (String)"entryFilter");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)needCloseThings, (String)"needCloseThings");
        throw new NotSupportedException("not support: SeqLogFileWriterEntry.readAsSequence");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @NotNull
    public final SeqLogFileEntry splitFile() {
        this.flush();
        String completedFileName = this.renameForWritten();
        this._start = this._end + 1L;
        this._startTime = LocalDate.now();
        this._file = Paths.INSTANCE.toFile(this.logDirectory, this.getStrategy().getNewFileName(this._start, this._end));
        this._writer = new SeqLogFileWriter(this._file, this.getStrategy().getFileHead());
        return new SeqLogV2FileEntry(this.getStrategy(), Paths.INSTANCE.toFile(this.logDirectory, completedFileName));
    }

    private final void renameForWriting() {
        String newFileName = SeqLogNameStrategy.renameFileName$default(this.getStrategy(), this._start, this._start - 1L, this.getStartTime(), null, 8, null);
        if (!Intrinsics.areEqual((Object)newFileName, (Object)this._file.getName())) {
            File newFile = Paths.INSTANCE.toFile(this.logDirectory, newFileName);
            if (!this._file.renameTo(newFile)) {
                boolean bl = false;
                String string2 = this._file + " rename to " + newFileName + " failed!";
                throw new IllegalArgumentException(string2.toString());
            }
            this._file = newFile;
        }
    }

    private final String renameForWritten() {
        this._writer.close();
        String newFileName = SeqLogNameStrategy.renameFileName$default(this.getStrategy(), this._start, this._end, this.getStartTime(), null, 8, null);
        if (!Intrinsics.areEqual((Object)newFileName, (Object)this._file.getName())) {
            File newFile = Paths.INSTANCE.toFile(this.logDirectory, newFileName);
            if (!this._file.renameTo(newFile)) {
                boolean bl = false;
                String string2 = this._file + " rename to " + newFileName + " failed!";
                throw new IllegalArgumentException(string2.toString());
            }
            this._file = newFile;
        }
        return newFileName;
    }

    public final void flush() {
        this._writer.flush();
    }

    @Override
    public void close() {
        this.renameForWritten();
    }

    public final void simulateCrash$bos_olap_core2() {
        this._writer.close();
    }

    public static final /* synthetic */ File access$get_file$p(SeqLogFileWriterEntry $this) {
        return $this._file;
    }
}

