/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogField;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0011\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0014\u0010\u0014\u001a\u00060\u0010j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0012\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00042\n\u0010#\u001a\u00060\u0019j\u0002`\u001aJ\f\u0010$\u001a\u00060\u001cj\u0002`\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser;", "", "fields", "", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "separator", "", "Lkd/bos/olapServer2/common/byte;", "([Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;B)V", "_cache", "", "_fieldEndIndexes", "", "_fields", "[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "_size", "", "getFieldEnd", "Lkd/bos/olapServer2/common/int;", "field", "getFieldStart", "getLongValue", "", "Lkd/bos/olapServer2/common/long;", "getStringValue", "", "Lkd/bos/olapServer2/common/string;", "parse", "", "Lkd/bos/olapServer2/common/bool;", "inputStream", "Ljava/io/InputStream;", "readCache", "", "tryGetField", "name", "updateFieldEndIndexes", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSeqLogRowParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeqLogRowParser.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,152:1\n1282#2,2:153\n*S KotlinDebug\n*F\n+ 1 SeqLogRowParser.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser\n*L\n91#1:153,2\n*E\n"})
public final class SeqLogRowParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte separator;
    @NotNull
    private byte[] _cache;
    private int _size;
    @NotNull
    private final SeqLogField[] _fields;
    @NotNull
    private final int[] _fieldEndIndexes;

    public SeqLogRowParser(@NotNull SeqLogField[] fields2, byte separator) {
        SeqLogField[] seqLogFieldArray;
        Intrinsics.checkNotNullParameter((Object)fields2, (String)"fields");
        this.separator = separator;
        this._cache = new byte[256];
        SeqLogRowParser seqLogRowParser = this;
        if (((SeqLogField)ArraysKt.last((Object[])fields2)).getValueType() == SeqLogField.FieldValueType.Stream) {
            int n = 0;
            int n2 = fields2.length - 1;
            SeqLogField[] seqLogFieldArray2 = new SeqLogField[n2];
            SeqLogRowParser seqLogRowParser2 = seqLogRowParser;
            while (n < n2) {
                int n3 = n++;
                seqLogFieldArray2[n3] = fields2[n3];
            }
            seqLogRowParser = seqLogRowParser2;
            seqLogFieldArray = seqLogFieldArray2;
        } else {
            seqLogFieldArray = fields2;
        }
        seqLogRowParser._fields = seqLogFieldArray;
        this._fieldEndIndexes = new int[this._fields.length];
    }

    public final boolean parse(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.readCache(inputStream);
        return this.updateFieldEndIndexes();
    }

    private final boolean updateFieldEndIndexes() {
        if (!(this._size <= this._cache.length)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this._size == 0) {
            return false;
        }
        int fieldIndex = 0;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            if (this._cache[i] != this.separator) continue;
            this._fieldEndIndexes[fieldIndex++] = i;
            if (fieldIndex == this._fieldEndIndexes.length - 1) break;
        }
        if (fieldIndex < this._fieldEndIndexes.length - 1) {
            String string3 = Res.INSTANCE.getSeqLogRowParserException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-SeqLogRowParserException_1>(...)");
            Object[] objectArray = new Object[]{this._fields.length, fieldIndex + 1, new String(this._cache, 0, this._size, Charsets.UTF_8)};
            throw Res.INSTANCE.getIndexOutOfBoundsException(string3, objectArray);
        }
        this._fieldEndIndexes[fieldIndex] = this._size;
        return true;
    }

    private final void readCache(InputStream inputStream) {
        int size = 0;
        do {
            int s;
            if ((s = inputStream.read(this._cache, size, this._cache.length - size)) < 0) {
                this._size = size;
                return;
            }
            if ((size += s) != this._cache.length) continue;
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(this._cache, this._cache.length * 2), (String)"copyOf(this, newSize)");
            this._cache = this._cache;
        } while (size <= 0x1000000);
        String string2 = Res.INSTANCE.getSeqLogRowParserException_2();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SeqLogRowParserException_2>(...)");
        throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
    }

    @Nullable
    public final SeqLogField tryGetField(@NotNull String name2) {
        SeqLogField seqLogField;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            SeqLogField[] $this$firstOrNull$iv = this._fields;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SeqLogField element$iv;
                SeqLogField it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                seqLogField = element$iv;
                break block1;
            }
            seqLogField = null;
        }
        return seqLogField;
    }

    public final long getLongValue(@NotNull SeqLogField field) {
        long l;
        int n;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        switch (WhenMappings.$EnumSwitchMapping$0[field.getValueType().ordinal()]) {
            case 1: {
                n = 10;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getSeqLogRowParserException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-SeqLogRowParserException_3>(...)");
                Object[] objectArray = new Object[]{field.getValueType()};
                throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
            }
        }
        int radix = n;
        String str = ((Object)StringsKt.trim((CharSequence)this.getStringValue(field))).toString();
        if (((CharSequence)str).length() == 0) {
            Object object2 = field.getDefaultValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long{ kd.bos.olapServer2.common.CommonTypesKt.long }");
            l = (Long)object2;
        } else {
            l = Long.parseLong(str, radix);
        }
        return l;
    }

    @NotNull
    public final String getStringValue(@NotNull SeqLogField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        int s = this.getFieldStart(field);
        int e = this.getFieldEnd(field);
        return e > s ? new String(this._cache, s, e - s, Charsets.UTF_8) : "";
    }

    private final int getFieldStart(SeqLogField field) {
        int n = this._fieldEndIndexes.length;
        int n2 = field.getPosition();
        if (!(0 <= n2 ? n2 < n : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return field.getPosition() == 0 ? 0 : this._fieldEndIndexes[field.getPosition() - 1] + 1;
    }

    private final int getFieldEnd(SeqLogField field) {
        return this._fieldEndIndexes[field.getPosition()];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser$Companion;", "", "()V", "parseFields", "", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "headString", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nSeqLogRowParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeqLogRowParser.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,152:1\n1559#2:153\n1590#2,4:154\n37#3,2:158\n*S KotlinDebug\n*F\n+ 1 SeqLogRowParser.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser$Companion\n*L\n137#1:153\n137#1:154,4\n149#1:158,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SeqLogField[] parseFields(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            String headString = new String(ByteStreamsKt.readBytes((InputStream)inputStream), Charsets.UTF_8);
            return this.parseFields(headString);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SeqLogField[] parseFields(@NotNull String headString) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)headString, (String)"headString");
            char[] cArray = new char[]{','};
            Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)headString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                void str;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int indexOfColon = StringsKt.indexOf$default((CharSequence)((CharSequence)str), (char)':', (int)0, (boolean)false, (int)6, null);
                String name2 = null;
                SeqLogField.FieldValueType valueType = null;
                if (indexOfColon > 0) {
                    String string3 = str.substring(0, indexOfColon - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    name2 = string3;
                    String string4 = str.substring(indexOfColon + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    valueType = SeqLogField.FieldValueType.valueOf(string4);
                } else {
                    name2 = str;
                    valueType = SeqLogField.FieldValueType.String;
                }
                collection.add(new SeqLogField(name2, (int)index2, valueType));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new SeqLogField[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SeqLogField.FieldValueType.values().length];
            try {
                nArray[SeqLogField.FieldValueType.LongDecimal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SeqLogField.FieldValueType.LongHexadecimal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

