/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.backup.sequenceLog.AbstractSeqLogger;
import kd.bos.olapServer2.backup.sequenceLog.FaultToleranceCustomer;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogDirectoryEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogFileWriterEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV1FileEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV2FileEntry;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BS\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u000e\u0010\u0010\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0006\u0010 \u001a\u00020\u001eJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0004\b&\u0010'J\n\u0010(\u001a\u00060\u0006j\u0002`\u0007J\u001b\u0010)\u001a\u00020\u00162\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0002J\r\u0010/\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b0J\u001a\u00101\u001a\u00020\u001e2\n\u00102\u001a\u00060\u0006j\u0002`\u00072\u0006\u00103\u001a\u00020\u0014R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogger;", "Lkd/bos/olapServer2/backup/sequenceLog/AbstractSeqLogger;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "fileMaxNumber", "", "Lkd/bos/olapServer2/common/long;", "zipFilesCount", "", "Lkd/bos/olapServer2/common/int;", "faultToleranceSize", "threadPool", "Ljava/util/concurrent/ExecutorService;", "seqLogNameStrategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "archiveDir", "(Ljava/lang/String;JIILjava/util/concurrent/ExecutorService;Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;Ljava/lang/String;)V", "_cacheWriter", "Lkd/bos/olapServer2/backup/sequenceLog/FaultToleranceCustomer;", "", "_logWriter", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileWriterEntry;", "allowCompress", "", "Lkd/bos/olapServer2/common/bool;", "fileEntry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileEntry;", "allowCompress$bos_olap_core2", "beforeDealZipThing", "", "close", "flush", "getCompressEntries", "", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "reader", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry;", "getCompressEntries$bos_olap_core2", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry;)[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "getLastCommandId", "getOrCreateWriter", "entries", "([Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;)Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileWriterEntry;", "renameOldSeqLogFile", "entry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogV1FileEntry;", "simulateCrash", "simulateCrash$bos_olap_core2", "write", "id", "commandData", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSeqLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeqLogger.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogger\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,190:1\n26#2:191\n*S KotlinDebug\n*F\n+ 1 SeqLogger.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogger\n*L\n130#1:191\n*E\n"})
public final class SeqLogger
extends AbstractSeqLogger {
    @NotNull
    private final String rootPath;
    private final long fileMaxNumber;
    @NotNull
    private final SeqLogNameStrategy seqLogNameStrategy;
    @NotNull
    private final SeqLogFileWriterEntry _logWriter;
    @NotNull
    private final FaultToleranceCustomer<Object> _cacheWriter;

    public SeqLogger(@NotNull String rootPath, long fileMaxNumber, int zipFilesCount, int faultToleranceSize, @NotNull ExecutorService threadPool, @NotNull SeqLogNameStrategy seqLogNameStrategy, @Nullable String archiveDir) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)seqLogNameStrategy, (String)"seqLogNameStrategy");
        super(rootPath, archiveDir, zipFilesCount, threadPool, seqLogNameStrategy, true);
        this.rootPath = rootPath;
        this.fileMaxNumber = fileMaxNumber;
        this.seqLogNameStrategy = seqLogNameStrategy;
        SeqLogEntry[] entries2 = this.getReader$bos_olap_core2().getEntries();
        this._logWriter = this.getOrCreateWriter(entries2);
        this.addInitZipFileTask();
        this.addArchiveFileTask();
        this._cacheWriter = new FaultToleranceCustomer(faultToleranceSize, this._logWriter.getEnd() + 1L, (Function2)new Function2<Long, Object, Unit>(){

            public final void invoke(long id, @NotNull Object cmdData) {
                Intrinsics.checkNotNullParameter((Object)cmdData, (String)"cmdData");
                if (_logWriter.needSplit(fileMaxNumber)) {
                    this.dealZipThing();
                }
                _logWriter.write(id, cmdData);
            }
        });
    }

    public /* synthetic */ SeqLogger(String string2, long l, int n, int n2, ExecutorService executorService, SeqLogNameStrategy seqLogNameStrategy, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            executorService = AbstractSeqLogger.Companion.getDefaultZipThreadPool();
        }
        this(string2, l, n, n2, executorService, seqLogNameStrategy, string3);
    }

    public final long getLastCommandId() {
        return this._logWriter.getEnd();
    }

    private final SeqLogFileWriterEntry getOrCreateWriter(SeqLogEntry[] entries2) {
        SeqLogFileWriterEntry curWriter = null;
        SeqLogEntry lastEntry = null;
        if (!(entries2.length == 0)) {
            SeqLogEntry realLastEntry;
            SeqLogEntry seqLogEntry;
            lastEntry = (SeqLogEntry)ArraysKt.last((Object[])entries2);
            if (lastEntry instanceof SeqLogV2FileEntry && (lastEntry.getEnd() - lastEntry.getStart()) % this.fileMaxNumber < this.fileMaxNumber - 1L) {
                curWriter = new SeqLogFileWriterEntry(this.rootPath, lastEntry.getStart(), lastEntry.getEnd(), ((SeqLogV2FileEntry)lastEntry).getFile(), this.seqLogNameStrategy);
                seqLogEntry = curWriter;
            } else if (lastEntry instanceof SeqLogV1FileEntry) {
                String string2 = ((SeqLogV1FileEntry)lastEntry).getFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                Pair<Long, Long> pair = this.seqLogNameStrategy.getStartAndEnd(string2);
                long start = ((Number)pair.component1()).longValue();
                long end = ((Number)pair.component2()).longValue();
                seqLogEntry = start > end ? this.renameOldSeqLogFile((SeqLogV1FileEntry)lastEntry) : null;
            } else {
                seqLogEntry = realLastEntry = null;
            }
            if (realLastEntry != null) {
                entries2[ArraysKt.getLastIndex((Object[])entries2)] = realLastEntry;
                lastEntry = realLastEntry;
                this.getReader$bos_olap_core2().resetEntries((Function1<TEntry[], TEntry[]>)((Function1)new Function1<SeqLogEntry[], SeqLogEntry[]>(entries2){
                    final /* synthetic */ SeqLogEntry[] $entries;
                    {
                        this.$entries = $entries;
                        super(1);
                    }

                    @NotNull
                    public final SeqLogEntry[] invoke(@NotNull SeqLogEntry[] it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$entries;
                    }
                }));
            }
        }
        if (curWriter == null) {
            SeqLogEntry seqLogEntry = lastEntry;
            long end = seqLogEntry != null ? seqLogEntry.getEnd() : 0L;
            String[] stringArray = new String[]{this.seqLogNameStrategy.getNewFileName(end + 1L, end)};
            String path = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
            curWriter = new SeqLogFileWriterEntry(this.rootPath, end + 1L, end, PathsKt.fileSafeConstructor(path), this.seqLogNameStrategy);
            SeqLogEntry[] newEntries = (SeqLogEntry[])ArraysKt.plus((Object[])entries2, (Object)curWriter);
            this.getReader$bos_olap_core2().resetEntries((Function1<TEntry[], TEntry[]>)((Function1)new Function1<SeqLogEntry[], SeqLogEntry[]>(newEntries){
                final /* synthetic */ SeqLogEntry[] $newEntries;
                {
                    this.$newEntries = $newEntries;
                    super(1);
                }

                @NotNull
                public final SeqLogEntry[] invoke(@NotNull SeqLogEntry[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$newEntries;
                }
            }));
        }
        return curWriter;
    }

    private final SeqLogEntry renameOldSeqLogFile(SeqLogV1FileEntry entry) {
        SeqLogEntry seqLogEntry;
        File oldFile;
        String newFileName = this.seqLogNameStrategy.renameFileName(entry.getStart(), entry.getEnd(), entry.getStartTime(), this.seqLogNameStrategy.getFileSuffix());
        if (!Intrinsics.areEqual((Object)newFileName, (Object)(oldFile = entry.getFile()).getName())) {
            File newFile = Paths.INSTANCE.toFile(this.rootPath, newFileName);
            if (!oldFile.renameTo(newFile)) {
                boolean bl = false;
                String string2 = oldFile + " rename to " + newFileName + " failed!";
                throw new IllegalArgumentException(string2.toString());
            }
            seqLogEntry = new SeqLogV1FileEntry(this.seqLogNameStrategy, newFile);
        } else {
            seqLogEntry = entry;
        }
        return seqLogEntry;
    }

    public final void write(long id, @NotNull Object commandData) {
        Intrinsics.checkNotNullParameter((Object)commandData, (String)"commandData");
        this._cacheWriter.deal(id, commandData);
    }

    @Override
    @NotNull
    public SeqLogEntry[] getCompressEntries$bos_olap_core2(@NotNull SeqLogDirectoryEntry reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object[] allEntries = reader.getEntries();
        if (allEntries.length == 0) {
            boolean $i$f$emptyArray = false;
            return new SeqLogEntry[0];
        }
        Object[] objectArray = allEntries;
        int n = 0;
        int n2 = allEntries.length - 1;
        return (SeqLogEntry[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
    }

    @Override
    public boolean allowCompress$bos_olap_core2(@NotNull SeqLogFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
        return true;
    }

    @Override
    public void beforeDealZipThing() {
        if (this._logWriter.getEnd() < this._logWriter.getStart()) {
            return;
        }
        SeqLogFileEntry completedFile = this._logWriter.splitFile();
        this.addToCandidateFileList$bos_olap_core2(completedFile);
        this.getReader$bos_olap_core2().resetEntries((Function1<TEntry[], TEntry[]>)((Function1)new Function1<SeqLogEntry[], SeqLogEntry[]>(this, completedFile){
            final /* synthetic */ SeqLogger this$0;
            final /* synthetic */ SeqLogFileEntry $completedFile;
            {
                this.this$0 = $receiver;
                this.$completedFile = $completedFile;
                super(1);
            }

            @NotNull
            public final SeqLogEntry[] invoke(@NotNull SeqLogEntry[] oldEntries) {
                Intrinsics.checkNotNullParameter((Object)oldEntries, (String)"oldEntries");
                SeqLogEntry[] newEntries = (SeqLogEntry[])ArraysKt.plus((Object[])oldEntries, (Object)SeqLogger.access$get_logWriter$p(this.this$0));
                newEntries[newEntries.length - 2] = this.$completedFile;
                return newEntries;
            }
        }));
    }

    public final void flush() {
        this._cacheWriter.flush();
        this._logWriter.flush();
    }

    @Override
    public void close() {
        this._cacheWriter.flush();
        this._logWriter.flush();
        if (this._logWriter.needSplit(this.fileMaxNumber)) {
            this.dealZipThing();
        }
        this._logWriter.close();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simulateCrash$bos_olap_core2() {
        this._logWriter.simulateCrash$bos_olap_core2();
        this.get_cancelToken().cancel();
        try {
            this.get_zipLock().writeLock().tryLock(120L, TimeUnit.SECONDS);
        }
        finally {
            this.get_zipLock().writeLock().unlock();
        }
    }
}

