/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.backup.sequenceLog.AbstractSeqLogger;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogDirectoryEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogFileEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV2FileEntry;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\b\u0002\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u0019\u0010\u0018\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0014\u0010\u001d\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0010\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020&H\u0002R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "Lkd/bos/olapServer2/backup/sequenceLog/AbstractSeqLogger;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "zipFilesCount", "", "Lkd/bos/olapServer2/common/int;", "seqLogNameStrategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "threadPool", "Ljava/util/concurrent/ExecutorService;", "needZip", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/lang/String;ILkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;Ljava/util/concurrent/ExecutorService;Z)V", "getRootPath", "()Ljava/lang/String;", "addFile", "", "file", "Ljava/io/File;", "sourceFile", "targetFile", "allowCompress", "fileEntry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogFileEntry;", "allowCompress$bos_olap_core2", "beforeDealZipThing", "check16M", "getCompressEntries", "", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "reader", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry;", "getCompressEntries$bos_olap_core2", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry;)[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "resetEntryAndZip", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogV2FileEntry;", "Companion", "bos-olap-core2"})
public final class SeqRedoLogger
extends AbstractSeqLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    @NotNull
    private final SeqLogNameStrategy seqLogNameStrategy;
    private static long redoFileSize = 0x1000000L;

    public SeqRedoLogger(@NotNull String rootPath, int zipFilesCount, @NotNull SeqLogNameStrategy seqLogNameStrategy, @NotNull ExecutorService threadPool, boolean needZip) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)seqLogNameStrategy, (String)"seqLogNameStrategy");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        super(rootPath, null, zipFilesCount, threadPool, seqLogNameStrategy, needZip);
        this.rootPath = rootPath;
        this.seqLogNameStrategy = seqLogNameStrategy;
        if (needZip) {
            this.addInitZipFileTask();
        }
    }

    public /* synthetic */ SeqRedoLogger(String string2, int n, SeqLogNameStrategy seqLogNameStrategy, ExecutorService executorService, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        if ((n2 & 8) != 0) {
            executorService = AbstractSeqLogger.Companion.getDefaultZipThreadPool();
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(string2, n, seqLogNameStrategy, executorService, bl);
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    public final void addFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SeqLogV2FileEntry fileEntry = new SeqLogV2FileEntry(this.seqLogNameStrategy, file);
        this.addToCandidateFileList$bos_olap_core2(fileEntry);
        this.resetEntryAndZip(fileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFile(@NotNull File sourceFile, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        SeqLogV2FileEntry fileEntry = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.get_lock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            FileTools.INSTANCE.copyFileByChannel(sourceFile, targetFile);
            fileEntry = new SeqLogV2FileEntry(this.seqLogNameStrategy, targetFile);
            this.addToCandidateFileList$bos_olap_core2(fileEntry);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.resetEntryAndZip(fileEntry);
    }

    private final void resetEntryAndZip(SeqLogV2FileEntry fileEntry) {
        this.getReader$bos_olap_core2().resetEntries((Function1<TEntry[], TEntry[]>)((Function1)new Function1<SeqLogEntry[], SeqLogEntry[]>(fileEntry){
            final /* synthetic */ SeqLogV2FileEntry $fileEntry;
            {
                this.$fileEntry = $fileEntry;
                super(1);
            }

            @NotNull
            public final SeqLogEntry[] invoke(@NotNull SeqLogEntry[] oldEntries) {
                Intrinsics.checkNotNullParameter((Object)oldEntries, (String)"oldEntries");
                List newEntries = new ArrayList<E>();
                CollectionsKt.addAll((Collection)newEntries, (Object[])oldEntries);
                newEntries.add(this.$fileEntry);
                List $this$sortBy$iv = newEntries;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            SeqLogEntry it = (SeqLogEntry)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(it.getStart());
                            it = (SeqLogEntry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStart()));
                        }
                    });
                }
                Collection $this$toTypedArray$iv = newEntries;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new SeqLogEntry[0]);
            }
        }));
        if (this.getCandidateListSize() >= this.getZipFilesCount()) {
            this.dealZipThing();
        }
    }

    @Override
    @NotNull
    public SeqLogEntry[] getCompressEntries$bos_olap_core2(@NotNull SeqLogDirectoryEntry reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return reader.getEntries();
    }

    @Override
    public boolean allowCompress$bos_olap_core2(@NotNull SeqLogFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
        return this.getNeedZip() && this.check16M(fileEntry.getFile());
    }

    private final boolean check16M(File file) {
        return file.length() == redoFileSize;
    }

    @Override
    public void beforeDealZipThing() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger$Companion;", "", "()V", "<set-?>", "", "redoFileSize", "getRedoFileSize", "()J", "setRedoFileSize", "(J)V", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final long getRedoFileSize() {
            return redoFileSize;
        }

        public final void setRedoFileSize(long l) {
            redoFileSize = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

