/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import kd.bos.olapServer2.backup.sequenceLog.AbstractCompression;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.NotNull;
import org.tukaani.xz.LZMA2Options;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SevenZipCompression;", "Lkd/bos/olapServer2/backup/sequenceLog/AbstractCompression;", "()V", "compress", "Ljava/io/File;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "target", "source", "", "token", "Lkd/bos/olapServer2/common/IContinueToken;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/io/File;Lkd/bos/olapServer2/common/IContinueToken;)Ljava/io/File;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSevenZipCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SevenZipCompression.kt\nkd/bos/olapServer2/backup/sequenceLog/SevenZipCompression\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class SevenZipCompression
extends AbstractCompression {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public File compress(@NotNull String rootPath, @NotNull String target, @NotNull File[] source2, @NotNull IContinueToken token) {
        File file;
        File tmpFile;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        File needDeletedFile = tmpFile = Paths.INSTANCE.toFile(rootPath, target + ".tmp");
        try {
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            Closeable closeable = (Closeable)new SevenZOutputFile(tmpFile);
            Throwable throwable = null;
            try {
                SevenZOutputFile sevenZOutput = (SevenZOutputFile)closeable;
                boolean bl = false;
                sevenZOutput.setContentMethods((Iterable)CollectionsKt.listOf((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)new LZMA2Options(AbstractCompression.Companion.getCompressionRatio()))));
                byte[] byteArrayCache = new byte[16384];
                for (File file2 : source2) {
                    SevenZArchiveEntry entry = new SevenZArchiveEntry();
                    entry.setName(file2.getName());
                    try {
                        BasicFileAttributes attr = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        entry.setCreationDate(new Date(attr.creationTime().toMillis()));
                        entry.setLastModifiedDate(new Date(attr.lastModifiedTime().toMillis()));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    sevenZOutput.putArchiveEntry(entry);
                    Closeable closeable2 = new BufferedInputStream(PathsKt.safeInputStream(file2));
                    Throwable throwable3 = null;
                    try {
                        BufferedInputStream sourceReader = (BufferedInputStream)closeable2;
                        boolean bl2 = false;
                        int length = sourceReader.read(byteArrayCache);
                        while (length >= 0 && token.canContinue()) {
                            sevenZOutput.write(byteArrayCache, 0, length);
                            length = sourceReader.read(byteArrayCache);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    sevenZOutput.closeArchiveEntry();
                }
                sevenZOutput.finish();
                sevenZOutput = Unit.INSTANCE;
            }
            catch (Throwable sevenZOutput) {
                throwable = sevenZOutput;
                throw sevenZOutput;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            File targetFile = Paths.INSTANCE.toFile(rootPath, target);
            boolean success = tmpFile.renameTo(targetFile);
            if (!success) {
                boolean bl = false;
                String[] stringArray = new String[]{target};
                String string2 = tmpFile + " rename to " + Paths.INSTANCE.get(rootPath, stringArray) + " failed.";
                throw new IllegalArgumentException(string2.toString());
            }
            needDeletedFile = null;
            file = targetFile;
        }
        catch (Throwable throwable) {
            block20: {
                File file3 = needDeletedFile;
                if (file3 == null) break block20;
                file3.delete();
            }
            throw throwable;
        }
        return file;
    }
}

