/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogFilter;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogRecord;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0010\u001a\u00060\bj\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0019\u0010\u0014\u001a\u00060\bj\u0002`\u00112\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/StartTimeFilter;", "T", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogFilter;", "startTime", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)V", "_hasMatch", "", "_startDate", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "_startTimeLong", "", "getStartTime", "()Ljava/time/LocalDateTime;", "matchEntry", "Lkd/bos/olapServer2/common/bool;", "entry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "matchRecord", "record", "(Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;)Z", "bos-olap-core2"})
public final class StartTimeFilter<T extends ISeqLogRecord>
implements ISeqLogFilter<T> {
    @NotNull
    private final LocalDateTime startTime;
    private boolean _hasMatch;
    private final long _startTimeLong;
    private final LocalDate _startDate;

    public StartTimeFilter(@NotNull LocalDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.startTime = startTime;
        this._startTimeLong = this.startTime.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
        this._startDate = this.startTime.toLocalDate();
    }

    @NotNull
    public final LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean matchEntry(@NotNull SeqLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        LocalDate localDate = entry.getEndTime();
        return !(localDate != null ? localDate.isBefore(this._startDate) : false);
    }

    @Override
    public boolean matchRecord(@NotNull T record) {
        long beginTime;
        Intrinsics.checkNotNullParameter(record, (String)"record");
        if (this._hasMatch) {
            return true;
        }
        Long l = record.getTime();
        long l2 = beginTime = l != null ? l : Long.MIN_VALUE;
        if (beginTime >= this._startTimeLong) {
            this._hasMatch = true;
            return true;
        }
        return false;
    }
}

