/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u00060\u0003j\u0002`\u00042\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eH\u0016J(\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\rj\u0002`\u000e0\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0016J$\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0016J=\u0010\u0015\u001a\u00060\u0003j\u0002`\u00042\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0010\u00a2\u0006\u0002\b\u0018J:\u0010\u0019\u001a\u00060\u0003j\u0002`\u00042\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/TimeSeqLogNameStrategy;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "prefix", "", "Lkd/bos/olapServer2/common/string;", "fileSuffix", "zipSuffix", "fileSuffix2", "fileHead", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "getNewFileName", "start", "", "Lkd/bos/olapServer2/common/long;", "end", "getStartAndEnd", "Lkotlin/Pair;", "fileName", "getStartAndEndTime", "Ljava/time/LocalDate;", "getZipFileName", "startTime", "endTime", "getZipFileName$bos_olap_core2", "renameFileName", "Companion", "bos-olap-core2"})
public final class TimeSeqLogNameStrategy
extends SeqLogNameStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DateTimeFormatter DATE_TIME_FORMATTER;

    public TimeSeqLogNameStrategy(@NotNull String prefix, @NotNull String fileSuffix, @NotNull String zipSuffix, @NotNull String fileSuffix2, @Nullable Object fileHead) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        Intrinsics.checkNotNullParameter((Object)zipSuffix, (String)"zipSuffix");
        Intrinsics.checkNotNullParameter((Object)fileSuffix2, (String)"fileSuffix2");
        super(prefix, fileSuffix, zipSuffix, fileSuffix2, fileHead, null);
    }

    @Override
    @NotNull
    public String getNewFileName(long start, long end) {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        String nowStr = Companion.toSeqDateString(localDate);
        return this.getPrefix() + '-' + nowStr + '-' + nowStr + '_' + start + '_' + end + this.getFileSuffix2();
    }

    @Override
    @NotNull
    public String renameFileName(long start, long end, @Nullable LocalDate startTime, @NotNull String fileSuffix) {
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        if (!(startTime != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        String nowStr = Companion.toSeqDateString(localDate);
        String startTimeStr = Companion.toSeqDateString(startTime);
        return this.getPrefix() + '-' + startTimeStr + '-' + nowStr + '_' + start + '_' + end + fileSuffix;
    }

    @Override
    @NotNull
    public String getZipFileName$bos_olap_core2(long start, long end, @Nullable LocalDate startTime, @Nullable LocalDate endTime) {
        if (!(startTime != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(endTime != null)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        String startTimeStr = Companion.toSeqDateString(startTime);
        String endTimeStr = Companion.toSeqDateString(endTime);
        return this.getPrefix() + '-' + startTimeStr + '-' + endTimeStr + '_' + start + '_' + end + this.getZipSuffix();
    }

    @Override
    @NotNull
    public Pair<Long, Long> getStartAndEnd(@NotNull String fileName) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            int prefixLength = this.getPrefix().length();
            String string2 = fileName.substring(prefixLength + 1, StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)prefixLength, (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            char[] cArray = new char[]{'_'};
            List versions = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (!(versions.size() == 3)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            pair = new Pair((Object)Long.parseLong((String)versions.get(1)), (Object)Long.parseLong((String)versions.get(2)));
        }
        catch (Throwable e) {
            String string4 = Res.INSTANCE.getSeqLogSettingException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-SeqLogSettingException_1>(...)");
            Object[] objectArray = new Object[]{fileName};
            throw Res.INSTANCE.getRuntimeException(string4, objectArray);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<LocalDate, LocalDate> getStartAndEndTime(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return SeqLogNameStrategy.Companion.splitTime(fileName, this.getPrefix());
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        DATE_TIME_FORMATTER = dateTimeFormatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ\u000e\u0010\n\u001a\u00060\bj\u0002`\t*\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/TimeSeqLogNameStrategy$Companion;", "", "()V", "DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "parseLocalDate", "Ljava/time/LocalDate;", "timeStr", "", "Lkd/bos/olapServer2/common/string;", "toSeqDateString", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toSeqDateString(@NotNull LocalDate $this$toSeqDateString) {
            Intrinsics.checkNotNullParameter((Object)$this$toSeqDateString, (String)"<this>");
            String string2 = DATE_TIME_FORMATTER.format($this$toSeqDateString);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @NotNull
        public final LocalDate parseLocalDate(@NotNull String timeStr) {
            Intrinsics.checkNotNullParameter((Object)timeStr, (String)"timeStr");
            LocalDate localDate = LocalDate.parse(timeStr, DATE_TIME_FORMATTER);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
            return localDate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

