/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\u0004j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u001a\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\n\u0010\u001b\u001a\u00060\u0004j\u0002`\tJ\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u001e\u0010\"\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0004j\u0002`\t2\n\u0010#\u001a\u00060\u0004j\u0002`\tJ\u0006\u0010$\u001a\u00020\u0000J\u0012\u0010%\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0019\u0010*\u001a\u00060\u000fj\u0002`\u00102\n\u0010!\u001a\u00060\u0004j\u0002`\tH\u0086\u0002J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0016\u0010,\u001a\u00060\u0004j\u0002`\t2\n\u0010\u001e\u001a\u00060\u0004j\u0002`\tJ\u000e\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010.\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0004J\u0019\u0010\u0018\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u000fH\u0086\u0002J\u0006\u00100\u001a\u00020\u0007J\b\u00101\u001a\u000202H\u0016R\u0015\u0010\u000b\u001a\u00060\u0004j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lkd/bos/olapServer2/collections/BitSetEx;", "", "()V", "bitSize", "", "(I)V", "words", "", "wordsInUse", "Lkd/bos/olapServer2/common/int;", "([JI)V", "cardinality", "getCardinality", "()I", "isEmpty", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "length", "getLength", "size", "getSize", "and", "", "set", "andNot", "andWithStartPosition", "startPosition", "checkInvariants", "checkRange", "fromIndex", "toIndex", "clear", "bitIndex", "clearOutOfRange", "endPosition", "clone", "containsAll", "ensureCapacity", "wordsRequired", "expandTo", "wordIndex", "get", "nextClearBit", "nextSetBit", "or", "recalculateWordsInUse", "value", "toLongArray", "toString", "", "Companion", "bos-olap-core2"})
public final class BitSetEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] words;
    private int wordsInUse;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;

    public final boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public BitSetEx() {
        this.words = BitSetEx.Companion.initWords(64);
    }

    public BitSetEx(int bitSize) {
        if (bitSize < 0) {
            throw new NegativeArraySizeException("bitSize < 0: " + bitSize);
        }
        this.words = BitSetEx.Companion.initWords(bitSize);
    }

    private BitSetEx(long[] words, int wordsInUse) {
        this.words = words;
        this.wordsInUse = wordsInUse;
    }

    private final void checkInvariants() {
        boolean bl;
        boolean bl2 = bl = this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.wordsInUse >= 0 && this.wordsInUse <= this.words.length;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl4 = bl = this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0L;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
    }

    private final void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0 && this.words[i] == 0L; --i) {
        }
        this.wordsInUse = i + 1;
    }

    @NotNull
    public final long[] toLongArray() {
        long[] lArray = Arrays.copyOf(this.words, this.wordsInUse);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, newSize)");
        return lArray;
    }

    private final void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            long[] lArray = Arrays.copyOf(this.words, request);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, newSize)");
            this.words = lArray;
        }
    }

    private final void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    public final void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex] = this.words[wordIndex] | 1L << bitIndex;
        this.checkInvariants();
    }

    public final void set(int bitIndex, boolean value2) {
        if (value2) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public final void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        this.words[wordIndex] = this.words[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void clear() {
        while (this.wordsInUse > 0) {
            this.wordsInUse += -1;
            this.words[this.wordsInUse] = 0L;
        }
    }

    public final boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = BitSetEx.Companion.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public final int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetEx.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    private final int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetEx.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public final int getLength() {
        return this.wordsInUse == 0 ? 0 : 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public final boolean containsAll(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this.wordsInUse < set.wordsInUse) {
            return false;
        }
        for (int i = set.wordsInUse - 1; -1 < i; --i) {
            long a = this.words[i];
            long b = set.words[i];
            if ((a & b) == b) continue;
            return false;
        }
        return true;
    }

    public final int getCardinality() {
        int sum = 0;
        int n = this.wordsInUse;
        for (int i = 0; i < n; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public final void and(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        while (this.wordsInUse > set.wordsInUse) {
            this.wordsInUse += -1;
            this.words[this.wordsInUse] = 0L;
        }
        int n = this.wordsInUse;
        for (int i = 0; i < n; ++i) {
            this.words[i] = this.words[i] & set.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void andNot(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; -1 < i; --i) {
            this.words[i] = this.words[i] & (set.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void or(@NotNull BitSetEx set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i] = this.words[i] | set.words[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
        this.checkInvariants();
    }

    public final int getSize() {
        return this.words.length * 64;
    }

    @NotNull
    public final BitSetEx clone() {
        long[] lArray = Arrays.copyOf(this.words, this.words.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, size)");
        return new BitSetEx(lArray, this.wordsInUse);
    }

    private final void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public final void clear(int fromIndex, int toIndex) {
        int toIndexTmp = toIndex;
        this.checkRange(fromIndex, toIndexTmp);
        if (fromIndex == toIndexTmp) {
            return;
        }
        int startWordIndex = BitSetEx.Companion.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = BitSetEx.Companion.wordIndex(toIndexTmp - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndexTmp = this.getLength();
            endWordIndex = this.wordsInUse - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndexTmp;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex] = this.words[startWordIndex] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.words[startWordIndex] = this.words[startWordIndex] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            int n = endWordIndex;
            for (int i = startWordIndex + 1; i < n; ++i) {
                this.words[i] = 0L;
            }
            this.words[endWordIndex] = this.words[endWordIndex] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void clearOutOfRange(int startPosition, int endPosition) {
        if (!(startPosition <= endPosition && endPosition < this.getSize())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (startPosition != 0) {
            this.clear(0, startPosition);
        }
        if (endPosition != this.getSize() - 1) {
            this.clear(endPosition + 1, this.getSize());
        }
    }

    public final void andWithStartPosition(@NotNull BitSetEx set, int startPosition) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        int start = BitSetEx.Companion.wordIndex(startPosition);
        while (this.wordsInUse > set.wordsInUse) {
            this.wordsInUse += -1;
            this.words[this.wordsInUse] = 0L;
        }
        int n = this.wordsInUse;
        for (int i = start; i < n; ++i) {
            this.words[i] = this.words[i] & set.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    @NotNull
    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse > 128 ? this.getCardinality() : this.wordsInUse * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        String string2 = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/collections/BitSetEx$Companion;", "", "()V", "ADDRESS_BITS_PER_WORD", "", "BITS_PER_WORD", "WORD_MASK", "", "initWords", "", "bitSize", "wordIndex", "bitIndex", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final long[] initWords(int bitSize) {
            return new long[this.wordIndex(bitSize - 1) + 1];
        }

        private final int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

