/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import kd.bos.olapServer2.collections.AlwaysTrueList;
import kd.bos.olapServer2.collections.IImmutableBitSet;
import kd.bos.olapServer2.collections.ImmutableBitSet;
import kd.bos.olapServer2.collections.ImmutableBitSetMore;
import kd.bos.olapServer2.collections.ImmutableBitSetOne;
import kd.bos.olapServer2.collections.ImmutableBitSetTwo;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\b \u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H&J\b\u0010\u000e\u001a\u00020\u0000H&J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H&J\f\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H&J\u0014\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0016\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/collections/ImmutableBitSet;", "", "size", "", "Lkd/bos/olapServer2/common/int;", "(I)V", "isEmpty", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "getSize", "()I", "and", "other", "clone", "or", "toString", "", "Lkd/bos/olapServer2/common/string;", "value", "", "Companion", "bos-olap-core2"})
public abstract class ImmutableBitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;

    public ImmutableBitSet(int size) {
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    public abstract boolean isEmpty();

    @NotNull
    public abstract ImmutableBitSet or(@NotNull ImmutableBitSet var1);

    @NotNull
    public abstract ImmutableBitSet and(@NotNull ImmutableBitSet var1);

    @NotNull
    public abstract ImmutableBitSet clone();

    @NotNull
    public abstract String toString();

    @NotNull
    protected final String toString(@NotNull long[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        StringBuilder result2 = new StringBuilder("{");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!CommonTypesKt.getBit(value2[i / 64], i % 64)) continue;
            if (result2.length() > 1) {
                result2.append(',');
            }
            result2.append(i);
        }
        result2.append('}');
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\b\u001a\u00020\t2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J(\u0010\n\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0011\u001a\u00020\fJ\u001a\u0010\u0012\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0013\u001a\u00020\fJi\u0010\u0014\u001a\u00020\u00152\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172B\u0010\u0018\u001a>\u0012\u0017\u0012\u00150\u001aj\u0002`\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u0016\u0012\u0017\u0012\u00150\u0006j\u0002`\u0007\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u0019H\u0082\b\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/collections/ImmutableBitSet$Companion;", "", "()V", "create", "Lkd/bos/olapServer2/collections/ImmutableBitSet;", "size", "", "Lkd/bos/olapServer2/common/int;", "createAlwaysTrue", "Lkd/bos/olapServer2/collections/IImmutableBitSet;", "createWithCore", "indexArray", "", "boolFlg", "", "Lkd/bos/olapServer2/common/bool;", "createWithFalse", "falseArray", "createWithTrue", "trueArray", "initValueCore", "", "value", "", "call", "Lkotlin/Function2;", "", "Lkd/bos/olapServer2/common/long;", "Lkotlin/ParameterName;", "name", "elem", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nImmutableBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableBitSet.kt\nkd/bos/olapServer2/collections/ImmutableBitSet$Companion\n*L\n1#1,461:1\n64#1,7:462\n64#1,7:469\n64#1,7:476\n*S KotlinDebug\n*F\n+ 1 ImmutableBitSet.kt\nkd/bos/olapServer2/collections/ImmutableBitSet$Companion\n*L\n78#1:462,7\n83#1:469,7\n93#1:476,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImmutableBitSet create(int size) {
            ImmutableBitSet immutableBitSet;
            if (size < 0) {
                throw new NotSupportedException();
            }
            if (size <= 64) {
                immutableBitSet = new ImmutableBitSetOne(size, 0L);
            } else if (size <= 128) {
                immutableBitSet = new ImmutableBitSetTwo(size, 0L, 0L);
            } else {
                int n = 0;
                int n2 = (size - 1) / 64 + 1;
                long[] lArray = new long[n2];
                int n3 = size;
                while (n < n2) {
                    int n4 = n++;
                    lArray[n4] = 0L;
                }
                long[] lArray2 = lArray;
                int n5 = n3;
                immutableBitSet = new ImmutableBitSetMore(n5, lArray2);
            }
            return immutableBitSet;
        }

        @NotNull
        public final ImmutableBitSet createWithTrue(int size, @NotNull int[] trueArray) {
            Intrinsics.checkNotNullParameter((Object)trueArray, (String)"trueArray");
            return this.createWithCore(size, trueArray, true);
        }

        @NotNull
        public final ImmutableBitSet createWithFalse(int size, @NotNull int[] falseArray) {
            Intrinsics.checkNotNullParameter((Object)falseArray, (String)"falseArray");
            return this.createWithCore(size, falseArray, false);
        }

        @NotNull
        public final IImmutableBitSet createAlwaysTrue(int size) {
            return new AlwaysTrueList(size);
        }

        private final void initValueCore(int size, int[] indexArray, long[] value2, Function2<? super Long, ? super Integer, Long> call2) {
            boolean $i$f$initValueCore = false;
            for (int elem : indexArray) {
                if (!(0 <= elem ? elem < size : false)) {
                    String string2 = Res.INSTANCE.getMutableBitSetException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MutableBitSetException_1>(...)");
                    Object[] objectArray = new Object[]{elem, size};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                value2[elem / 64] = ((Number)call2.invoke((Object)value2[elem / 64], (Object)(elem % 64))).longValue();
            }
        }

        private final ImmutableBitSet createWithCore(int size, int[] indexArray, boolean boolFlg) {
            ImmutableBitSet immutableBitSet;
            KFunction call2 = boolFlg ? (KFunction)createWithCore.call.1.INSTANCE : (KFunction)createWithCore.call.2.INSTANCE;
            if (size < 0) {
                throw new NotSupportedException();
            }
            if (size <= 64) {
                long[] lArray;
                long[] lArray2;
                if (boolFlg) {
                    lArray2 = new long[]{0L};
                    lArray = lArray2;
                } else {
                    lArray2 = new long[]{-1L << 64 - size >>> 64 - size};
                    lArray = lArray2;
                }
                long[] value2 = lArray;
                Companion this_$iv = this;
                boolean $i$f$initValueCore = false;
                for (int elem$iv : indexArray) {
                    if (!(0 <= elem$iv ? elem$iv < size : false)) {
                        String string2 = Res.INSTANCE.getMutableBitSetException_1();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MutableBitSetException_1>(...)");
                        Object[] objectArray = new Object[]{elem$iv, size};
                        throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                    }
                    value2[elem$iv / 64] = ((Number)((Function2)call2).invoke((Object)value2[elem$iv / 64], (Object)(elem$iv % 64))).longValue();
                }
                immutableBitSet = new ImmutableBitSetOne(size, value2[0]);
            } else if (size <= 128) {
                long[] lArray;
                Object this_$iv;
                if (boolFlg) {
                    this_$iv = new long[]{0L, 0L};
                    lArray = this_$iv;
                } else {
                    this_$iv = new long[]{-1L, -1L << 64 - size >>> 64 - size};
                    lArray = this_$iv;
                }
                long[] value3 = lArray;
                this_$iv = this;
                boolean $i$f$initValueCore = false;
                for (int elem$iv : indexArray) {
                    if (!(0 <= elem$iv ? elem$iv < size : false)) {
                        String string3 = Res.INSTANCE.getMutableBitSetException_1();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-MutableBitSetException_1>(...)");
                        Object[] objectArray = new Object[]{elem$iv, size};
                        throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                    }
                    value3[elem$iv / 64] = ((Number)((Function2)call2).invoke((Object)value3[elem$iv / 64], (Object)(elem$iv % 64))).longValue();
                }
                immutableBitSet = new ImmutableBitSetTwo(size, value3[0], value3[1]);
            } else {
                Object this_$iv2;
                int $i$f$initValueCore = (size - 1) / 64 + 1;
                long[] lArray = new long[$i$f$initValueCore];
                for (int this_$iv2 = 0; this_$iv2 < $i$f$initValueCore; ++this_$iv2) {
                    int n = this_$iv2;
                    lArray[n] = boolFlg ? 0L : -1L;
                }
                long[] it = this_$iv2 = lArray;
                boolean bl = false;
                if (!boolFlg) {
                    int blankSize = 64 - size % 64;
                    it[ArraysKt.getLastIndex((long[])it)] = -1L << blankSize >>> blankSize;
                }
                long[] value4 = this_$iv2;
                this_$iv2 = this;
                boolean $i$f$initValueCore2 = false;
                for (int elem$iv : indexArray) {
                    if (!(0 <= elem$iv ? elem$iv < size : false)) {
                        String string4 = Res.INSTANCE.getMutableBitSetException_1();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-MutableBitSetException_1>(...)");
                        Object[] objectArray = new Object[]{elem$iv, size};
                        throw Res.INSTANCE.getRuntimeException(string4, objectArray);
                    }
                    value4[elem$iv / 64] = ((Number)((Function2)call2).invoke((Object)value4[elem$iv / 64], (Object)(elem$iv % 64))).longValue();
                }
                immutableBitSet = new ImmutableBitSetMore(size, value4);
            }
            return immutableBitSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

