/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.Iterator;
import kd.bos.olapServer2.collections.IntMaps;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.metadata.xObjectStorages.IntKeyValue;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u00044567B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J\u0014\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\u0018\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0015\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040)H\u0096\u0002J\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0006J \u0010-\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010.\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u00101\u001a\u000202H\u0016J\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000)R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0013X\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u0012\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lkd/bos/olapServer2/collections/IntHashMap;", "T", "", "", "Lkd/bos/olapServer2/metadata/xObjectStorages/IntKeyValue;", "capacity", "", "_factor", "", "(ID)V", "_key", "", "_mask", "_n", "_nhi", "_nlo", "_nmax", "_shift", "_value", "", "get_value$annotations", "()V", "[Ljava/lang/Object;", "size", "getSize", "()I", "clear", "", "containsKey", "", "Lkd/bos/olapServer2/common/bool;", "key", "foreach", "onItem", "Lkd/bos/olapServer2/collections/IntMaps$OnItemAction;", "get", "(I)Ljava/lang/Object;", "grow", "hash", "indexOf", "iterator", "", "keyIterator", "Lkotlin/collections/IntIterator;", "remove", "set", "value", "(ILjava/lang/Object;)Ljava/lang/Object;", "setCapacity", "toString", "", "valueIterator", "Companion", "IntHashMapKeyIterator", "IntHashMapValueIterator", "IntValueIterator", "bos-olap-core2"})
public final class IntHashMap<T>
implements Iterable<IntKeyValue<? extends T>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double _factor;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    @NotNull
    private int[] _key;
    @NotNull
    private T[] _value;
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;

    @JvmOverloads
    public IntHashMap(int capacity, double _factor) {
        this._factor = _factor;
        this._key = CommonTypesKt.getEmptyIntArray();
        int n = 0;
        Object[] objectArray = new Object[]{};
        IntHashMap intHashMap = this;
        while (n < 0) {
            int n2 = n++;
            objectArray[n2] = null;
        }
        intHashMap._value = objectArray;
        this.setCapacity(capacity);
    }

    public /* synthetic */ IntHashMap(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        if ((n2 & 2) != 0) {
            d = 0.25;
        }
        this(n, d);
    }

    private static /* synthetic */ void get_value$annotations() {
    }

    public final void clear() {
        this._n = 0;
        int n = this._nmax;
        for (int i = 0; i < n; ++i) {
            this._value[i] = null;
        }
    }

    @Nullable
    public final T get(int key2) {
        return this._value[this.indexOf(key2)];
    }

    public final int getSize() {
        return this._n;
    }

    public final boolean containsKey(int key2) {
        return this._value[this.indexOf(key2)] != null;
    }

    public final boolean remove(int key2) {
        int i = this.indexOf(key2);
        if (this._value[i] == null) {
            return false;
        }
        this._n += -1;
        while (true) {
            this._value[i] = null;
            int j = i;
            int r = 0;
            while (true) {
                if (this._value[i = i - 1 & this._mask] == null) {
                    return true;
                }
                r = this.hash(this._key[i]);
                if (i <= r ? r < j : false) continue;
                if (r + 1 <= j ? j < i : false) continue;
                boolean bl = j + 1 <= i ? i <= r : false;
                if (!bl) break;
            }
            this._key[j] = this._key[i];
            this._value[j] = this._value[i];
        }
    }

    @Nullable
    public final T set(int key2, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        int i = this.indexOf(key2);
        T old = this._value[i];
        if (old != null) {
            this._value[i] = value2;
        } else {
            this._key[i] = key2;
            this._value[i] = value2;
            this.grow();
        }
        return old;
    }

    private final int hash(int key2) {
        return 1327217885 * key2 >> this._shift & this._mask;
    }

    private final int indexOf(int key2) {
        int i = this.hash(key2);
        T[] values = this._value;
        int[] keys = this._key;
        while (values[i] != null) {
            if (keys[i] == key2) {
                return i;
            }
            i = i - 1 & this._mask;
        }
        return i;
    }

    private final void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        int n = this._nlo + 1;
        int n2 = this._nhi;
        int n3 = this._n;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            this.setCapacity(this._n);
        }
    }

    private final void setCapacity(int capacity) {
        int nmax;
        int newCapacity = capacity;
        if (newCapacity < this._n) {
            newCapacity = this._n;
        }
        double factor = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int nbit = 1;
        for (nmax = 2; (double)nmax * factor < (double)newCapacity && nmax < 0x40000000; nmax *= 2) {
            ++nbit;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = (int)((double)nmax * factor);
        this._nhi = (int)((double)0x40000000 * factor);
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        int[] key2 = this._key;
        T[] value2 = this._value;
        this._n = 0;
        this._key = new int[nmax];
        this._value = new Object[nmax];
        for (int i = 0; i < nold; ++i) {
            T v = value2[i];
            if (v == null) continue;
            this.set(key2[i], v);
        }
    }

    @NotNull
    public final IntIterator keyIterator() {
        return new IntHashMapKeyIterator();
    }

    @NotNull
    public final Iterator<T> valueIterator() {
        return new IntHashMapValueIterator();
    }

    @Override
    @NotNull
    public Iterator<IntKeyValue<T>> iterator() {
        return new IntValueIterator();
    }

    public final void foreach(@NotNull IntMaps.OnItemAction<T> onItem) {
        Intrinsics.checkNotNullParameter(onItem, (String)"onItem");
        int[] key2 = this._key;
        T[] value2 = this._value;
        int n = key2.length;
        for (int i = 0; i < n; ++i) {
            T v = value2[i];
            if (v == null) continue;
            onItem.accept(key2[i], v);
        }
    }

    @NotNull
    public String toString() {
        IntIterator itr = new IntHashMapKeyIterator();
        StringBuilder sb = new StringBuilder();
        while (itr.hasNext()) {
            int key2 = itr.nextInt();
            T value2 = this.get(key2);
            sb.append(key2 + " -> " + value2 + ", ");
            if (sb.length() <= 1000) continue;
            sb.append(" ...");
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @JvmOverloads
    public IntHashMap(int capacity) {
        this(capacity, 0.0, 2, null);
    }

    @JvmOverloads
    public IntHashMap() {
        this(0, 0.0, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/collections/IntHashMap$Companion;", "", "()V", "NBIT", "", "NMAX", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/collections/IntHashMap$IntHashMapKeyIterator;", "Lkotlin/collections/IntIterator;", "(Lkd/bos/olapServer2/collections/IntHashMap;)V", "i", "", "hasNext", "", "nextInt", "bos-olap-core2"})
    private final class IntHashMapKeyIterator
    extends IntIterator {
        private int i = 0;

        public boolean hasNext() {
            while (this.i < IntHashMap.this._key.length) {
                if (IntHashMap.this._value[this.i] != null) {
                    return true;
                }
                int n = this.i;
                this.i = n + 1;
            }
            return false;
        }

        public int nextInt() {
            int n = this.i;
            this.i = n + 1;
            return IntHashMap.this._key[n];
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0007\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/collections/IntHashMap$IntHashMapValueIterator;", "", "(Lkd/bos/olapServer2/collections/IntHashMap;)V", "i", "", "hasNext", "", "next", "()Ljava/lang/Object;", "bos-olap-core2"})
    private final class IntHashMapValueIterator
    implements Iterator<T>,
    KMappedMarker {
        private int i = 0;

        @Override
        public boolean hasNext() {
            while (this.i < IntHashMap.this._key.length) {
                if (IntHashMap.this._value[this.i] != null) {
                    return true;
                }
                int n = this.i;
                this.i = n + 1;
            }
            return false;
        }

        @Override
        @NotNull
        public T next() {
            int n = this.i;
            this.i = n + 1;
            Object object2 = IntHashMap.this._value[n];
            Intrinsics.checkNotNull((Object)object2);
            return object2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/collections/IntHashMap$IntValueIterator;", "", "Lkd/bos/olapServer2/metadata/xObjectStorages/IntKeyValue;", "(Lkd/bos/olapServer2/collections/IntHashMap;)V", "i", "", "hasNext", "", "next", "bos-olap-core2"})
    private final class IntValueIterator
    implements Iterator<IntKeyValue<? extends T>>,
    KMappedMarker {
        private int i = 0;

        @Override
        public boolean hasNext() {
            while (this.i < IntHashMap.this._key.length) {
                if (IntHashMap.this._value[this.i] != null) {
                    return true;
                }
                int n = this.i;
                this.i = n + 1;
            }
            return false;
        }

        @Override
        @NotNull
        public IntKeyValue<T> next() {
            int n = this.i;
            this.i = n + 1;
            int p = n;
            int n2 = IntHashMap.this._key[p];
            Object object2 = IntHashMap.this._value[p];
            Intrinsics.checkNotNull((Object)object2);
            return new IntKeyValue<Object>(n2, object2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

