/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import kd.bos.olapServer2.common.CommonTypesKt;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 /2\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00012\u00020\u0004:\u0002/0B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00020\u000f\"\u00020\u0002J\u0006\u0010\u001b\u001a\u00020\u0019J\u0011\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0002H\u0086\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001J\u001a\u0010\u001d\u001a\u00020\u00112\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030 H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\u00112\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001J\u001a\u0010$\u001a\u00020\u00112\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030 H\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002H\u0002J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\t\u0010*\u001a\u00020\"H\u0096\u0002J\u000e\u0010+\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0006\u0010-\u001a\u00020\u000fJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lkd/bos/olapServer2/collections/IntHashSet;", "", "", "Lkd/bos/olapServer2/common/int;", "Ljava/io/Serializable;", "capacity", "ndv", "(II)V", "_mask", "_nhi", "_nlo", "_nmax", "_shift", "_size", "_values", "", "isEmpty", "", "()Z", "size", "getSize", "()I", "add", "value", "addRange", "", "values", "clear", "contains", "containsAll", "other", "it", "", "containsIntAll", "Lkotlin/collections/IntIterator;", "containsIntSome", "containsSome", "except", "hash", "key", "indexOf", "intersect", "iterator", "remove", "setCapacity", "toArray", "union", "Companion", "IntHashSetIterator", "bos-olap-core2"})
public final class IntHashSet
implements Iterable<Integer>,
Serializable,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int ndv;
    private int _nmax;
    private int _size;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    @NotNull
    private int[] _values;
    private static final int NBIT = 30;
    private static final int MAX_SIZE = 0x40000000;

    @JvmOverloads
    public IntHashSet(int capacity, int ndv) {
        this.ndv = ndv;
        this._values = CommonTypesKt.getEmptyIntArray();
        this.setCapacity(capacity);
    }

    public /* synthetic */ IntHashSet(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 8;
        }
        if ((n3 & 2) != 0) {
            n2 = Integer.MIN_VALUE;
        }
        this(n, n2);
    }

    public final void clear() {
        this._size = 0;
        int n = this._nmax;
        for (int i = 0; i < n; ++i) {
            this._values[i] = this.ndv;
        }
    }

    public final int getSize() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    @NotNull
    public final int[] toArray() {
        int index2 = 0;
        int[] values = new int[this._size];
        int n = this._values.length;
        for (int v = 0; v < n; ++v) {
            if (this._values[v] == this.ndv) continue;
            values[index2++] = this._values[v];
        }
        return values;
    }

    public final boolean contains(int value2) {
        return this._values[this.indexOf(value2)] != this.ndv;
    }

    public final boolean remove(int value2) {
        int i = this.indexOf(value2);
        if (this._values[i] == this.ndv) {
            return false;
        }
        this._size += -1;
        while (true) {
            this._values[i] = this.ndv;
            int j = i;
            int r = 0;
            do {
                if (this._values[i = i - 1 & this._mask] != this.ndv) continue;
                return true;
            } while ((r = this.hash(this._values[i])) < j && (i <= r || j < i) || j < i && i <= r);
            this._values[j] = this._values[i];
        }
    }

    public final boolean add(int value2) {
        boolean bl;
        if (value2 == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int i = this.indexOf(value2);
        if (this._values[i] == this.ndv) {
            ++this._size;
            this._values[i] = value2;
            if (this._size > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this._nlo < this._size && this._size <= this._nhi) {
                this.setCapacity(this._size);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void addRange(int ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        for (int value2 : values) {
            this.add(value2);
        }
    }

    private final int hash(int key2) {
        return 1327217885 * key2 >> this._shift & this._mask;
    }

    private final int indexOf(int value2) {
        int i = this.hash(value2);
        while (this._values[i] != this.ndv) {
            if (this._values[i] == value2) {
                return i;
            }
            i = i - 1 & this._mask;
        }
        return i;
    }

    private final void setCapacity(int capacity) {
        int nmax;
        int newCapacity = capacity;
        if (newCapacity < this._size) {
            newCapacity = this._size;
        }
        int nbit = 1;
        for (nmax = 2; nmax < newCapacity * 4 && nmax < 0x40000000; nmax *= 2) {
            ++nbit;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = nmax / 4;
        this._nhi = 0x10000000;
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        this._size = 0;
        int[] oldValues = this._values;
        this._values = new int[nmax];
        Arrays.fill(this._values, this.ndv);
        if (!(oldValues.length == 0)) {
            for (int i = 0; i < nold; ++i) {
                int value2 = oldValues[i];
                if (value2 == this.ndv) continue;
                ++this._size;
                this._values[this.indexOf((int)value2)] = value2;
            }
        }
    }

    @NotNull
    public IntIterator iterator() {
        return new IntHashSetIterator();
    }

    @NotNull
    public final IntHashSet union(@NotNull IntHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntHashSet n = new IntHashSet(this._size + other._size, 0, 2, null);
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            n.add(it.nextInt());
        }
        it = other.iterator();
        while (it.hasNext()) {
            n.add(it.nextInt());
        }
        return n;
    }

    @NotNull
    public final IntHashSet intersect(@NotNull IntHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntHashSet n = new IntHashSet(this._size, 0, 2, null);
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.nextInt();
            if (!other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }

    @NotNull
    public final IntHashSet except(@NotNull IntHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntHashSet n = new IntHashSet(this._size, 0, 2, null);
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.nextInt();
            if (other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }

    public final boolean containsAll(@NotNull Iterable<Integer> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterator<Integer> it = other.iterator();
        return it instanceof IntIterator ? this.containsIntAll((IntIterator)it) : this.containsAll(it);
    }

    private final boolean containsIntAll(IntIterator it) {
        while (it.hasNext()) {
            if (this.contains(it.nextInt())) continue;
            return false;
        }
        return true;
    }

    private final boolean containsAll(Iterator<Integer> it) {
        while (it.hasNext()) {
            if (this.contains(((Number)it.next()).intValue())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsSome(@NotNull Iterable<Integer> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterator<Integer> it = other.iterator();
        return it instanceof IntIterator ? this.containsIntSome((IntIterator)it) : this.containsSome(it);
    }

    private final boolean containsIntSome(IntIterator it) {
        while (it.hasNext()) {
            if (!this.contains(it.nextInt())) continue;
            return true;
        }
        return false;
    }

    private final boolean containsSome(Iterator<Integer> it) {
        while (it.hasNext()) {
            if (!this.contains(((Number)it.next()).intValue())) continue;
            return true;
        }
        return false;
    }

    @JvmOverloads
    public IntHashSet(int capacity) {
        this(capacity, 0, 2, null);
    }

    @JvmOverloads
    public IntHashSet() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/collections/IntHashSet$Companion;", "", "()V", "MAX_SIZE", "", "NBIT", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/collections/IntHashSet$IntHashSetIterator;", "Lkotlin/collections/IntIterator;", "Ljava/io/Serializable;", "(Lkd/bos/olapServer2/collections/IntHashSet;)V", "i", "", "hasNext", "", "nextInt", "bos-olap-core2"})
    private final class IntHashSetIterator
    extends IntIterator
    implements Serializable {
        private int i;

        public boolean hasNext() {
            while (this.i < IntHashSet.this._values.length) {
                if (IntHashSet.this._values[this.i] != IntHashSet.this.ndv) {
                    return true;
                }
                int n = this.i;
                this.i = n + 1;
            }
            return false;
        }

        public int nextInt() {
            int n = this.i;
            this.i = n + 1;
            return IntHashSet.this._values[n];
        }
    }
}

