/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer2.collections.SpinWait;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\b\u0000\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u001e\u001fB!\u0012\f\b\u0002\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0013\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/collections/LockFreeQueue;", "T", "", "blockSize", "", "Lkd/bos/olapServer2/common/int;", "allowDiscard", "", "Lkd/bos/olapServer2/common/bool;", "(IZ)V", "_head", "Lkd/bos/olapServer2/collections/LockFreeQueue$Node;", "_size", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAllowDiscard", "()Z", "getBlockSize", "()I", "isEmpty", "addToList", "", "node", "items", "", "popTo", "push", "item", "(Ljava/lang/Object;)V", "tryPop", "()Ljava/lang/Object;", "Companion", "Node", "bos-olap-core2"})
public final class LockFreeQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int blockSize;
    private final boolean allowDiscard;
    @Nullable
    private volatile Node<T> _head;
    @NotNull
    private final AtomicInteger _size;
    private static final long valueOffset;
    private static final long headOffset;

    public LockFreeQueue(int blockSize, boolean allowDiscard) {
        this.blockSize = blockSize;
        this.allowDiscard = allowDiscard;
        this._size = new AtomicInteger();
        int n = this.blockSize;
        if (!(1 <= n ? n <= Integer.MAX_VALUE : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ LockFreeQueue(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 512;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final boolean getAllowDiscard() {
        return this.allowDiscard;
    }

    public final void push(T item) {
        SpinWait spin = null;
        Node<T> node = new Node<T>(null, item);
        Node<T> head = null;
        int iterations = 0;
        while (true) {
            if (this._size.get() < this.blockSize) {
                head = this._head;
                node.setNext(head);
                if (Bits.INSTANCE.getUnsafe().compareAndSwapObject(this, headOffset, head, node)) {
                    this._size.incrementAndGet();
                    break;
                }
            } else if (this.allowDiscard) break;
            if (spin == null) {
                if (++iterations <= 200) continue;
                spin = new SpinWait();
                continue;
            }
            spin.spinOnce();
        }
    }

    @Nullable
    public final T tryPop() {
        SpinWait spin = null;
        Node<T> head = null;
        int iterations = 0;
        while ((head = this._head) != null) {
            if (Bits.INSTANCE.getUnsafe().compareAndSwapObject(this, headOffset, head, head.getNext())) {
                this._size.decrementAndGet();
                return head.getValue();
            }
            if (spin == null) {
                if (++iterations <= 200) continue;
                spin = new SpinWait();
                continue;
            }
            spin.spinOnce();
        }
        return null;
    }

    public final void popTo(@NotNull List<T> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        SpinWait spin = null;
        Node<T> head = null;
        int iterations = 0;
        while (true) {
            head = this._head;
            if (Bits.INSTANCE.getUnsafe().compareAndSwapObject(this, headOffset, head, null)) break;
            if (spin == null) {
                if (++iterations <= 200) continue;
                spin = new SpinWait();
                continue;
            }
            spin.spinOnce();
        }
        this.addToList(head, items2);
    }

    private final void addToList(Node<T> node, List<T> items2) {
        int removeSize = 0;
        for (Node<T> current = node; current != null; current = current.getNext()) {
            items2.add(current.getValue());
            --removeSize;
        }
        if (removeSize < 0) {
            this._size.addAndGet(removeSize);
        }
    }

    public final boolean isEmpty() {
        return this._head == null;
    }

    public LockFreeQueue() {
        this(0, false, 3, null);
    }

    static {
        Unsafe unsafe = Bits.INSTANCE.getUnsafe();
        Class<Node> nodeClass = Node.class;
        valueOffset = unsafe.objectFieldOffset(nodeClass.getDeclaredField("value"));
        Class<LockFreeQueue> stackClass = LockFreeQueue.class;
        headOffset = unsafe.objectFieldOffset(stackClass.getDeclaredField("_head"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/collections/LockFreeQueue$Companion;", "", "()V", "headOffset", "", "Lkd/bos/olapServer2/common/long;", "valueOffset", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/collections/LockFreeQueue$Node;", "T", "", "next", "value", "(Lkd/bos/olapServer2/collections/LockFreeQueue$Node;Ljava/lang/Object;)V", "getNext", "()Lkd/bos/olapServer2/collections/LockFreeQueue$Node;", "setNext", "(Lkd/bos/olapServer2/collections/LockFreeQueue$Node;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "bos-olap-core2"})
    private static final class Node<T> {
        @Nullable
        private Node<T> next;
        private final T value;

        public Node(@Nullable Node<T> next, T value2) {
            this.next = next;
            this.value = value2;
        }

        @Nullable
        public final Node<T> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node<T> node) {
            this.next = node;
        }

        public final T getValue() {
            return this.value;
        }
    }
}

