/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableCanSetList;
import kd.bos.olapServer2.collections.IMutableSparseList;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.memoryMappedFiles.IListMetadata;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001!BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b0\u0007\u0012\u001e\u0010\n\u001a\u001a\u0012\b\u0012\u00060\fj\u0002`\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0017\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u00022\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u0013H\u0096\u0002J#\u0010\u001b\u001a\u0004\u0018\u00010\t2\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u001d\u001a\u00060\fj\u0002`\rH\u0086\u0002J\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\n\u0010\u001c\u001a\u00060\fj\u0002`\rH\u0002J\u001d\u0010\u001f\u001a\u00020\u001a2\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0096\u0002J\u001c\u0010 \u001a\u00020\u001a2\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0002R\u0018\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R&\u0010\n\u001a\u001a\u0012\b\u0012\u00060\fj\u0002`\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/collections/MeasureValuesList;", "Lkd/bos/olapServer2/collections/IMutableCanSetList;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "Ljava/io/Flushable;", "listMetadata", "Lkd/bos/olapServer2/memoryMappedFiles/IListMetadata;", "loadedMeasures", "", "Lkd/bos/olapServer2/collections/IMutableSparseList;", "", "measureCreator", "Lkotlin/Function1;", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/memoryMappedFiles/IListMetadata;[Lkd/bos/olapServer2/collections/IMutableSparseList;Lkotlin/jvm/functions/Function1;)V", "_lastMeasure", "_lastMeasureIndex", "count", "", "Lkd/bos/olapServer2/common/rowIdx;", "getCount", "()J", "[Lkd/bos/olapServer2/collections/IMutableSparseList;", "add", "value", "flush", "", "get", "index", "measureIndex", "getMeasure", "set", "setMore", "LazyMeasureValues", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMeasureValuesList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasureValuesList.kt\nkd/bos/olapServer2/collections/MeasureValuesList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class MeasureValuesList
implements IMutableCanSetList<IMeasureValues>,
Flushable {
    @NotNull
    private final IListMetadata listMetadata;
    @NotNull
    private final IMutableSparseList<Object>[] loadedMeasures;
    @NotNull
    private final Function1<Integer, IMutableSparseList<Object>> measureCreator;
    private int _lastMeasureIndex;
    @Nullable
    private IMutableSparseList<Object> _lastMeasure;

    public MeasureValuesList(@NotNull IListMetadata listMetadata, @NotNull IMutableSparseList<Object>[] loadedMeasures, @NotNull Function1<? super Integer, ? extends IMutableSparseList<Object>> measureCreator) {
        Intrinsics.checkNotNullParameter((Object)listMetadata, (String)"listMetadata");
        Intrinsics.checkNotNullParameter(loadedMeasures, (String)"loadedMeasures");
        Intrinsics.checkNotNullParameter(measureCreator, (String)"measureCreator");
        this.listMetadata = listMetadata;
        this.loadedMeasures = loadedMeasures;
        this.measureCreator = measureCreator;
        this._lastMeasureIndex = -1;
    }

    private final IMutableSparseList<Object> getMeasure(int index2) {
        IMutableSparseList iMutableSparseList = this.loadedMeasures[index2];
        if (iMutableSparseList == null) {
            Object object2 = this.measureCreator.invoke((Object)index2);
            IMutableSparseList it = (IMutableSparseList)object2;
            boolean bl = false;
            this.loadedMeasures[index2] = it;
            iMutableSparseList = (IMutableSparseList)object2;
        }
        return iMutableSparseList;
    }

    @Override
    public long add(@NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        long index2 = this.listMetadata.getCount();
        this.set(index2, value2);
        IListMetadata iListMetadata = this.listMetadata;
        long l = iListMetadata.getCount();
        iListMetadata.setCount(l + 1L);
        return index2;
    }

    @Override
    public void set(long index2, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2.getCount() == 1) {
            Object item;
            int mi = value2.getFirstMeasureIndex();
            IMutableSparseList<Object> measure = this._lastMeasure;
            if (mi != this._lastMeasureIndex || measure == null) {
                this._lastMeasure = measure = this.getMeasure(mi);
                this._lastMeasureIndex = mi;
            }
            if ((item = value2.getFirstMeasureValue()) != CommonTypesKt.getIgnoreValue()) {
                measure.set(index2, item);
            }
        } else {
            this.setMore(index2, value2);
        }
    }

    private final void setMore(long index2, IMeasureValues value2) {
        int n = value2.getCount();
        for (int i = 0; i < n; ++i) {
            Object item = value2.getMeasureValue(i);
            if (item == CommonTypesKt.getIgnoreValue()) continue;
            IMutableSparseList<Object> measure = this.getMeasure(value2.getMeasureIndex(i));
            measure.set(index2, item);
        }
    }

    @Override
    @NotNull
    public IMeasureValues get(long index2) {
        return new LazyMeasureValues(index2);
    }

    @Nullable
    public final Object get(long index2, int measureIndex) {
        return this.getMeasure(measureIndex).get(index2);
    }

    @Override
    public void flush() {
        for (IMutableSparseList<Object> list2 : this.loadedMeasures) {
            Flushable flushable = list2 instanceof Flushable ? (Flushable)((Object)list2) : null;
            if (flushable == null) continue;
            flushable.flush();
        }
    }

    @Override
    public long getCount() {
        return this.listMetadata.getCount();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00060\u0007j\u0002`\b2\n\u0010\u000e\u001a\u00060\u0007j\u0002`\bH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u000e\u001a\u00060\u0007j\u0002`\bH\u0016R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/collections/MeasureValuesList$LazyMeasureValues;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "index", "", "Lkd/bos/olapServer2/common/rowIdx;", "(Lkd/bos/olapServer2/collections/MeasureValuesList;J)V", "count", "", "Lkd/bos/olapServer2/common/int;", "getCount", "()I", "getIndex", "()J", "getMeasureIndex", "effectiveMeasureIndex", "getMeasureValue", "", "bos-olap-core2"})
    private final class LazyMeasureValues
    implements IMeasureValues {
        private final long index;

        public LazyMeasureValues(long index2) {
            this.index = index2;
        }

        public final long getIndex() {
            return this.index;
        }

        @Override
        public int getCount() {
            return MeasureValuesList.this.loadedMeasures.length;
        }

        @Override
        @Nullable
        public Object getMeasureValue(int effectiveMeasureIndex) {
            if (!(0 <= effectiveMeasureIndex ? effectiveMeasureIndex < this.getCount() : false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return MeasureValuesList.this.getMeasure(effectiveMeasureIndex).get(this.index);
        }

        @Override
        public int getMeasureIndex(int effectiveMeasureIndex) {
            if (!(0 <= effectiveMeasureIndex ? effectiveMeasureIndex < this.getCount() : false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return effectiveMeasureIndex;
        }

        @Override
        public int getFirstMeasureIndex() {
            return IMeasureValues.DefaultImpls.getFirstMeasureIndex(this);
        }

        @Override
        @Nullable
        public Object getFirstMeasureValue() {
            return IMeasureValues.DefaultImpls.getFirstMeasureValue(this);
        }
    }
}

