/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableArrayLong;
import kd.bos.olapServer2.collections.IMutableCanSetList;
import kd.bos.olapServer2.collections.IMutableSparseList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00028\u00002\n\u0010\u0011\u001a\u00060\tj\u0002`\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\tj\u0002`\u00122\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/collections/MutableSparseListAny;", "E", "Lkd/bos/olapServer2/collections/IMutableSparseList;", "Ljava/io/Flushable;", "left", "Lkd/bos/olapServer2/collections/IMutableArrayLong;", "right", "Lkd/bos/olapServer2/collections/IMutableCanSetList;", "segmentSize", "", "Lkd/bos/olapServer2/common/long;", "defaultValue", "(Lkd/bos/olapServer2/collections/IMutableArrayLong;Lkd/bos/olapServer2/collections/IMutableCanSetList;JLjava/lang/Object;)V", "Ljava/lang/Object;", "flush", "", "get", "index", "Lkd/bos/olapServer2/common/rowIdx;", "(J)Ljava/lang/Object;", "set", "value", "(JLjava/lang/Object;)V", "bos-olap-core2"})
public final class MutableSparseListAny<E>
implements IMutableSparseList<E>,
Flushable {
    @NotNull
    private final IMutableArrayLong left;
    @NotNull
    private final IMutableCanSetList<E> right;
    private final long segmentSize;
    private final E defaultValue;

    public MutableSparseListAny(@NotNull IMutableArrayLong left, @NotNull IMutableCanSetList<E> right, long segmentSize, E defaultValue) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        this.left = left;
        this.right = right;
        this.segmentSize = segmentSize;
        this.defaultValue = defaultValue;
    }

    @Override
    public E get(long index2) {
        long realSegmentIndex;
        long segmentIndex = index2 / this.segmentSize;
        boolean bl = 0L <= segmentIndex ? segmentIndex < this.left.getLength() : false;
        if (bl && (realSegmentIndex = this.left.get(segmentIndex)) != 0L) {
            long offset = (realSegmentIndex - 1L) * this.segmentSize + index2 % this.segmentSize;
            return this.right.get(offset);
        }
        return this.defaultValue;
    }

    @Override
    public void set(long index2, E value2) {
        long segmentIndex = index2 / this.segmentSize;
        boolean bl = 0L <= segmentIndex ? segmentIndex < this.left.getLength() : false;
        if (bl) {
            long realSegmentIndex = this.left.get(segmentIndex);
            if (realSegmentIndex != 0L) {
                long offset = (realSegmentIndex - 1L) * this.segmentSize + index2 % this.segmentSize;
                this.right.set(offset, value2);
            } else {
                if (Intrinsics.areEqual(value2, this.defaultValue)) {
                    return;
                }
                int segmentOffset = (int)(index2 % this.segmentSize);
                int n = (int)this.segmentSize;
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl2 = false;
                    if (it == segmentOffset) {
                        this.right.add(value2);
                        continue;
                    }
                    this.right.add(this.defaultValue);
                }
                long rightIndex = this.right.getCount() / this.segmentSize;
                this.left.set(segmentIndex, rightIndex);
            }
        } else {
            if (Intrinsics.areEqual(value2, this.defaultValue)) {
                return;
            }
            this.left.resize(segmentIndex + 1L);
            this.set(index2, value2);
        }
    }

    @Override
    public void flush() {
        block1: {
            Object object2 = this.left;
            Flushable flushable = object2 instanceof Flushable ? (Flushable)object2 : null;
            if (flushable != null) {
                flushable.flush();
            }
            object2 = this.right;
            Flushable flushable2 = object2 instanceof Flushable ? (Flushable)object2 : null;
            if (flushable2 == null) break block1;
            flushable2.flush();
        }
    }
}

