/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.Arrays;
import kd.bos.olapServer2.collections.IMapFunction;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\tH\u0002J$\u0010\u000b\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002J\u0016\u0010\u000f\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\tJ\"\u0010\u000f\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0016\u0010\u000f\u001a\u00060\bj\u0002`\t2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\bj\u0002`\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/collections/NumberToNumberMap;", "", "mapFunc", "Lkd/bos/olapServer2/collections/IMapFunction;", "(Lkd/bos/olapServer2/collections/IMapFunction;)V", "arrayCache", "", "getNextCapacity", "", "Lkd/bos/olapServer2/common/int;", "number", "getOrAdd", "str", "", "Lkd/bos/olapServer2/common/string;", "map", "resize", "", "capacity", "Companion", "bos-olap-core2"})
public final class NumberToNumberMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMapFunction mapFunc;
    @NotNull
    private int[] arrayCache;
    private static final int INITIAL_CAPACITY = 256;

    public NumberToNumberMap(@NotNull IMapFunction mapFunc) {
        Intrinsics.checkNotNullParameter((Object)mapFunc, (String)"mapFunc");
        this.mapFunc = mapFunc;
        int n = 0;
        int[] nArray = new int[256];
        NumberToNumberMap numberToNumberMap = this;
        while (n < 256) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        numberToNumberMap.arrayCache = nArray;
    }

    public final int map(int number, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (!(0 <= number ? number < Integer.MAX_VALUE : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (number >= this.arrayCache.length) {
            this.resize(this.getNextCapacity(number));
        }
        return this.getOrAdd(number, str);
    }

    public final int map(int number) {
        if (!(0 <= number ? number < Integer.MAX_VALUE : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int value2 = this.arrayCache[number];
        if (value2 != -1) {
            return value2;
        }
        String string3 = Res.INSTANCE.getNumberToElementMapException_1();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-NumberToElementMapException_1>(...)");
        Object[] objectArray = new Object[]{number};
        throw Res.INSTANCE.getRuntimeException(string3, objectArray);
    }

    public final int map(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.mapFunc.invoke(str);
    }

    private final int getNextCapacity(int number) {
        if (!(0 <= number ? number < Integer.MAX_VALUE : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long newCapacity = this.arrayCache.length;
        while (newCapacity <= (long)number) {
            newCapacity = Math.min(Integer.MAX_VALUE, newCapacity * 2L);
        }
        return (int)newCapacity;
    }

    private final void resize(int capacity) {
        if (!(capacity >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        try {
            int[] nArray = Arrays.copyOf(this.arrayCache, capacity);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            int[] newArray = nArray;
            for (int i = this.arrayCache.length; i < capacity; ++i) {
                newArray[i] = -1;
            }
            this.arrayCache = newArray;
        }
        catch (Throwable _) {
            String string3 = Res.INSTANCE.getCommonException_11();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_11>(...)");
            Object[] objectArray = new Object[]{capacity};
            throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
        }
    }

    private final int getOrAdd(int number, String str) {
        int n;
        if (!(number >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int value2 = this.arrayCache[number];
        if (value2 != -1) {
            n = value2;
        } else {
            int result2;
            this.arrayCache[number] = result2 = this.mapFunc.invoke(str);
            n = result2;
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/collections/NumberToNumberMap$Companion;", "", "()V", "INITIAL_CAPACITY", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

