/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.Arrays;
import kd.bos.olapServer2.collections.IntMaps;
import kd.bos.olapServer2.collections.SplitIntHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001'B3\b\u0002\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u0005H\u0002J\u0014\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u001c\u0010\u0018\u001a\u0004\u0018\u00018\u00002\n\u0010\u0019\u001a\u00060\u0004j\u0002`\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\b2\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u0005H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0004j\u0002`\u0005H\u0002J\u0014\u0010\u001e\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0004j\u0002`\u0005H\u0002J\n\u0010\u001f\u001a\u00060\u0004j\u0002`\u0005J\u0014\u0010 \u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u0005H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J$\u0010\"\u001a\u00020\u00132\n\u0010\u0019\u001a\u00060\u0004j\u0002`\u00052\b\u0010#\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u00052\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bH\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkd/bos/olapServer2/collections/SplitIntHashMap;", "T", "", "_maskSize", "", "Lkd/bos/olapServer2/common/int;", "createSegment", "Lkotlin/Function1;", "", "(ILkotlin/jvm/functions/Function1;)V", "_curLoad", "_item", "[Ljava/lang/Object;", "_map", "_mask", "_maxLoad", "_monitoredSegment", "_segmentSize", "analyse", "", "segmentIndex", "foreach", "onItem", "Lkd/bos/olapServer2/collections/IntMaps$OnItemAction;", "get", "index", "(I)Ljava/lang/Object;", "getSegment", "(I)[Ljava/lang/Object;", "getSegmentIndex", "getSegmentInnerPosition", "maxIndex", "removeSegment", "resizeItem", "set", "value", "(ILjava/lang/Object;)V", "setSegment", "(I[Ljava/lang/Object;)V", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSplitIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitIntHashMap.kt\nkd/bos/olapServer2/collections/SplitIntHashMap\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n26#2:180\n13374#3,3:181\n*S KotlinDebug\n*F\n+ 1 SplitIntHashMap.kt\nkd/bos/olapServer2/collections/SplitIntHashMap\n*L\n25#1:180\n131#1:181,3\n*E\n"})
public final class SplitIntHashMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _maskSize;
    @NotNull
    private final Function1<Integer, T[]> createSegment;
    private final int _mask;
    private final int _segmentSize;
    @NotNull
    private T[] _item;
    @NotNull
    private Object[] _map;
    private final int _maxLoad;
    private int _curLoad;
    private int _monitoredSegment;

    private SplitIntHashMap(int _maskSize, Function1<? super Integer, T[]> createSegment) {
        this._maskSize = _maskSize;
        this.createSegment = createSegment;
        this._mask = (1 << this._maskSize) - 1;
        this._segmentSize = 1 << this._maskSize;
        this._item = (Object[])this.createSegment.invoke((Object)this._segmentSize);
        boolean $i$f$emptyArray = false;
        this._map = new Object[0];
        this._maxLoad = (int)((double)this._segmentSize * 0.66);
        this._monitoredSegment = 1;
    }

    private final int getSegmentIndex(int index2) {
        return index2 >> this._maskSize;
    }

    private final int getSegmentInnerPosition(int index2) {
        return index2 & this._mask;
    }

    private final T[] getSegment(int segmentIndex) {
        Object object2;
        Object[] map2 = this._map;
        return !(0 <= segmentIndex ? segmentIndex < map2.length : false) ? null : ((object2 = map2[segmentIndex]) instanceof Object[] ? (Object[])object2 : null);
    }

    private final void setSegment(int segmentIndex, T[] value2) {
        Object[] map2 = this._map;
        if (!(0 <= segmentIndex ? segmentIndex < map2.length : false)) {
            int newSize = segmentIndex < 4 ? 4 : (segmentIndex + 1) * 2;
            Object[] objectArray = Arrays.copyOf(map2, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            this._map = map2 = objectArray;
        }
        map2[segmentIndex] = value2;
    }

    private final void removeSegment(int segmentIndex) {
        Object[] map2 = this._map;
        boolean bl = 0 <= segmentIndex ? segmentIndex < map2.length : false;
        if (bl) {
            map2[segmentIndex] = null;
        }
    }

    public final void set(int index2, @Nullable T value2) {
        if (!(index2 >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        T[] item = this._item;
        if (index2 < item.length) {
            item[index2] = value2;
        } else {
            int segmentIndex = this.getSegmentIndex(index2);
            int segmentInnerPosition = this.getSegmentInnerPosition(index2);
            T[] segment = this.getSegment(segmentIndex);
            if (segment == null) {
                Object[] newSegment = (Object[])this.createSegment.invoke((Object)this._segmentSize);
                newSegment[segmentInnerPosition] = value2;
                this.setSegment(segmentIndex, newSegment);
            } else {
                segment[segmentInnerPosition] = value2;
            }
            this.analyse(segmentIndex);
        }
    }

    private final void analyse(int segmentIndex) {
        if (segmentIndex == this._monitoredSegment) {
            int n = this._curLoad;
            this._curLoad = n + 1;
            if (n >= this._maxLoad) {
                this.resizeItem();
            }
        }
    }

    private final void resizeItem() {
        int newSize = (int)Long.min((long)(this._monitoredSegment + 1) * 2L * (long)this._segmentSize, Integer.MAX_VALUE);
        int segmentCount = newSize / this._segmentSize;
        Object[] objectArray = Arrays.copyOf(this._item, newSize);
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"copyOf(this, newSize)");
        Object[] newItem = objectArray;
        for (int i = this._monitoredSegment; i < segmentCount; ++i) {
            Object[] segment = this.getSegment(i);
            if (segment == null) continue;
            ArraysKt.copyInto$default((Object[])segment, (Object[])newItem, (int)(i * this._segmentSize), (int)0, (int)0, (int)12, null);
            this.removeSegment(i);
        }
        this._item = newItem;
        this._monitoredSegment = segmentCount;
        this._curLoad = 0;
    }

    @Nullable
    public final T get(int index2) {
        int segmentIndex;
        T[] segment;
        T[] item = this._item;
        return (T)(index2 < item.length ? item[index2] : ((segment = this.getSegment(segmentIndex = this.getSegmentIndex(index2))) == null ? null : segment[this.getSegmentInnerPosition(index2)]));
    }

    /*
     * WARNING - void declaration
     */
    public final void foreach(@NotNull IntMaps.OnItemAction<T> onItem) {
        Intrinsics.checkNotNullParameter(onItem, (String)"onItem");
        T[] item = this._item;
        int n = item.length;
        for (int i = 0; i < n; ++i) {
            T value2 = item[i];
            if (value2 == null) continue;
            onItem.accept(i, value2);
        }
        int segmentSize = this._segmentSize;
        Object[] $this$forEachIndexed$iv = this._map;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            Object[] arr;
            int n2 = index$iv++;
            Object object2 = item$iv;
            int segmentIndex = n2;
            boolean bl = false;
            Object[] objectArray = arr = segment instanceof Object[] ? (Object[])segment : null;
            if (arr == null) continue;
            int s = segmentIndex * segmentSize;
            int n3 = arr.length;
            for (int i = 0; i < n3; ++i) {
                Object value3 = arr[i];
                if (value3 == null) continue;
                onItem.accept(s + i, value3);
            }
        }
    }

    public final int maxIndex() {
        int segmentSize = this._segmentSize;
        for (int i = this._map.length - 1; -1 < i; --i) {
            Object[] segment;
            Object object2 = this._map[i];
            Object[] objectArray = segment = object2 instanceof Object[] ? (Object[])object2 : null;
            if (segment == null) continue;
            int s = i * segmentSize;
            for (int j = segment.length - 1; -1 < j; --j) {
                if (segment[j] == null) continue;
                return s + j;
            }
        }
        T[] item = this._item;
        for (int i = item.length - 1; -1 < i; --i) {
            if (item[i] == null) continue;
            return i;
        }
        return -1;
    }

    public /* synthetic */ SplitIntHashMap(int _maskSize, Function1 createSegment, DefaultConstructorMarker $constructor_marker) {
        this(_maskSize, (Function1<? super Integer, T[]>)createSegment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u0001H\u0086\b\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/collections/SplitIntHashMap$Companion;", "", "()V", "create", "Lkd/bos/olapServer2/collections/SplitIntHashMap;", "T", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T> SplitIntHashMap<T> create() {
            boolean $i$f$create = false;
            Intrinsics.needClassReification();
            return new SplitIntHashMap(8, create.1.INSTANCE, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

