/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0000\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0013\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u0013\u001a\u00020\b2\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u0004H\u0086\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\b2\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u001c\u001a\u00020\u00032\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u001d\u001a\u00020\u00032\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u0004H\u0002J\n\u0010\u001e\u001a\u00060\u0003j\u0002`\u0004J\u0014\u0010\u001f\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\u001d\u0010!\u001a\u00020\u00112\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\"\u001a\u00020\u0019H\u0086\u0002J\u001c\u0010#\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\"\u001a\u00020\bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer2/collections/SplitIntHashMapLong;", "", "_maskSize", "", "Lkd/bos/olapServer2/common/int;", "(I)V", "_curLoad", "_item", "", "_map", "", "[[J", "_mask", "_maxLoad", "_monitoredSegment", "_segmentSize", "analyse", "", "segmentIndex", "createSegment", "size", "foreach", "onItem", "Lkd/bos/olapServer2/collections/SplitIntHashMapLong$OnItemConsumer;", "get", "", "index", "getSegment", "getSegmentIndex", "getSegmentInnerPosition", "maxIndex", "removeSegment", "resizeItem", "set", "value", "setSegment", "Companion", "OnItemConsumer", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSplitIntHashMapLong.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitIntHashMapLong.kt\nkd/bos/olapServer2/collections/SplitIntHashMapLong\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,176:1\n26#2:177\n13374#3,3:178\n*S KotlinDebug\n*F\n+ 1 SplitIntHashMapLong.kt\nkd/bos/olapServer2/collections/SplitIntHashMapLong\n*L\n24#1:177\n129#1:178,3\n*E\n"})
public final class SplitIntHashMapLong {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _maskSize;
    private final int _mask;
    private final int _segmentSize;
    @NotNull
    private long[] _item;
    @NotNull
    private long[][] _map;
    private final int _maxLoad;
    private int _curLoad;
    private int _monitoredSegment;

    private SplitIntHashMapLong(int _maskSize) {
        this._maskSize = _maskSize;
        this._mask = (1 << this._maskSize) - 1;
        this._segmentSize = 1 << this._maskSize;
        this._item = this.createSegment(this._segmentSize);
        boolean $i$f$emptyArray = false;
        this._map = new long[0][];
        this._maxLoad = (int)((double)this._segmentSize * 0.66);
        this._monitoredSegment = 1;
    }

    private final int getSegmentIndex(int index2) {
        return index2 >> this._maskSize;
    }

    private final int getSegmentInnerPosition(int index2) {
        return index2 & this._mask;
    }

    private final long[] createSegment(int size) {
        return new long[size];
    }

    private final long[] getSegment(int segmentIndex) {
        long[][] map2 = this._map;
        return !(0 <= segmentIndex ? segmentIndex < ((Object[])map2).length : false) ? null : map2[segmentIndex];
    }

    private final void setSegment(int segmentIndex, long[] value2) {
        long[][] map2 = this._map;
        if (!(0 <= segmentIndex ? segmentIndex < ((Object[])map2).length : false)) {
            int newSize = segmentIndex < 4 ? 4 : (segmentIndex + 1) * 2;
            Object[] objectArray = Arrays.copyOf((Object[])map2, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            this._map = map2 = (long[][])objectArray;
        }
        map2[segmentIndex] = value2;
    }

    private final void removeSegment(int segmentIndex) {
        long[][] map2 = this._map;
        boolean bl = 0 <= segmentIndex ? segmentIndex < ((Object[])map2).length : false;
        if (bl) {
            map2[segmentIndex] = null;
        }
    }

    public final void set(int index2, long value2) {
        if (!(index2 >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long[] item = this._item;
        if (index2 < item.length) {
            item[index2] = value2;
        } else {
            int segmentIndex = this.getSegmentIndex(index2);
            int segmentInnerPosition = this.getSegmentInnerPosition(index2);
            long[] segment = this.getSegment(segmentIndex);
            if (segment == null) {
                long[] newSegment = this.createSegment(this._segmentSize);
                newSegment[segmentInnerPosition] = value2;
                this.setSegment(segmentIndex, newSegment);
            } else {
                segment[segmentInnerPosition] = value2;
            }
            this.analyse(segmentIndex);
        }
    }

    private final void analyse(int segmentIndex) {
        if (segmentIndex == this._monitoredSegment) {
            int n = this._curLoad;
            this._curLoad = n + 1;
            if (n >= this._maxLoad) {
                this.resizeItem();
            }
        }
    }

    private final void resizeItem() {
        int newSize = (int)Long.min((long)(this._monitoredSegment + 1) * 2L * (long)this._segmentSize, Integer.MAX_VALUE);
        int segmentCount = newSize / this._segmentSize;
        long[] lArray = Arrays.copyOf(this._item, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, newSize)");
        long[] newItem = lArray;
        for (int i = this._monitoredSegment; i < segmentCount; ++i) {
            long[] segment = this.getSegment(i);
            if (segment == null) continue;
            ArraysKt.copyInto$default((long[])segment, (long[])newItem, (int)(i * this._segmentSize), (int)0, (int)0, (int)12, null);
            this.removeSegment(i);
        }
        this._item = newItem;
        this._monitoredSegment = segmentCount;
        this._curLoad = 0;
    }

    public final long get(int index2) {
        int segmentIndex;
        long[] segment;
        long[] item = this._item;
        return index2 < item.length ? item[index2] : ((segment = this.getSegment(segmentIndex = this.getSegmentIndex(index2))) == null ? 0L : segment[this.getSegmentInnerPosition(index2)]);
    }

    /*
     * WARNING - void declaration
     */
    public final void foreach(@NotNull OnItemConsumer onItem) {
        Intrinsics.checkNotNullParameter((Object)onItem, (String)"onItem");
        long[] item = this._item;
        int n = item.length;
        for (int i = 0; i < n; ++i) {
            long value2 = item[i];
            if (value2 == 0L) continue;
            onItem.accept(i, value2);
        }
        int segmentSize = this._segmentSize;
        Object[] $this$forEachIndexed$iv = (Object[])this._map;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n2 = index$iv++;
            long[] lArray = (long[])item$iv;
            int segmentIndex = n2;
            boolean bl = false;
            if (segment == null) continue;
            int s = segmentIndex * segmentSize;
            int n3 = ((void)segment).length;
            for (int i = 0; i < n3; ++i) {
                void value3 = segment[i];
                if (value3 == 0L) continue;
                onItem.accept(s + i, (long)value3);
            }
        }
    }

    public final int maxIndex() {
        int segmentSize = this._segmentSize;
        for (int i = ((Object[])this._map).length - 1; -1 < i; --i) {
            long[] segment = this._map[i];
            if (segment == null) continue;
            int s = i * segmentSize;
            for (int j = segment.length - 1; -1 < j; --j) {
                if (segment[j] == 0L) continue;
                return s + j;
            }
        }
        long[] item = this._item;
        for (int i = item.length - 1; -1 < i; --i) {
            if (item[i] == 0L) continue;
            return i;
        }
        return -1;
    }

    public /* synthetic */ SplitIntHashMapLong(int _maskSize, DefaultConstructorMarker $constructor_marker) {
        this(_maskSize);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/collections/SplitIntHashMapLong$Companion;", "", "()V", "create", "Lkd/bos/olapServer2/collections/SplitIntHashMapLong;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SplitIntHashMapLong create() {
            return new SplitIntHashMapLong(8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/collections/SplitIntHashMapLong$OnItemConsumer;", "", "accept", "", "index", "", "Lkd/bos/olapServer2/common/int;", "value", "", "bos-olap-core2"})
    public static interface OnItemConsumer {
        public void accept(int var1, long var2);
    }
}

