/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.collections;

import java.io.Closeable;
import kd.bos.olapServer2.collections.IImmutableBitmap;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.collections.INumberSetFilter;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00060\u000bj\u0002`\u00162\n\u0010\u0017\u001a\u00060\u000bj\u0002`\fH\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0011\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/collections/VirtualImmutableListLong;", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "Ljava/io/Closeable;", "dataList", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "numberSetFilter", "Lkd/bos/olapServer2/collections/INumberSetFilter;", "(Lkd/bos/olapServer2/collections/IImmutableListInt;Lkd/bos/olapServer2/collections/INumberSetFilter;)V", "_arrayCache", "", "bitCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "getBitCount", "()J", "bitRemCount", "getBitRemCount", "count", "getCount", "close", "", "get", "Lkd/bos/olapServer2/common/long;", "index", "bos-olap-core2"})
public final class VirtualImmutableListLong
implements IImmutableBitmap,
Closeable {
    @NotNull
    private final IImmutableListInt dataList;
    @NotNull
    private final INumberSetFilter numberSetFilter;
    @NotNull
    private final int[] _arrayCache;

    public VirtualImmutableListLong(@NotNull IImmutableListInt dataList, @NotNull INumberSetFilter numberSetFilter) {
        Intrinsics.checkNotNullParameter((Object)dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)numberSetFilter, (String)"numberSetFilter");
        this.dataList = dataList;
        this.numberSetFilter = numberSetFilter;
        this._arrayCache = new int[64];
    }

    @Override
    public long get(long index2) {
        long start = index2 << 6;
        long bitCount = this.dataList.getCount();
        if (!(0L <= start ? start < bitCount : false)) {
            String string2 = Res.INSTANCE.getCommonException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_2>(...)");
            Object[] objectArray = new Object[]{index2, this.getCount()};
            throw Res.INSTANCE.getIndexOutOfBoundsException(string2, objectArray);
        }
        long end = start + (long)64 > bitCount ? start + this.getBitRemCount() : start + (long)64;
        int[] array = this._arrayCache;
        this.dataList.batchGet(start, end - 1L, array);
        long result2 = 0L;
        int n = CommonTypesKt.toIntNoNegative(end - start);
        for (int i = 0; i < n; ++i) {
            if (!this.numberSetFilter.match(array[i])) continue;
            result2 |= 1L << i;
        }
        return result2;
    }

    public final long getCount() {
        return CommonTypesKt.bitCountToLongCount(this.dataList.getCount());
    }

    public final long getBitCount() {
        return this.dataList.getCount();
    }

    public final long getBitRemCount() {
        return this.dataList.getCount() & 0x3FL;
    }

    @Override
    public void close() {
        block0: {
            IImmutableListInt iImmutableListInt = this.dataList;
            Closeable closeable = iImmutableListInt instanceof Closeable ? (Closeable)((Object)iImmutableListInt) : null;
            if (closeable == null) break block0;
            closeable.close();
        }
    }
}

