/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.common;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.DefaultThreadPoolExecutor;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.computingEngine.thread.DefaultThreadFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0014\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/common/DefaultThreadPoolExecutor;", "Ljava/io/Closeable;", "prefixThreadName", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_myCancellable", "Lkd/bos/olapServer2/common/ICancellable;", "jobs", "", "Ljava/util/concurrent/Future;", "", "mainOlapContext", "Lkd/bos/olapServer2/common/OlapContext;", "threadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "close", "createThreadPoolExecutor", "submit", "action", "Lkotlin/Function0;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDefaultThreadPoolExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultThreadPoolExecutor.kt\nkd/bos/olapServer2/common/DefaultThreadPoolExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n*S KotlinDebug\n*F\n+ 1 DefaultThreadPoolExecutor.kt\nkd/bos/olapServer2/common/DefaultThreadPoolExecutor\n*L\n70#1:76,2\n*E\n"})
public final class DefaultThreadPoolExecutor
implements Closeable {
    @NotNull
    private final List<Future<Unit>> jobs;
    @NotNull
    private final ThreadPoolExecutor threadPool;
    @Nullable
    private ICancellable _myCancellable;
    @Nullable
    private final OlapContext mainOlapContext;

    public DefaultThreadPoolExecutor(@NotNull String prefixThreadName) {
        ICancellable iCancellable;
        Intrinsics.checkNotNullParameter((Object)prefixThreadName, (String)"prefixThreadName");
        this.jobs = new ArrayList();
        this.threadPool = this.createThreadPoolExecutor(prefixThreadName);
        ICancellable ct = OlapContext.Companion.tryGetContext(ICancellable.class);
        if (ct == null) {
            ct = CancellableToken.INSTANCE.createCancellable();
            OlapContext.Companion.push(ct);
            iCancellable = ct;
        } else {
            iCancellable = null;
        }
        this._myCancellable = iCancellable;
        this.mainOlapContext = OlapContext.Companion.getCurrentContext();
    }

    private final ThreadPoolExecutor createThreadPoolExecutor(String prefixThreadName) {
        int threadCount = CommonTypesKt.getAvailableProcessors() < 4 ? CommonTypesKt.getAvailableProcessors() : 4;
        return new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new DefaultThreadFactory(prefixThreadName + "Thread-", 0, 2, null));
    }

    public final void submit(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Future<Unit> future = this.threadPool.submit(() -> DefaultThreadPoolExecutor.submit$lambda$0(this, action));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.jobs.add(future);
    }

    @Override
    public void close() {
        ICancellable iCancellable = this._myCancellable;
        if (iCancellable != null) {
            ICancellable it = iCancellable;
            boolean bl = false;
            OlapContext.Companion.pop(it);
        }
        Iterable $this$forEach$iv = this.jobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
        this.threadPool.shutdown();
        this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        CancellableToken.INSTANCE.getContinueToken().canContinue();
    }

    private static final Unit submit$lambda$0(DefaultThreadPoolExecutor this$0, Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        OlapContext.Companion.newContext(this$0.mainOlapContext, (Function0)new Function0<Unit>((Function0<Unit>)$action){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
                super(0);
            }

            public final void invoke() {
                CancellableToken.INSTANCE.getContinueToken().canContinue();
                this.$action.invoke();
            }
        }, submit.1.2.INSTANCE);
        return Unit.INSTANCE;
    }
}

