/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.common;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer2.common.NotSupportedException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/common/ParallelTaskManager;", "Ljava/io/Closeable;", "tranId", "", "Lkd/bos/olapServer2/common/long;", "(J)V", "_tasks", "", "Lkotlin/Function0;", "", "close", "join", "putTask", "action", "Companion", "bos-olap-core2"})
public final class ParallelTaskManager
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long tranId;
    @NotNull
    private final List<Function0<Unit>> _tasks;
    @NotNull
    private static final ThreadLocal<ParallelTaskManager> threadCurrentManager = new ThreadLocal();
    @NotNull
    private static final AtomicLong lastTranId = new AtomicLong();
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    @NotNull
    private static final AtomicReference<List<Function0<Unit>>> tasksCache = new AtomicReference();

    public ParallelTaskManager(long tranId) {
        this.tranId = tranId;
        this._tasks = ParallelTaskManager.Companion.getTasks();
    }

    private final void putTask(Function0<Unit> action) {
        this._tasks.add(action);
    }

    @Override
    public void close() {
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join() {
        try {
            int n = 0;
            int n2 = this._tasks.size();
            Future[] futureArray = new Future[n2];
            while (n < n2) {
                int n3 = n++;
                futureArray[n3] = pool.submit(() -> ParallelTaskManager.join$lambda$0(this._tasks.get(n3)));
            }
            for (Future future : futureArray) {
                future.get(2592000L, TimeUnit.SECONDS);
            }
        }
        finally {
            ParallelTaskManager.Companion.releaseTasks(this._tasks);
            threadCurrentManager.set(null);
        }
    }

    private static final void join$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0002J$\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001c\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/common/ParallelTaskManager$Companion;", "", "()V", "lastTranId", "Ljava/util/concurrent/atomic/AtomicLong;", "pool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "tasksCache", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lkotlin/Function0;", "", "threadCurrentManager", "Ljava/lang/ThreadLocal;", "Lkd/bos/olapServer2/common/ParallelTaskManager;", "begin", "getTasks", "put", "", "Lkd/bos/olapServer2/common/long;", "currentTranId", "action", "releaseTasks", "tasks", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParallelTaskManager begin() {
            ParallelTaskManager current = (ParallelTaskManager)threadCurrentManager.get();
            if (current != null) {
                throw new NotSupportedException();
            }
            ParallelTaskManager newInstance = new ParallelTaskManager(lastTranId.incrementAndGet());
            threadCurrentManager.set(newInstance);
            return newInstance;
        }

        public final long put(long currentTranId, @NotNull Function0<Unit> action) {
            long l;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            ParallelTaskManager current = (ParallelTaskManager)threadCurrentManager.get();
            if (current == null) {
                action.invoke();
                l = 0L;
            } else {
                long tranId = current.tranId;
                if (currentTranId != tranId) {
                    current.putTask((Function0<Unit>)action);
                }
                l = tranId;
            }
            return l;
        }

        private final List<Function0<Unit>> getTasks() {
            List list2 = tasksCache.getAndSet(null);
            return list2 == null ? (List)new ArrayList() : list2;
        }

        private final void releaseTasks(List<Function0<Unit>> tasks) {
            tasks.clear();
            tasksCache.compareAndSet(null, tasks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

