/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.CachedByteBufferProvider;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.storages.tempStorages.TempCubeStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\b \u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000b\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\r\u0010\u001f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001eJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\tj\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/computingEngine/AbstractComputingWorkspace;", "TResource", "Ljava/io/Closeable;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "resourcePool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;)V", "_isClosed", "", "_resources", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "bufferProvider", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/CachedByteBufferProvider;", "getBufferProvider", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/CachedByteBufferProvider;", "isClosed", "Lkd/bos/olapServer2/common/bool;", "()Z", "resourceCount", "", "getResourceCount", "()I", "tempCubeStorage", "Lkd/bos/olapServer2/storages/tempStorages/TempCubeStorage;", "getTempCubeStorage", "()Lkd/bos/olapServer2/storages/tempStorages/TempCubeStorage;", "close", "", "createComputingResource", "()Ljava/io/Closeable;", "createThreadResource", "getLoadedResources", "", "bos-olap-core2"})
public abstract class AbstractComputingWorkspace<TResource extends Closeable>
implements Closeable {
    @NotNull
    private final CachedByteBufferProvider bufferProvider;
    @NotNull
    private final TempCubeStorage tempCubeStorage;
    @NotNull
    private final ConcurrentLinkedQueue<TResource> _resources;
    private boolean _isClosed;

    public AbstractComputingWorkspace(@NotNull Cube cube, @NotNull ByteBufferResourcePool resourcePool) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)resourcePool, (String)"resourcePool");
        this.bufferProvider = new CachedByteBufferProvider(resourcePool);
        this.tempCubeStorage = new TempCubeStorage(cube, this.bufferProvider);
        this._resources = new ConcurrentLinkedQueue();
    }

    @NotNull
    protected final CachedByteBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @NotNull
    public final TempCubeStorage getTempCubeStorage() {
        return this.tempCubeStorage;
    }

    @NotNull
    public final TResource createComputingResource() {
        TResource res = this.createThreadResource();
        this._resources.offer(res);
        return res;
    }

    @NotNull
    protected abstract TResource createThreadResource();

    @NotNull
    public final Iterator<TResource> getLoadedResources() {
        Iterator<TResource> iterator2 = this._resources.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    protected final int getResourceCount() {
        return this._resources.size();
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void close() {
        if (!this._isClosed) {
            for (Closeable elem : this._resources) {
                elem.close();
            }
            this.bufferProvider.close();
            this._isClosed = true;
        }
    }
}

