/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.computingEngine.ComputeMode;
import kd.bos.olapServer2.computingEngine.Factor;
import kd.bos.olapServer2.computingEngine.FactorCollection;
import kd.bos.olapServer2.computingEngine.IComputingScope;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.IFactorCollection;
import kd.bos.olapServer2.computingEngine.OverrideData;
import kd.bos.olapServer2.computingEngine.OverrideSingleData;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.AggOperators;
import kd.bos.olapServer2.dataSources.AggExpression;
import kd.bos.olapServer2.dataSources.AggPair;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.expressions.AggFactor;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0016H\u0002J&\u0010&\u001a\u0004\u0018\u00010!2\b\u0010'\u001a\u0004\u0018\u00010!2\b\u0010(\u001a\u0004\u0018\u00010!2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u000b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer2/computingEngine/AggComputingUnit;", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "dimensions", "Lkd/bos/olapServer2/metadata/DimensionCollection;", "expressItem", "Lkd/bos/olapServer2/dataSources/AggExpression;", "mainDim", "Lkd/bos/olapServer2/metadata/Dimension;", "computeMode", "Lkd/bos/olapServer2/computingEngine/ComputeMode;", "(Lkd/bos/olapServer2/metadata/DimensionCollection;Lkd/bos/olapServer2/dataSources/AggExpression;Lkd/bos/olapServer2/metadata/Dimension;Lkd/bos/olapServer2/computingEngine/ComputeMode;)V", "ComputeMode", "getComputeMode", "()Lkd/bos/olapServer2/computingEngine/ComputeMode;", "Target", "Lkd/bos/olapServer2/computingEngine/OverrideData;", "getTarget", "()Lkd/bos/olapServer2/computingEngine/OverrideData;", "_factorCol", "Lkd/bos/olapServer2/computingEngine/FactorCollection;", "_factors", "", "Lkd/bos/olapServer2/computingEngine/Factor;", "[Lkd/bos/olapServer2/computingEngine/Factor;", "factors", "Lkd/bos/olapServer2/computingEngine/IFactorCollection;", "getFactors", "()Lkd/bos/olapServer2/computingEngine/IFactorCollection;", "factorsMembers", "Lkd/bos/olapServer2/metadata/expressions/AggFactor;", "[Lkd/bos/olapServer2/metadata/expressions/AggFactor;", "target", "execute", "", "scope", "Lkd/bos/olapServer2/computingEngine/IComputingScope;", "getResultValue", "factor", "operate", "a", "b", "operator", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/AggOperators;", "toString", "", "bos-olap-core2"})
public final class AggComputingUnit
implements IComputingUnit {
    @NotNull
    private final AggExpression expressItem;
    @NotNull
    private final ComputeMode computeMode;
    @NotNull
    private final OverrideData target;
    @NotNull
    private final AggFactor[] factorsMembers;
    @NotNull
    private final Factor[] _factors;
    @NotNull
    private final FactorCollection _factorCol;

    public AggComputingUnit(@NotNull DimensionCollection dimensions2, @NotNull AggExpression expressItem, @NotNull Dimension mainDim, @NotNull ComputeMode computeMode) {
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)expressItem, (String)"expressItem");
        Intrinsics.checkNotNullParameter((Object)mainDim, (String)"mainDim");
        Intrinsics.checkNotNullParameter((Object)((Object)computeMode), (String)"computeMode");
        this.expressItem = expressItem;
        this.computeMode = computeMode;
        int dimPos = mainDim.getPosition();
        MemberCollection members2 = mainDim.getMembers();
        Member member = members2.get(this.expressItem.getExpressLeft());
        this.target = new OverrideSingleData(dimensions2, dimPos, member.getPosition());
        List<AggPair> r = this.expressItem.getExpressRight();
        if (!(!((Collection)r).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int n = 0;
        int n2 = r.size();
        AggFactor[] aggFactorArray = new AggFactor[n2];
        AggComputingUnit aggComputingUnit = this;
        while (n < n2) {
            int n3 = n++;
            aggFactorArray[n3] = AggFactor.Companion.createFrom(r.get(n3), members2);
        }
        aggComputingUnit.factorsMembers = aggFactorArray;
        FactorCollection fs = new FactorCollection();
        n2 = 0;
        int n4 = this.factorsMembers.length;
        Factor[] factorArray = new Factor[n4];
        aggComputingUnit = this;
        while (n2 < n4) {
            int n5 = n2++;
            OverrideSingleData data = new OverrideSingleData(dimensions2, mainDim.getPosition(), this.factorsMembers[n5].getFactor().getPosition());
            factorArray[n5] = fs.register(data);
        }
        aggComputingUnit._factors = factorArray;
        this._factorCol = fs;
    }

    @Override
    @NotNull
    public ComputeMode getComputeMode() {
        return this.computeMode;
    }

    @Override
    @NotNull
    public OverrideData getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public IFactorCollection getFactors() {
        return this._factorCol;
    }

    @Override
    @Nullable
    public Object execute(@NotNull IComputingScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (this._factors.length == 0) {
            return CommonTypesKt.getUndefined();
        }
        AggFactor first = this.factorsMembers[0];
        Object result2 = this.getResultValue(scope, this._factors[0]);
        result2 = first.getOperator() == AggOperators.SUBTRACT ? DragonEngine.Companion.negate(result2) : DragonEngine.Companion.plus(result2);
        int n = this.factorsMembers.length;
        for (int i = 1; i < n; ++i) {
            AggFactor member = this.factorsMembers[i];
            result2 = this.operate(result2, this.getResultValue(scope, this._factors[i]), member.getOperator());
        }
        return result2;
    }

    private final Object getResultValue(IComputingScope scope, Factor factor) {
        Object value2 = scope.getValue(factor);
        return value2 == CommonTypesKt.getUndefined() ? null : value2;
    }

    private final Object operate(Object a, Object b, AggOperators operator) {
        Object object2;
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: {
                object2 = DragonEngine.Companion.add(a, b);
                break;
            }
            case 2: {
                object2 = DragonEngine.Companion.sub(a, b);
                break;
            }
            case 3: {
                object2 = DragonEngine.Companion.mul(a, b);
                break;
            }
            case 4: {
                object2 = DragonEngine.Companion.div(a, b);
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getAggComputingUnitException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AggComputingUnitException_1>(...)");
                Object[] objectArray = new Object[]{operator};
                throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
            }
        }
        return object2;
    }

    @NotNull
    public String toString() {
        return this.expressItem.toString();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AggOperators.values().length];
            try {
                nArray[AggOperators.PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggOperators.SUBTRACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggOperators.MULTIPLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggOperators.DIVIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

