/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import kd.bos.olapServer2.collections.IImmutableBitSet;
import kd.bos.olapServer2.collections.ImmutableBitSet;
import kd.bos.olapServer2.collections.MutableBitSet;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.IAggShieldRuleMasker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00060\fj\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/AggShieldRuleMasker;", "", "dims", "Lkd/bos/olapServer2/metadata/DimensionCollection;", "ruleScanner", "", "(Lkd/bos/olapServer2/metadata/DimensionCollection;[I)V", "alwaysTrueResult", "Lkd/bos/olapServer2/collections/IImmutableBitSet;", "initCache", "Lkd/bos/olapServer2/collections/MutableBitSet;", "isRuleScannerEmpty", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "resultCache", "clone", "getAggMask", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "bos-olap-core2"})
public final class AggShieldRuleMasker {
    @NotNull
    private final DimensionCollection dims;
    @NotNull
    private final int[] ruleScanner;
    @NotNull
    private final MutableBitSet initCache;
    @NotNull
    private final MutableBitSet resultCache;
    @Nullable
    private final IImmutableBitSet alwaysTrueResult;

    public AggShieldRuleMasker(@NotNull DimensionCollection dims, @NotNull int[] ruleScanner) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)ruleScanner, (String)"ruleScanner");
        this.dims = dims;
        this.ruleScanner = ruleScanner;
        this.initCache = MutableBitSet.Companion.create(this.dims.getCount(), true);
        this.resultCache = MutableBitSet.Companion.create(this.dims.getCount(), true);
        this.alwaysTrueResult = this.ruleScanner.length == 0 ? ImmutableBitSet.Companion.createAlwaysTrue(this.dims.getCount()) : null;
    }

    public final boolean isRuleScannerEmpty() {
        return this.alwaysTrueResult != null;
    }

    @NotNull
    public final AggShieldRuleMasker clone() {
        return new AggShieldRuleMasker(this.dims, this.ruleScanner);
    }

    @NotNull
    public final IImmutableBitSet getAggMask(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        IImmutableBitSet alwaysTrue = this.alwaysTrueResult;
        if (alwaysTrue != null) {
            return alwaysTrue;
        }
        MutableBitSet result2 = this.resultCache;
        result2.copyFrom(this.initCache);
        for (int dimPosition : this.ruleScanner) {
            IAggShieldRuleMasker masker;
            int memberPosition;
            Dimension dimension = (Dimension)this.dims.get(dimPosition);
            if (!dimension.isDefinedAggShieldRule(memberPosition = key2.get(dimPosition)) || (masker = dimension.getMembers().get(memberPosition).getAggShieldRuleMasker()) == null) continue;
            result2.and(masker.getAggShieldRuleMask(key2));
        }
        return result2;
    }
}

