/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.computingEngine.AggComputingUnit;
import kd.bos.olapServer2.computingEngine.ComputingLevel;
import kd.bos.olapServer2.computingEngine.ComputingUnitValidator;
import kd.bos.olapServer2.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer2.computingEngine.ExpressionComputingUnit;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingTaskBuilder;
import kd.bos.olapServer2.dataSources.AggExpression;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.IExpressionItem;
import kd.bos.olapServer2.dataSources.LambdaExpression;
import kd.bos.olapServer2.dataSources.MultiDimensionAggExpression;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J,\u0010\u0018\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J,\u0010\u001a\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J&\u0010\u001c\u001a\u0012\u0012\b\u0012\u00060\u001ej\u0002`\u001f\u0012\u0004\u0012\u00020\u00130\u001d2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"H\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\"J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\"H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkd/bos/olapServer2/computingEngine/ComputingCommandInfoSplitter;", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "command", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "computingContext", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;Lkd/bos/olapServer2/transactions/WriteTransaction;Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;)V", "cmdFilter", "Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "computingUnitValidator", "Lkd/bos/olapServer2/computingEngine/ComputingUnitValidator;", "dealAggExpression", "", "stack", "Ljava/util/Stack;", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTaskBuilder;", "expression", "Lkd/bos/olapServer2/dataSources/AggExpression;", "builders", "", "dealLambdaExpression", "Lkd/bos/olapServer2/dataSources/LambdaExpression;", "dealMultiDimensionAggExpression", "Lkd/bos/olapServer2/dataSources/IExpressionItem;", "initStack", "Lkotlin/Pair;", "", "Lkd/bos/olapServer2/common/bool;", "newComputingTaskBuilder", "singleBuilder", "", "splitCommand", "splitCommandCore", "bos-olap-core2"})
public final class ComputingCommandInfoSplitter {
    @NotNull
    private final ComputingCommandInfo command;
    @Nullable
    private final WriteTransaction transaction;
    @NotNull
    private final ComputingContext computingContext;
    @NotNull
    private final DimensionFilterCollection cmdFilter;
    @NotNull
    private final ComputingUnitValidator computingUnitValidator;

    public ComputingCommandInfoSplitter(@NotNull Cube cube, @NotNull ComputingCommandInfo command, @Nullable WriteTransaction transaction, @NotNull ComputingContext computingContext) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)computingContext, (String)"computingContext");
        this.command = command;
        this.transaction = transaction;
        this.computingContext = computingContext;
        this.cmdFilter = DimensionFilterCollection.Companion.from(cube.getDimensions(), this.command.getFilter());
        this.computingUnitValidator = new ComputingUnitValidator(this.cmdFilter, true);
    }

    @NotNull
    public final List<ComputingTaskBuilder> splitCommand() {
        return this.command.getExpressionItems().isEmpty() ? CollectionsKt.emptyList() : (this.command.getExpressionItems().size() == 1 ? this.singleBuilder() : (this.command.isSerial() ? this.splitCommandCore() : this.singleBuilder()));
    }

    private final List<ComputingTaskBuilder> singleBuilder() {
        ComputingTaskBuilder builder = this.newComputingTaskBuilder();
        for (IExpressionItem expressionItem : this.command.getExpressionItems()) {
            if (expressionItem instanceof AggExpression) {
                builder.add((AggExpression)expressionItem);
                continue;
            }
            builder.getComputingLevel().addAnyUnit(builder.convert(expressionItem));
        }
        return CollectionsKt.listOf((Object)builder);
    }

    private final ComputingTaskBuilder newComputingTaskBuilder() {
        return new ComputingTaskBuilder(this.command, this.computingContext, this.transaction, new ComputingLevel(this.cmdFilter, this.command.getIncludeDynamicMemberWhenNullFilter(), this.computingContext.getLinkedCubes()));
    }

    private final List<ComputingTaskBuilder> splitCommandCore() {
        List builders = new ArrayList();
        Stack<ComputingTaskBuilder> stack = new Stack<ComputingTaskBuilder>();
        for (IExpressionItem expression : this.command.getExpressionItems()) {
            IExpressionItem iExpressionItem = expression;
            if (iExpressionItem instanceof MultiDimensionAggExpression) {
                this.dealMultiDimensionAggExpression(stack, expression, builders);
                continue;
            }
            if (iExpressionItem instanceof AggExpression) {
                this.dealAggExpression(stack, (AggExpression)expression, builders);
                continue;
            }
            if (iExpressionItem instanceof LambdaExpression) {
                this.dealLambdaExpression(stack, (LambdaExpression)expression, builders);
                continue;
            }
            throw new NotSupportedException("not supported unitType");
        }
        if (!((Collection)stack).isEmpty()) {
            Object e = stack.pop();
            Intrinsics.checkNotNullExpressionValue(e, (String)"pop(...)");
            builders.add(e);
        }
        this.computingUnitValidator.clear();
        return builders;
    }

    private final void dealLambdaExpression(Stack<ComputingTaskBuilder> stack, LambdaExpression expression, List<ComputingTaskBuilder> builders) {
        Pair<Boolean, ComputingTaskBuilder> pair = this.initStack(stack);
        boolean notData = (Boolean)pair.component1();
        ComputingTaskBuilder currentBuilder = (ComputingTaskBuilder)pair.component2();
        Object unit = currentBuilder.convert(expression);
        if (!(unit instanceof ExpressionComputingUnit)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.computingUnitValidator.check((IComputingUnit)unit) || notData) {
            currentBuilder.getComputingLevel().add((IComputingUnit)unit);
        } else {
            ComputingTaskBuilder computingTaskBuilder = stack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)computingTaskBuilder, (String)"pop(...)");
            builders.add(computingTaskBuilder);
            this.computingUnitValidator.clear();
            this.dealLambdaExpression(stack, expression, builders);
        }
    }

    private final Pair<Boolean, ComputingTaskBuilder> initStack(Stack<ComputingTaskBuilder> stack) {
        ComputingTaskBuilder computingTaskBuilder;
        boolean notData = false;
        if (!((Collection)stack).isEmpty()) {
            computingTaskBuilder = stack.peek();
        } else {
            notData = true;
            computingTaskBuilder = stack.push(this.newComputingTaskBuilder());
        }
        ComputingTaskBuilder currentBuilder = computingTaskBuilder;
        return new Pair((Object)notData, (Object)currentBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private final void dealMultiDimensionAggExpression(Stack<ComputingTaskBuilder> stack, IExpressionItem expression, List<ComputingTaskBuilder> builders) {
        void $this$dealMultiDimensionAggExpression_u24lambda_u240;
        ComputingTaskBuilder computingTaskBuilder;
        if (!((Collection)stack).isEmpty()) {
            ComputingTaskBuilder computingTaskBuilder2 = stack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)computingTaskBuilder2, (String)"pop(...)");
            builders.add(computingTaskBuilder2);
        }
        ComputingTaskBuilder computingTaskBuilder3 = computingTaskBuilder = this.newComputingTaskBuilder();
        List<ComputingTaskBuilder> list2 = builders;
        boolean bl = false;
        $this$dealMultiDimensionAggExpression_u24lambda_u240.getComputingLevel().addAnyUnit($this$dealMultiDimensionAggExpression_u24lambda_u240.convert(expression));
        list2.add(computingTaskBuilder);
        this.computingUnitValidator.clear();
    }

    private final void dealAggExpression(Stack<ComputingTaskBuilder> stack, AggExpression expression, List<ComputingTaskBuilder> builders) {
        Pair<Boolean, ComputingTaskBuilder> pair = this.initStack(stack);
        boolean notData = (Boolean)pair.component1();
        ComputingTaskBuilder currentBuilder = (ComputingTaskBuilder)pair.component2();
        Object unit = currentBuilder.convert(expression);
        if (!(unit instanceof AggComputingUnit)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.computingUnitValidator.check((IComputingUnit)unit) || notData) {
            currentBuilder.add(expression);
        } else {
            ComputingTaskBuilder computingTaskBuilder = stack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)computingTaskBuilder, (String)"pop(...)");
            builders.add(computingTaskBuilder);
            this.computingUnitValidator.clear();
            this.dealAggExpression(stack, expression, builders);
        }
    }
}

