/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.computingEngine.ComputeMode;
import kd.bos.olapServer2.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.OverrideData;
import kd.bos.olapServer2.computingEngine.UnitDependencyMapperContainer;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.Axis;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.ILinkedCubeWorkspaceCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.expressions.AggFactor;
import kd.bos.olapServer2.metadata.expressions.ExpressionUnit;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\b\u0002\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0001J\u000e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020+J\b\u00101\u001a\u00020+H\u0002J\u0006\u00102\u001a\u000203J\u001c\u00104\u001a\u00060\fj\u0002`\r2\u0006\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0002J\u0015\u00107\u001a\u00020)2\n\u00108\u001a\u00060\u0010j\u0002` H\u0086\u0002J\f\u00109\u001a\b\u0012\u0004\u0012\u00020)0\u0014R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0015\u0010\u000b\u001a\u00060\fj\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u001f\u001a\u00060\u0010j\u0002` 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0015\u0010\"\u001a\u00060\fj\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u00188F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkd/bos/olapServer2/computingEngine/ComputingLevel;", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "cmd", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "linkedCubes", "Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;)V", "filter", "Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "includeDynamicMemberWhenNullFilter", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;ZLkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;)V", "Count", "", "getCount", "()I", "_dependencies", "", "_multiAggUnits", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "dependencies", "", "getDependencies", "()Ljava/util/List;", "getFilter", "()Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "getIncludeDynamicMemberWhenNullFilter", "()Z", "levelNumber", "Lkd/bos/olapServer2/common/int;", "getLevelNumber", "levelNumberIsZero", "getLevelNumberIsZero", "getLinkedCubes", "()Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;", "multiAggUnits", "getMultiAggUnits", "units", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "add", "", "unit", "addAnyUnit", "addDependency", "level", "check", "checkMultiDimensionAgg", "createDependencyMapperContainer", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer;", "find", "target", "source", "get", "index", "getAllUnit", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nComputingLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputingLevel.kt\nkd/bos/olapServer2/computingEngine/ComputingLevel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1#2:254\n1855#3,2:255\n1855#3,2:257\n*S KotlinDebug\n*F\n+ 1 ComputingLevel.kt\nkd/bos/olapServer2/computingEngine/ComputingLevel\n*L\n146#1:255,2\n230#1:257,2\n*E\n"})
public final class ComputingLevel {
    @NotNull
    private final DimensionFilterCollection filter;
    private final boolean includeDynamicMemberWhenNullFilter;
    @NotNull
    private final ILinkedCubeWorkspaceCollection linkedCubes;
    @Nullable
    private List<ComputingLevel> _dependencies;
    @NotNull
    private final List<IComputingUnit> units;
    @NotNull
    private final List<MultiDimensionAggComputingUnit> _multiAggUnits;

    public ComputingLevel(@NotNull DimensionFilterCollection filter2, boolean includeDynamicMemberWhenNullFilter, @NotNull ILinkedCubeWorkspaceCollection linkedCubes) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)linkedCubes, (String)"linkedCubes");
        this.filter = filter2;
        this.includeDynamicMemberWhenNullFilter = includeDynamicMemberWhenNullFilter;
        this.linkedCubes = linkedCubes;
        this.units = new ArrayList();
        this._multiAggUnits = new ArrayList();
    }

    public /* synthetic */ ComputingLevel(DimensionFilterCollection dimensionFilterCollection, boolean bl, ILinkedCubeWorkspaceCollection iLinkedCubeWorkspaceCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dimensionFilterCollection = new DimensionFilterCollection();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            iLinkedCubeWorkspaceCollection = ILinkedCubeWorkspaceCollection.EmptyLinkedCubeWorkspaceCollection.INSTANCE;
        }
        this(dimensionFilterCollection, bl, iLinkedCubeWorkspaceCollection);
    }

    @NotNull
    public final DimensionFilterCollection getFilter() {
        return this.filter;
    }

    public final boolean getIncludeDynamicMemberWhenNullFilter() {
        return this.includeDynamicMemberWhenNullFilter;
    }

    @NotNull
    public final ILinkedCubeWorkspaceCollection getLinkedCubes() {
        return this.linkedCubes;
    }

    public ComputingLevel(@NotNull Cube cube, @NotNull ComputingCommandInfo cmd, @NotNull ILinkedCubeWorkspaceCollection linkedCubes) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)linkedCubes, (String)"linkedCubes");
        this(DimensionFilterCollection.Companion.from(cube.getDimensions(), cmd.getFilter()), cmd.getIncludeDynamicMemberWhenNullFilter(), linkedCubes);
    }

    @NotNull
    public final List<ComputingLevel> getDependencies() {
        List list2 = this._dependencies;
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    public final void addDependency(@NotNull ComputingLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.find(this, level)) {
            throw new RuntimeException("todo \u5faa\u73af\u7684\u4f9d\u8d56");
        }
        List list2 = this._dependencies;
        if (list2 == null) {
            List list3;
            List it = list3 = (List)new ArrayList();
            boolean bl = false;
            this._dependencies = it;
            list2 = list3;
        }
        List dependencies = list2;
        dependencies.add((ComputingLevel)level);
    }

    private final boolean find(ComputingLevel target, ComputingLevel source2) {
        if (target == source2) {
            return true;
        }
        List<ComputingLevel> dependencies = source2._dependencies;
        if (dependencies != null) {
            for (ComputingLevel item : dependencies) {
                if (!this.find(target, item)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean getLevelNumberIsZero() {
        List<ComputingLevel> dependencies = this._dependencies;
        return dependencies == null || dependencies.size() == 0;
    }

    public final int getLevelNumber() {
        List<ComputingLevel> dependencies = this._dependencies;
        if (dependencies == null || dependencies.size() == 0) {
            return 0;
        }
        int max = 0;
        for (ComputingLevel item : dependencies) {
            int itemLevelNumer = item.getLevelNumber();
            if (itemLevelNumer <= max) continue;
            max = itemLevelNumer;
        }
        return max + 1;
    }

    @NotNull
    public final List<MultiDimensionAggComputingUnit> getMultiAggUnits() {
        return this._multiAggUnits;
    }

    public final void add(@NotNull MultiDimensionAggComputingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this._multiAggUnits.add(unit);
    }

    public final void addAnyUnit(@NotNull Object unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Object object2 = unit;
        if (object2 instanceof MultiDimensionAggComputingUnit) {
            if (!((Collection)((MultiDimensionAggComputingUnit)unit).getAxes()).isEmpty()) {
                this.add((MultiDimensionAggComputingUnit)unit);
            }
        } else if (object2 instanceof IComputingUnit) {
            this.add((IComputingUnit)unit);
        } else {
            throw new NotSupportedException("not supported unitType");
        }
    }

    public final int getCount() {
        return this.units.size();
    }

    @NotNull
    public final IComputingUnit get(int index2) {
        return this.units.get(index2);
    }

    public final void add(@NotNull IComputingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.units.add(unit);
    }

    @NotNull
    public final UnitDependencyMapperContainer createDependencyMapperContainer() {
        UnitDependencyMapperContainer dependencies = new UnitDependencyMapperContainer(this.filter, this.linkedCubes);
        Iterable $this$forEach$iv = this.units;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IComputingUnit it = (IComputingUnit)element$iv;
            boolean bl = false;
            if (it.getComputeMode() == ComputeMode.FullNull) continue;
            dependencies.mapping(it);
        }
        return dependencies;
    }

    public final void check() {
        HashSet<OverrideData> targetMembers = new HashSet<OverrideData>();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            IComputingUnit unit = this.get(i);
            if (targetMembers.contains(unit.getTarget())) {
                String string2 = Res.INSTANCE.getComputingLevelException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingLevelException_1>(...)");
                Object[] objectArray = new Object[]{unit};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            targetMembers.add(unit.getTarget());
        }
        this.checkMultiDimensionAgg();
    }

    private final void checkMultiDimensionAgg() {
        if (!((Collection)this._multiAggUnits).isEmpty()) {
            Object[] bits;
            int dimPos;
            Set[] targetMembers = null;
            targetMembers = new Set[]{};
            for (MultiDimensionAggComputingUnit multiAggUnit : this._multiAggUnits) {
                for (Axis axis : multiAggUnit.getAxes()) {
                    Object[] it;
                    Object[] objectArray;
                    dimPos = axis.getDimension().getPosition();
                    if (dimPos >= targetMembers.length) {
                        Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(targetMembers, dimPos + 1), (String)"copyOf(this, newSize)");
                    }
                    if ((objectArray = targetMembers[dimPos]) == null) {
                        Object[] objectArray2;
                        it = objectArray2 = new DimensionFilter(axis.getDimension()).getMembers();
                        boolean bl = false;
                        targetMembers[dimPos] = it;
                        objectArray = objectArray2;
                    }
                    bits = objectArray;
                    for (ExpressionUnit unit : axis.getUnits()) {
                        if (bits.contains(unit.getTarget())) {
                            String string2 = Res.INSTANCE.getComputingLevelException_2();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingLevelException_2>(...)");
                            it = new Object[]{unit.getTarget().getName()};
                            throw Res.INSTANCE.getNotSupportedException(string2, it);
                        }
                        bits.add((Member)unit.getTarget());
                    }
                }
            }
            for (MultiDimensionAggComputingUnit multiAggUnit : this._multiAggUnits) {
                for (Axis axis : multiAggUnit.getAxes()) {
                    dimPos = axis.getDimension().getPosition();
                    if (dimPos >= targetMembers.length || (bits = targetMembers[dimPos]) == null) continue;
                    for (ExpressionUnit unit : axis.getUnits()) {
                        Iterable $this$forEach$iv = unit.getFactors();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            AggFactor factor = (AggFactor)element$iv;
                            boolean bl = false;
                            if (!bits.contains(factor.getFactor())) continue;
                            String string3 = Res.INSTANCE.getComputingLevelException_3();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ComputingLevelException_3>(...)");
                            Object[] objectArray = new Object[]{axis.getDimension().getName(), factor.getFactor().getName()};
                            throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
                        }
                    }
                    for (Member member : axis.getFixedMembers()) {
                        if (!bits.contains(member)) continue;
                        String string4 = Res.INSTANCE.getComputingLevelException_4();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ComputingLevelException_4>(...)");
                        Object[] objectArray = new Object[]{axis.getDimension().getName(), member.getName()};
                        throw Res.INSTANCE.getNotSupportedException(string4, objectArray);
                    }
                }
            }
        }
    }

    @NotNull
    public final List<IComputingUnit> getAllUnit() {
        return this.units;
    }

    public ComputingLevel() {
        this(null, false, null, 7, null);
    }
}

