/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.olapServer2.collections.IIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0007&'()*+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0000J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J,\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u001a0\u00192\n\u0010\u001b\u001a\u00060\u0014j\u0002`\u001aJH\u0010\u001c\u001a\u00020\u00002\n\u0010\u001d\u001a\u00060\u0014j\u0002`\u001a2\n\u0010\u001e\u001a\u00060\u0014j\u0002`\u001a2\n\u0010\u001f\u001a\u00060\u0014j\u0002`\u001a2\u001c\u0010 \u001a\u0018\u0012\b\u0012\u00060\u0014j\u0002`\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0!J\u001e\u0010#\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder;", "", "resultArray", "", "([I)V", "_stepItems", "", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "[Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "getResultArray", "()[I", "sequenceCount", "Ljava/math/BigInteger;", "getSequenceCount", "()Ljava/math/BigInteger;", "build", "Lkd/bos/olapServer2/collections/IIterator;", "reverse", "setArrayValue", "index", "", "values", "setFixedValue", "value", "setIteratorValue", "", "Lkd/bos/olapServer2/common/int;", "valuesSize", "setMapValue", "fromIndex", "targetIndex", "mapCount", "mapFunc", "Lkotlin/Function2;", "", "setRangeValue", "start", "end", "ArrayStep", "BackwardRangeStep", "ForwardRangeStep", "IntArraySequence", "IteratorStep", "MapStep", "MemberStep", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nIntArraySequenceBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntArraySequenceBuilder.kt\nkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,341:1\n37#2,2:342\n13309#3,2:344\n*S KotlinDebug\n*F\n+ 1 IntArraySequenceBuilder.kt\nkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder\n*L\n77#1:342,2\n86#1:344,2\n*E\n"})
public final class IntArraySequenceBuilder {
    @NotNull
    private final int[] resultArray;
    @NotNull
    private final MemberStep[] _stepItems;

    public IntArraySequenceBuilder(@NotNull int[] resultArray) {
        Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
        this.resultArray = resultArray;
        this._stepItems = new MemberStep[this.resultArray.length];
    }

    @NotNull
    public final int[] getResultArray() {
        return this.resultArray;
    }

    @NotNull
    public final IntArraySequenceBuilder setFixedValue(int index2, int value2) {
        this._stepItems[index2] = null;
        this.resultArray[index2] = value2;
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setRangeValue(int index2, int start, int end) {
        if (end == start) {
            this.setFixedValue(index2, start);
        } else {
            this._stepItems[index2] = start > end ? new BackwardRangeStep(this.resultArray, index2, start, end) : new ForwardRangeStep(this.resultArray, index2, start, end);
        }
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setArrayValue(int index2, @NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.length == 1) {
            this.setFixedValue(index2, values[0]);
        } else {
            if (!(!(values.length == 0))) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            this._stepItems[index2] = new ArrayStep(this.resultArray, index2, values);
        }
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setMapValue(int fromIndex, int targetIndex, int mapCount, @NotNull Function2<? super Integer, ? super int[], Unit> mapFunc) {
        Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
        this._stepItems[fromIndex] = new MapStep(this.resultArray, this._stepItems[fromIndex], fromIndex, targetIndex, mapCount, mapFunc);
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder setIteratorValue(int index2, @NotNull Iterable<Integer> values, int valuesSize) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this._stepItems[index2] = new IteratorStep(this.resultArray, index2, values, valuesSize);
        return this;
    }

    @NotNull
    public final IntArraySequenceBuilder reverse() {
        ArraysKt.reverse((Object[])this._stepItems);
        return this;
    }

    @NotNull
    public final IIterator build() {
        if (!(!(this.resultArray.length == 0))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])this._stepItems);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MemberStep[] stepItems = thisCollection$iv.toArray(new MemberStep[0]);
        return new IntArraySequence(stepItems);
    }

    @NotNull
    public final BigInteger getSequenceCount() {
        BigInteger sum = null;
        sum = BigInteger.ONE;
        MemberStep[] $this$forEach$iv = this._stepItems;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            MemberStep element$iv;
            MemberStep it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (it == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)sum, (String)"element");
            Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(it.getCapacity()), (String)"valueOf(this.toLong())");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.multiply(bigInteger), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = sum;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"element");
        return bigInteger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\u0005j\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$ArrayStep;", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "values", "([II[I)V", "_currentIndex", "calcEnd", "capacity", "Lkd/bos/olapServer2/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core2"})
    private static final class ArrayStep
    extends MemberStep {
        @NotNull
        private final int[] values;
        private int _currentIndex;
        private final int calcEnd;

        public ArrayStep(@NotNull int[] resultArray, int resultIndex, @NotNull int[] values) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            super(resultArray, resultIndex);
            this.values = values;
            if (this.values.length == 0) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.values[0]);
            this.calcEnd = this.values.length - 1;
        }

        @Override
        public int getCapacity() {
            return this.values.length;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentIndex >= this.calcEnd) {
                this._currentIndex = 0;
                this.setResult(this.values[0]);
                bl = true;
            } else {
                ++this._currentIndex;
                this.setResult(this.values[this._currentIndex]);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$BackwardRangeStep;", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "start", "end", "([IIII)V", "_currentValue", "calcEnd", "capacity", "Lkd/bos/olapServer2/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core2"})
    private static final class BackwardRangeStep
    extends MemberStep {
        private final int start;
        private final int end;
        private int _currentValue;
        private final int calcEnd;

        public BackwardRangeStep(@NotNull int[] resultArray, int resultIndex, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            super(resultArray, resultIndex);
            this.start = start;
            this.end = end;
            if (this.start < this.end) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.start);
            this._currentValue = this.start;
            this.calcEnd = this.end >= 0 ? this.end - 1 : this.end + 1;
        }

        @Override
        public int getCapacity() {
            return this.start - this.end + 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentValue < this.calcEnd) {
                this._currentValue = this.start;
                this.setResult(this._currentValue);
                bl = true;
            } else {
                this._currentValue += -1;
                this.setResult(this._currentValue);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$ForwardRangeStep;", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "start", "end", "([IIII)V", "_currentValue", "calcEnd", "capacity", "Lkd/bos/olapServer2/common/int;", "getCapacity", "()I", "next", "", "bos-olap-core2"})
    private static final class ForwardRangeStep
    extends MemberStep {
        private final int start;
        private final int end;
        private int _currentValue;
        private final int calcEnd;

        public ForwardRangeStep(@NotNull int[] resultArray, int resultIndex, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            super(resultArray, resultIndex);
            this.start = start;
            this.end = end;
            if (this.start > this.end) {
                throw new IllegalArgumentException();
            }
            this.setResult(this.start);
            this._currentValue = this.start;
            this.calcEnd = this.end >= 0 ? this.end - 1 : this.end + 1;
        }

        @Override
        public int getCapacity() {
            return this.end - this.start + 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentValue > this.calcEnd) {
                this._currentValue = this.start;
                this.setResult(this.start);
                bl = true;
            } else {
                ++this._currentValue;
                this.setResult(this._currentValue);
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$IntArraySequence;", "Lkd/bos/olapServer2/collections/IIterator;", "stepItems", "", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "([Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;)V", "_states", "", "rangeSize", "[Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "next", "", "bos-olap-core2"})
    private static final class IntArraySequence
    implements IIterator {
        @NotNull
        private final MemberStep[] stepItems;
        private int _states;
        private final int rangeSize;

        public IntArraySequence(@NotNull MemberStep[] stepItems) {
            Intrinsics.checkNotNullParameter((Object)stepItems, (String)"stepItems");
            this.stepItems = stepItems;
            this.rangeSize = this.stepItems.length - 1;
        }

        @Override
        public boolean next() {
            boolean bl;
            switch (this._states) {
                case 0: {
                    this._states = this.rangeSize < 0 ? -1 : 1;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!this.stepItems[this.rangeSize].next()) {
                        return true;
                    }
                    for (int stepIndex = this.rangeSize - 1; -1 < stepIndex; --stepIndex) {
                        if (this.stepItems[stepIndex].next()) continue;
                        return true;
                    }
                    this._states = -1;
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\b0\u0007\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u0005j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$IteratorStep;", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "resultIndex", "", "values", "", "Lkd/bos/olapServer2/common/int;", "valuesSize", "([IILjava/lang/Iterable;I)V", "_currentItr", "Lkotlin/collections/IntIterator;", "capacity", "getCapacity", "()I", "next", "", "resetItr", "bos-olap-core2"})
    private static final class IteratorStep
    extends MemberStep {
        @NotNull
        private final Iterable<Integer> values;
        private final int valuesSize;
        @NotNull
        private IntIterator _currentItr;

        public IteratorStep(@NotNull int[] resultArray, int resultIndex, @NotNull Iterable<Integer> values, int valuesSize) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            super(resultArray, resultIndex);
            this.values = values;
            this.valuesSize = valuesSize;
            this._currentItr = this.resetItr();
        }

        @Override
        public int getCapacity() {
            return this.valuesSize;
        }

        private final IntIterator resetItr() {
            Iterator<Integer> itr = this.values.iterator();
            if (!(itr instanceof IntIterator) || !itr.hasNext()) {
                throw new IllegalArgumentException();
            }
            this._currentItr = (IntIterator)itr;
            this.setResult(((IntIterator)itr).nextInt());
            return (IntIterator)itr;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentItr.hasNext()) {
                this.setResult(this._currentItr.nextInt());
                bl = false;
            } else {
                this.resetItr();
                bl = true;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\t\u001a\u00060\u0006j\u0002`\u0007\u0012\u001c\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MapStep;", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "resultArray", "", "_sourceStepItem", "fromIndex", "", "Lkd/bos/olapServer2/common/int;", "targetIndex", "mapCount", "mapFunc", "Lkotlin/Function2;", "", "([ILkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;IIILkotlin/jvm/functions/Function2;)V", "_currentMapIndex", "capacity", "getCapacity", "()I", "mapEnd", "values", "next", "", "bos-olap-core2"})
    private static final class MapStep
    extends MemberStep {
        @NotNull
        private final int[] resultArray;
        @Nullable
        private final MemberStep _sourceStepItem;
        private final int fromIndex;
        private final int mapCount;
        @NotNull
        private final Function2<Integer, int[], Unit> mapFunc;
        @NotNull
        private final int[] values;
        private int _currentMapIndex;
        private final int mapEnd;

        public MapStep(@NotNull int[] resultArray, @Nullable MemberStep _sourceStepItem, int fromIndex, int targetIndex, int mapCount, @NotNull Function2<? super Integer, ? super int[], Unit> mapFunc) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
            super(resultArray, targetIndex);
            this.resultArray = resultArray;
            this._sourceStepItem = _sourceStepItem;
            this.fromIndex = fromIndex;
            this.mapCount = mapCount;
            this.mapFunc = mapFunc;
            this.values = new int[this.mapCount];
            this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
            this.setResult(this.values[0]);
            this.mapEnd = this.mapCount - 1;
        }

        @Override
        public int getCapacity() {
            MemberStep sourceStepItem = this._sourceStepItem;
            return sourceStepItem == null ? this.mapCount : sourceStepItem.getCapacity() * this.mapCount;
        }

        @Override
        public boolean next() {
            boolean bl;
            if (this._currentMapIndex < this.mapEnd) {
                ++this._currentMapIndex;
                this.setResult(this.values[this._currentMapIndex]);
                bl = false;
            } else {
                MemberStep memberStep = this._sourceStepItem;
                boolean bl2 = memberStep != null ? !memberStep.next() : false;
                if (bl2) {
                    this._currentMapIndex = 0;
                    this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
                    this.setResult(this.values[0]);
                    bl = false;
                } else {
                    this._currentMapIndex = 0;
                    this.mapFunc.invoke((Object)this.resultArray[this.fromIndex], (Object)this.values);
                    this.setResult(this.values[0]);
                    bl = true;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0004R\u0016\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder$MemberStep;", "", "resultArray", "", "resultIndex", "", "([II)V", "capacity", "Lkd/bos/olapServer2/common/int;", "getCapacity", "()I", "next", "", "setResult", "", "value", "bos-olap-core2"})
    private static abstract class MemberStep {
        @NotNull
        private final int[] resultArray;
        private final int resultIndex;

        public MemberStep(@NotNull int[] resultArray, int resultIndex) {
            Intrinsics.checkNotNullParameter((Object)resultArray, (String)"resultArray");
            this.resultArray = resultArray;
            this.resultIndex = resultIndex;
        }

        protected final void setResult(int value2) {
            this.resultArray[this.resultIndex] = value2;
        }

        public abstract int getCapacity();

        public abstract boolean next();
    }
}

