/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.collections.ILongConverter;
import kd.bos.olapServer2.collections.objectModel.KeyedCollection;
import kd.bos.olapServer2.common.DefaultEqualityComparer;
import kd.bos.olapServer2.common.IEqualityComparer;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.OverrideData;
import kd.bos.olapServer2.computingEngine.TargetKeyEqualityComparer;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.Axis;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.ZipIntArraySerializerBuilder;
import kd.bos.olapServer2.dataEntities.ZipIntSerializer;
import kd.bos.olapServer2.memoryMappedFiles.LongConverter;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.expressions.ExpressionUnit;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.selects.Query;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0011\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\u0002\u0010\u000eJ6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0015\u0010\u001b\u001a\u00020\u00072\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0017H\u0086\u0002J\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0&J\u0014\u0010'\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0&J\u0014\u0010*\u001a\u00020\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0&J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer;", "", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "(Lkd/bos/olapServer2/metadata/Cube;)V", "_items", "", "Lkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer$MemberRangePredictiveValue;", "[Lkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer$MemberRangePredictiveValue;", "createEqualityComparer", "Lkd/bos/olapServer2/common/IEqualityComparer;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "createSerializers", "Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "()[Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "fillChildrenFromFilter", "", "filter", "Lkd/bos/olapServer2/query/models/Filter;", "outputDimensions", "Lkd/bos/olapServer2/collections/objectModel/KeyedCollection;", "", "Lkd/bos/olapServer2/common/string;", "Lkd/bos/olapServer2/metadata/Dimension;", "mutableList", "", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "get", "index", "", "Lkd/bos/olapServer2/common/int;", "dimension", "scanAllDimension", "scanDistinctCount", "query", "Lkd/bos/olapServer2/selects/Query;", "scanFilters", "filters", "", "scanMultiAggUnits", "multiAggUnits", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "scanUnits", "units", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "tryCreateLongConverter", "Lkd/bos/olapServer2/collections/ILongConverter;", "", "MemberRangePredictiveValue", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMemberRangeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberRangeAnalyzer.kt\nkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,274:1\n1855#2,2:275\n1855#2,2:277\n1855#2,2:292\n13309#3,2:279\n11065#3:281\n11400#3,3:282\n13309#3,2:287\n13309#3,2:289\n13309#3:291\n13310#3:294\n37#4,2:285\n*S KotlinDebug\n*F\n+ 1 MemberRangeAnalyzer.kt\nkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer\n*L\n36#1:275,2\n50#1:277,2\n186#1:292,2\n64#1:279,2\n107#1:281\n107#1:282,3\n132#1:287,2\n160#1:289,2\n185#1:291\n185#1:294\n120#1:285,2\n*E\n"})
public final class MemberRangeAnalyzer {
    @NotNull
    private final Cube cube;
    @NotNull
    private final MemberRangePredictiveValue[] _items;

    public MemberRangeAnalyzer(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        this.cube = cube;
        int n = 0;
        int n2 = this.cube.getDimensions().getCount();
        MemberRangePredictiveValue[] memberRangePredictiveValueArray = new MemberRangePredictiveValue[n2];
        MemberRangeAnalyzer memberRangeAnalyzer = this;
        while (n < n2) {
            int n3 = n++;
            memberRangePredictiveValueArray[n3] = new MemberRangePredictiveValue((Dimension)this.cube.getDimensions().get(n3));
        }
        memberRangeAnalyzer._items = memberRangePredictiveValueArray;
    }

    public final void scanUnits(@NotNull Iterable<? extends IComputingUnit> units) {
        Intrinsics.checkNotNullParameter(units, (String)"units");
        DimensionCollection dims = this.cube.getDimensions();
        int dimSize = dims.getCount();
        Iterable<? extends IComputingUnit> $this$forEach$iv = units;
        boolean $i$f$forEach = false;
        Iterator<? extends IComputingUnit> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IComputingUnit element$iv;
            IComputingUnit unit = element$iv = iterator2.next();
            boolean bl = false;
            OverrideData target = unit.getTarget();
            for (int i = 0; i < dimSize; ++i) {
                int index2 = target.get(i);
                if (index2 < 0) continue;
                Member member = ((Dimension)dims.get(i)).getMembers().get(index2);
                this.get(i).scan(member);
            }
        }
    }

    public final void scanFilters(@NotNull Iterable<DimensionFilter> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Iterable<DimensionFilter> $this$forEach$iv = filters;
        boolean $i$f$forEach = false;
        Iterator<DimensionFilter> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            DimensionFilter element$iv;
            DimensionFilter filter2 = element$iv = iterator2.next();
            boolean bl = false;
            MemberRangePredictiveValue memberRangePredictiveValue = this.get(filter2.getDimension());
            memberRangePredictiveValue.scan(filter2);
        }
    }

    public final void scanDistinctCount(@NotNull Query query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Filter filter2 = query2.getFilter();
        List dimFilterList = new ArrayList();
        if (filter2 != null) {
            this.fillChildrenFromFilter(filter2, query2.getDimensions(), dimFilterList);
        }
        this.scanFilters(dimFilterList);
        MemberRangePredictiveValue[] $this$forEach$iv = this._items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MemberRangePredictiveValue element$iv;
            MemberRangePredictiveValue it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (query2.getDimensions().containsKey(it.getDimension().getName())) continue;
            it.setOnlyOne();
        }
    }

    private final void fillChildrenFromFilter(Filter filter2, KeyedCollection<String, Dimension> outputDimensions, List<DimensionFilter> mutableList) {
        if (filter2 instanceof DimensionFilter) {
            if (outputDimensions.containsKey(((DimensionFilter)filter2).getDimension().getName())) {
                mutableList.add((DimensionFilter)filter2);
            }
        } else if (filter2.getHasChildren()) {
            Iterable<Filter> children = filter2.getChildren();
            for (Filter child : children) {
                this.fillChildrenFromFilter(child, outputDimensions, mutableList);
            }
        }
    }

    public final void scanMultiAggUnits(@NotNull Iterable<MultiDimensionAggComputingUnit> multiAggUnits) {
        Intrinsics.checkNotNullParameter(multiAggUnits, (String)"multiAggUnits");
        for (MultiDimensionAggComputingUnit element : multiAggUnits) {
            List<Axis> axes = element.getAxes();
            for (Axis axis : axes) {
                this.get(axis.getDimension()).scan(axis);
            }
        }
    }

    @NotNull
    public final MemberRangePredictiveValue get(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this._items[dimension.getPosition()];
    }

    @NotNull
    public final MemberRangePredictiveValue get(int index2) {
        return this._items[index2];
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ILongConverter<int[]> tryCreateLongConverter() {
        void $this$mapTo$iv$iv;
        MemberRangePredictiveValue[] $this$map$iv = this._items;
        boolean $i$f$map = false;
        MemberRangePredictiveValue[] memberRangePredictiveValueArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            int[] nArray;
            int[] nArray2;
            void predictive;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (predictive.isAll()) {
                Dimension dim = predictive.getDimension();
                int[] nArray3 = new int[]{0, dim.isSupportSimpleMember() ? Integer.MAX_VALUE : dim.getMembers().getNextUnusedPosition() - 1};
                nArray2 = nArray3;
            } else if (predictive.isOnlyOne()) {
                nArray = new int[]{predictive.getMin()};
                nArray2 = nArray;
            } else {
                nArray = new int[]{predictive.getMin(), predictive.getMax()};
                nArray2 = nArray;
            }
            collection.add(nArray2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        int[][] nArray = (int[][])thisCollection$iv.toArray((T[])new int[0][]);
        LongConverter longConverter = new LongConverter(nArray);
        return longConverter.getMaxValue().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0 ? longConverter.createSimdVersion() : null;
    }

    @NotNull
    public final IEqualityComparer<IDimensionKeys> createEqualityComparer() {
        IEqualityComparer comparer;
        IEqualityComparer iEqualityComparer;
        int count = 0;
        List dimensionIndexes = new ArrayList();
        MemberRangePredictiveValue[] $this$forEach$iv = this._items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MemberRangePredictiveValue element$iv;
            MemberRangePredictiveValue predictive = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Dimension dim = predictive.getDimension();
            if (predictive.isOnlyOne()) continue;
            dimensionIndexes.add(dim.getPosition());
            ++count;
        }
        int n2 = count;
        if (n2 == 0) {
            ZipIntSerializer[] serializers = this.createSerializers();
            int[] nArray = new int[]{0};
            iEqualityComparer = new TargetKeyEqualityComparer(nArray, serializers);
        } else if (n2 == this._items.length) {
            iEqualityComparer = DefaultEqualityComparer.INSTANCE;
        } else {
            ZipIntSerializer[] serializers = this.createSerializers();
            iEqualityComparer = comparer = (IEqualityComparer)new TargetKeyEqualityComparer(CollectionsKt.toIntArray((Collection)dimensionIndexes), serializers);
        }
        if (comparer instanceof TargetKeyEqualityComparer) {
            ((TargetKeyEqualityComparer)comparer).setConverter(this.tryCreateLongConverter());
        }
        return comparer;
    }

    @NotNull
    public final ZipIntSerializer[] createSerializers() {
        ZipIntArraySerializerBuilder serBuilder = new ZipIntArraySerializerBuilder();
        MemberRangePredictiveValue[] $this$forEach$iv = this._items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MemberRangePredictiveValue element$iv;
            MemberRangePredictiveValue predictive = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Dimension dim = predictive.getDimension();
            MemberCollection members2 = dim.getMembers();
            if (predictive.isAll()) {
                serBuilder.add(dim);
                continue;
            }
            if (predictive.isOnlyOne()) {
                if (predictive.getMin() < 0) {
                    serBuilder.addFixedValue(0);
                    continue;
                }
                serBuilder.addFixedMember(members2.get(predictive.getMin()));
                continue;
            }
            serBuilder.add(predictive.getMax() + 1);
        }
        return serBuilder.build();
    }

    public final void scanAllDimension() {
        MemberRangePredictiveValue[] $this$forEach$iv = this._items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MemberRangePredictiveValue element$iv;
            MemberRangePredictiveValue item = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Iterable $this$forEach$iv2 = item.getDimension().getMembers();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Member it = (Member)element$iv2;
                boolean bl2 = false;
                item.scan(it);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0016J\u0015\u0010\u001e\u001a\u00020\u00162\n\u0010\u001f\u001a\u00060\u0006j\u0002`\u0010H\u0082\bJ\u0015\u0010 \u001a\u00020\u00162\n\u0010\u001f\u001a\u00060\u0006j\u0002`\u0010H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0015\u0010\u000f\u001a\u00060\u0006j\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0006j\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006!"}, d2={"Lkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer$MemberRangePredictiveValue;", "", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "(Lkd/bos/olapServer2/metadata/Dimension;)V", "_max", "", "_min", "getDimension", "()Lkd/bos/olapServer2/metadata/Dimension;", "isAll", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isOnlyOne", "max", "Lkd/bos/olapServer2/common/int;", "getMax", "()I", "min", "getMin", "scan", "", "axis", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/Axis;", "member", "Lkd/bos/olapServer2/metadata/Member;", "filter", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "setOnlyOne", "tryUpdateMax", "position", "tryUpdateMin", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nMemberRangeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberRangeAnalyzer.kt\nkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer$MemberRangePredictiveValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n269#1,4:275\n262#1,4:279\n269#1,4:285\n262#1,4:289\n269#1,4:293\n262#1,4:297\n1855#2,2:283\n*S KotlinDebug\n*F\n+ 1 MemberRangeAnalyzer.kt\nkd/bos/olapServer2/computingEngine/MemberRangeAnalyzer$MemberRangePredictiveValue\n*L\n219#1:275,4\n222#1:279,4\n246#1:285,4\n249#1:289,4\n256#1:293,4\n257#1:297,4\n242#1:283,2\n*E\n"})
    public static final class MemberRangePredictiveValue {
        @NotNull
        private final Dimension dimension;
        private int _max;
        private int _min;

        public MemberRangePredictiveValue(@NotNull Dimension dimension) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            this.dimension = dimension;
            this._max = Integer.MIN_VALUE;
            this._min = Integer.MAX_VALUE;
        }

        @NotNull
        public final Dimension getDimension() {
            return this.dimension;
        }

        public final int getMax() {
            return this._max;
        }

        public final int getMin() {
            return this._min;
        }

        public final boolean isOnlyOne() {
            return this._min == this._max;
        }

        public final boolean isAll() {
            return this._min == Integer.MAX_VALUE;
        }

        public final void setOnlyOne() {
            this._min = Integer.MIN_VALUE;
            this._max = Integer.MIN_VALUE;
        }

        public final void scan(@NotNull DimensionFilter filter2) {
            block4: {
                MemberRangePredictiveValue this_$iv;
                int position$iv;
                Member it;
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                if (!(filter2.getDimension() == this.dimension)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Member member = filter2.getFirst();
                if (member != null) {
                    it = member;
                    boolean bl = false;
                    MemberRangePredictiveValue memberRangePredictiveValue = this;
                    position$iv = it.getPosition();
                    boolean $i$f$tryUpdateMin = false;
                    if (this_$iv._min > position$iv) {
                        this_$iv._min = position$iv;
                    }
                }
                Member member2 = filter2.getLast();
                if (member2 == null) break block4;
                it = member2;
                boolean bl = false;
                this_$iv = this;
                position$iv = it.getPosition();
                boolean $i$f$tryUpdateMax = false;
                if (this_$iv._max < position$iv) {
                    this_$iv._max = position$iv;
                }
            }
        }

        public final void scan(@NotNull Axis axis) {
            block8: {
                MemberRangePredictiveValue this_$iv;
                int position$iv;
                Member it;
                Object aggUnit;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
                    if (!(axis.getDimension() == this.dimension)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    if (!axis.isSelectAllStoredMembers()) break block7;
                    if (this.dimension.isSupportSimpleMember()) {
                        this._min = 0;
                        this._max = 0x7FFFFFFE;
                    } else {
                        this._min = this.dimension.getMembers().getRealCount() == 0 ? Integer.MAX_VALUE : 0;
                        this._max = this.dimension.getMembers().getNextUnusedPosition() - 1;
                    }
                    break block8;
                }
                Iterable $this$forEach$iv = axis.getUnits();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    aggUnit = (ExpressionUnit)element$iv;
                    boolean bl = false;
                    this.scan(((ExpressionUnit)aggUnit).getTarget());
                }
                Member member = axis.getFirstFixedMember();
                if (member != null) {
                    it = member;
                    boolean bl = false;
                    aggUnit = this;
                    position$iv = it.getPosition();
                    boolean $i$f$tryUpdateMin = false;
                    if (this_$iv._min > position$iv) {
                        this_$iv._min = position$iv;
                    }
                }
                Member member2 = axis.getLastFixedMember();
                if (member2 == null) break block8;
                it = member2;
                boolean bl = false;
                this_$iv = this;
                position$iv = it.getPosition();
                boolean $i$f$tryUpdateMax = false;
                if (this_$iv._max < position$iv) {
                    this_$iv._max = position$iv;
                }
            }
        }

        public final void scan(@NotNull Member member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            int position = member.getPosition();
            MemberRangePredictiveValue this_$iv = this;
            boolean $i$f$tryUpdateMin = false;
            if (this_$iv._min > position) {
                this_$iv._min = position;
            }
            this_$iv = this;
            boolean $i$f$tryUpdateMax = false;
            if (this_$iv._max < position) {
                this_$iv._max = position;
            }
        }

        private final void tryUpdateMax(int position) {
            boolean $i$f$tryUpdateMax = false;
            if (this._max < position) {
                this._max = position;
            }
        }

        private final void tryUpdateMin(int position) {
            boolean $i$f$tryUpdateMin = false;
            if (this._min > position) {
                this._min = position;
            }
        }
    }
}

