/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.collections.IMutableSet;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00050\u0004\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0014\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0014\u0010\u0019\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000b\u001a4\u00120\u0012.\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u00070\fj\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u0007`\r0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/computingEngine/RoaringLongBitSet;", "Lkd/bos/olapServer2/collections/IMutableSet;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "dimensionInfo", "", "", "", "Lkd/bos/olapServer2/common/int;", "([Ljava/util/List;)V", "_carryArray", "", "_dimensionInfo", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "[Ljava/util/HashMap;", "roar", "Lorg/roaringbitmap/longlong/Roaring64NavigableMap;", "contains", "", "Lkd/bos/olapServer2/common/bool;", "key", "dimensionKeysToNumber", "", "Lkd/bos/olapServer2/common/long;", "dimensionKeys", "getOrPut", "bos-olap-core2"})
public final class RoaringLongBitSet
implements IMutableSet<IDimensionKeys> {
    @NotNull
    private final Roaring64NavigableMap roar;
    @NotNull
    private final HashMap<Integer, Integer>[] _dimensionInfo;
    @NotNull
    private final long[] _carryArray;

    public RoaringLongBitSet(@NotNull List<Integer>[] dimensionInfo) {
        Intrinsics.checkNotNullParameter(dimensionInfo, (String)"dimensionInfo");
        this.roar = new Roaring64NavigableMap();
        int n = 0;
        int n2 = dimensionInfo.length;
        HashMap[] hashMapArray = new HashMap[n2];
        RoaringLongBitSet roaringLongBitSet = this;
        while (n < n2) {
            int n3 = n++;
            hashMapArray[n3] = new HashMap();
        }
        roaringLongBitSet._dimensionInfo = hashMapArray;
        this._carryArray = new long[dimensionInfo.length];
        BigInteger count = BigInteger.ONE;
        int n4 = dimensionInfo.length;
        for (n2 = 0; n2 < n4; ++n2) {
            BigInteger bigInteger;
            int i = n2;
            List<Integer> dimension = dimensionInfo[n2];
            Object object2 = dimension.iterator();
            int n5 = 0;
            while (object2.hasNext()) {
                int j = n5++;
                int member = ((Number)object2.next()).intValue();
                Integer n6 = member;
                Integer n7 = j;
                ((Map)this._dimensionInfo[i]).put(n6, n7);
            }
            this._carryArray[i] = i == 0 ? 1L : (long)this._dimensionInfo[i - 1].size() * this._carryArray[i - 1];
            object2 = count;
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(this._dimensionInfo[i].size()), (String)"valueOf(this.toLong())");
            Intrinsics.checkNotNullExpressionValue((Object)((BigInteger)object2).multiply(bigInteger), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
        if (count.compareTo(bigInteger) > 0) {
            String string2 = Res.INSTANCE.getRoaringLongBitSetException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RoaringLongBitSetException_1>(...)");
            Object[] objectArray = new Object[]{count, Long.MAX_VALUE};
            throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
        }
    }

    private final long dimensionKeysToNumber(IDimensionKeys dimensionKeys) {
        if (!(dimensionKeys.getCount() == this._carryArray.length)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long result2 = 0L;
        int n = dimensionKeys.getCount();
        for (int i = 0; i < n; ++i) {
            result2 += ((Number)MapsKt.getValue((Map)this._dimensionInfo[i], (Object)dimensionKeys.get(i))).longValue() * this._carryArray[i];
        }
        return result2;
    }

    @Override
    public boolean getOrPut(@NotNull IDimensionKeys key2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        if (this.contains(key2)) {
            bl = true;
        } else {
            long[] lArray = new long[]{this.dimensionKeysToNumber(key2)};
            this.roar.add(lArray);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean contains(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.roar.contains(this.dimensionKeysToNumber(key2));
    }
}

