/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import kd.bos.olapServer2.collections.INumberSetFilter;
import kd.bos.olapServer2.collections.MutableBitSet;
import kd.bos.olapServer2.computingEngine.AlwaysFalseDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.AlwaysTrueDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.IDimensionKeysFilter;
import kd.bos.olapServer2.computingEngine.NotStoredFilter;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.IAggShieldRuleMasker;
import kd.bos.olapServer2.metadata.expressions.ExpressionUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0001J\u0014\u0010\u0013\u001a\u00060\u000fj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/computingEngine/StoredFilter;", "Lkd/bos/olapServer2/computingEngine/IDimensionKeysFilter;", "dims", "Lkd/bos/olapServer2/metadata/DimensionCollection;", "init", "Lkd/bos/olapServer2/collections/MutableBitSet;", "isAggMemberFilters", "", "Lkd/bos/olapServer2/computingEngine/StoredFilter$IsAggMemberFilterPair;", "hasSomeAggShieldRuleDimensions", "", "hasSomeExpressionRuleDimensions", "(Lkd/bos/olapServer2/metadata/DimensionCollection;Lkd/bos/olapServer2/collections/MutableBitSet;[Lkd/bos/olapServer2/computingEngine/StoredFilter$IsAggMemberFilterPair;[I[I)V", "[Lkd/bos/olapServer2/computingEngine/StoredFilter$IsAggMemberFilterPair;", "isExpressionRuleEmpty", "", "()Z", "resultCache", "clone", "match", "Lkd/bos/olapServer2/common/bool;", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "reverse", "Lkd/bos/olapServer2/computingEngine/NotStoredFilter;", "IsAggMemberFilterPair", "bos-olap-core2"})
public final class StoredFilter
implements IDimensionKeysFilter {
    @NotNull
    private final DimensionCollection dims;
    @NotNull
    private final MutableBitSet init;
    @NotNull
    private final IsAggMemberFilterPair[] isAggMemberFilters;
    @NotNull
    private final int[] hasSomeAggShieldRuleDimensions;
    @NotNull
    private final int[] hasSomeExpressionRuleDimensions;
    private final boolean isExpressionRuleEmpty;
    @NotNull
    private final MutableBitSet resultCache;

    public StoredFilter(@NotNull DimensionCollection dims, @NotNull MutableBitSet init2, @NotNull IsAggMemberFilterPair[] isAggMemberFilters, @NotNull int[] hasSomeAggShieldRuleDimensions, @NotNull int[] hasSomeExpressionRuleDimensions) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)init2, (String)"init");
        Intrinsics.checkNotNullParameter((Object)isAggMemberFilters, (String)"isAggMemberFilters");
        Intrinsics.checkNotNullParameter((Object)hasSomeAggShieldRuleDimensions, (String)"hasSomeAggShieldRuleDimensions");
        Intrinsics.checkNotNullParameter((Object)hasSomeExpressionRuleDimensions, (String)"hasSomeExpressionRuleDimensions");
        this.dims = dims;
        this.init = init2;
        this.isAggMemberFilters = isAggMemberFilters;
        this.hasSomeAggShieldRuleDimensions = hasSomeAggShieldRuleDimensions;
        this.hasSomeExpressionRuleDimensions = hasSomeExpressionRuleDimensions;
        this.isExpressionRuleEmpty = this.hasSomeExpressionRuleDimensions.length == 0;
        this.resultCache = MutableBitSet.Companion.create$default(MutableBitSet.Companion, this.init.getSize(), false, 2, null);
    }

    public final boolean isExpressionRuleEmpty() {
        return this.isExpressionRuleEmpty;
    }

    @NotNull
    public final IDimensionKeysFilter clone() {
        if (this.isAggMemberFilters.length == 0) {
            if (this.init.isEmpty()) {
                return AlwaysTrueDimensionKeysFilter.INSTANCE;
            }
            if (this.hasSomeAggShieldRuleDimensions.length == 0 && this.isExpressionRuleEmpty) {
                return AlwaysFalseDimensionKeysFilter.INSTANCE;
            }
        }
        return new StoredFilter(this.dims, this.init, this.isAggMemberFilters, this.hasSomeAggShieldRuleDimensions, this.hasSomeExpressionRuleDimensions);
    }

    @Override
    public boolean match(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        MutableBitSet result2 = this.resultCache;
        result2.copyFrom(this.init);
        for (IsAggMemberFilterPair isAggMemberFilterPair : this.isAggMemberFilters) {
            int dimPosition = isAggMemberFilterPair.component1();
            INumberSetFilter isAggNodeFilter = isAggMemberFilterPair.component2();
            if (!isAggNodeFilter.match(key2.get(dimPosition))) continue;
            result2.setTrue(dimPosition);
        }
        if (result2.isEmpty()) {
            return true;
        }
        for (int dimPosition : this.hasSomeAggShieldRuleDimensions) {
            IAggShieldRuleMasker masker;
            int memberPosition;
            Dimension dimension = (Dimension)this.dims.get(dimPosition);
            if (!dimension.isDefinedAggShieldRule(memberPosition = key2.get(dimPosition)) || (masker = dimension.getMembers().get(memberPosition).getAggShieldRuleMasker()) == null) continue;
            result2.and(masker.getStoredShieldRuleMask(key2));
        }
        for (int dimPosition : this.hasSomeExpressionRuleDimensions) {
            Dimension dimension = (Dimension)this.dims.get(dimPosition);
            int memberPosition = key2.get(dimPosition);
            if (!result2.get(dimPosition) || !dimension.isDefinedExpressionRule(memberPosition)) continue;
            ExpressionUnit original = dimension.getMembers().get(memberPosition).tryGetOriginal();
            if (!(original != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (original.isCalculated(key2)) continue;
            result2.setFalse(dimPosition);
        }
        return result2.isEmpty();
    }

    @NotNull
    public final NotStoredFilter reverse() {
        return new NotStoredFilter(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/StoredFilter$IsAggMemberFilterPair;", "", "dimensionPosition", "", "Lkd/bos/olapServer2/common/int;", "isAggMemberFilter", "Lkd/bos/olapServer2/collections/INumberSetFilter;", "(ILkd/bos/olapServer2/collections/INumberSetFilter;)V", "getDimensionPosition", "()I", "()Lkd/bos/olapServer2/collections/INumberSetFilter;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "bos-olap-core2"})
    public static final class IsAggMemberFilterPair {
        private final int dimensionPosition;
        @NotNull
        private final INumberSetFilter isAggMemberFilter;

        public IsAggMemberFilterPair(int dimensionPosition, @NotNull INumberSetFilter isAggMemberFilter) {
            Intrinsics.checkNotNullParameter((Object)isAggMemberFilter, (String)"isAggMemberFilter");
            this.dimensionPosition = dimensionPosition;
            this.isAggMemberFilter = isAggMemberFilter;
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        @NotNull
        public final INumberSetFilter isAggMemberFilter() {
            return this.isAggMemberFilter;
        }

        public final int component1() {
            return this.dimensionPosition;
        }

        @NotNull
        public final INumberSetFilter component2() {
            return this.isAggMemberFilter;
        }

        @NotNull
        public final IsAggMemberFilterPair copy(int dimensionPosition, @NotNull INumberSetFilter isAggMemberFilter) {
            Intrinsics.checkNotNullParameter((Object)isAggMemberFilter, (String)"isAggMemberFilter");
            return new IsAggMemberFilterPair(dimensionPosition, isAggMemberFilter);
        }

        public static /* synthetic */ IsAggMemberFilterPair copy$default(IsAggMemberFilterPair isAggMemberFilterPair, int n, INumberSetFilter iNumberSetFilter, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = isAggMemberFilterPair.dimensionPosition;
            }
            if ((n2 & 2) != 0) {
                iNumberSetFilter = isAggMemberFilterPair.isAggMemberFilter;
            }
            return isAggMemberFilterPair.copy(n, iNumberSetFilter);
        }

        @NotNull
        public String toString() {
            return "IsAggMemberFilterPair(dimensionPosition=" + this.dimensionPosition + ", isAggMemberFilter=" + this.isAggMemberFilter + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.dimensionPosition);
            result2 = result2 * 31 + this.isAggMemberFilter.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IsAggMemberFilterPair)) {
                return false;
            }
            IsAggMemberFilterPair isAggMemberFilterPair = (IsAggMemberFilterPair)other;
            if (this.dimensionPosition != isAggMemberFilterPair.dimensionPosition) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isAggMemberFilter, (Object)isAggMemberFilterPair.isAggMemberFilter);
        }
    }
}

