/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.collections.IReferenceIterator;
import kd.bos.olapServer2.collections.IReferenceIteratorKt;
import kd.bos.olapServer2.collections.SingleIterator;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.computingEngine.ComputingUnitValidator;
import kd.bos.olapServer2.computingEngine.CubeMeasureKey;
import kd.bos.olapServer2.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer2.computingEngine.Factor;
import kd.bos.olapServer2.computingEngine.FactorUnit;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.IFactorCollection;
import kd.bos.olapServer2.computingEngine.IOtherCubeFactorCollection;
import kd.bos.olapServer2.computingEngine.IntArrayKey;
import kd.bos.olapServer2.computingEngine.OverrideData;
import kd.bos.olapServer2.computingEngine.OverrideDimensionGroup;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.ILinkedCubeWorkspaceCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0007,-./012B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010$\u001a\u00020\"2\n\u0010%\u001a\u00060\u0017j\u0002`&H\u0086\u0002J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\"J\u0014\u0010)\u001a\u00060\u0017j\u0002`&2\u0006\u0010(\u001a\u00020\"H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020\"R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer;", "", "filter", "Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "linkedCubes", "Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;", "(Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;)V", "_complexUnits", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitContainer;", "_otherUnits", "Ljava/util/HashMap;", "Lkd/bos/olapServer2/computingEngine/CubeMeasureKey;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer;", "Lkotlin/collections/HashMap;", "_simpleUnits", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;", "complexUnits", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "getComplexUnits", "()Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "computingUnitValidator", "Lkd/bos/olapServer2/computingEngine/ComputingUnitValidator;", "count", "", "getCount", "()I", "otherUnits", "", "getOtherUnits", "()Ljava/util/Map;", "simpleUnits", "getSimpleUnits", "units", "Ljava/util/ArrayList;", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "Lkotlin/collections/ArrayList;", "get", "index", "Lkd/bos/olapServer2/common/int;", "indexOf", "unit", "isSimpleUnit", "mapping", "", "ComplexUnitCollection", "ComplexUnitContainer", "Mapper", "OtherCubeUnitContainer", "SimpleUnitCollection", "SimpleUnitContainer", "UnitContainer", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nUnitDependencyMapperContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,659:1\n372#2,7:660\n*S KotlinDebug\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer\n*L\n70#1:660,7\n*E\n"})
public final class UnitDependencyMapperContainer {
    @Nullable
    private final DimensionFilterCollection filter;
    @NotNull
    private final ILinkedCubeWorkspaceCollection linkedCubes;
    @NotNull
    private final ArrayList<IComputingUnit> units;
    @NotNull
    private final ComplexUnitContainer _complexUnits;
    @NotNull
    private final SimpleUnitContainer _simpleUnits;
    @NotNull
    private final HashMap<CubeMeasureKey, OtherCubeUnitContainer> _otherUnits;
    @NotNull
    private final ComputingUnitValidator computingUnitValidator;

    public UnitDependencyMapperContainer(@Nullable DimensionFilterCollection filter2, @NotNull ILinkedCubeWorkspaceCollection linkedCubes) {
        Intrinsics.checkNotNullParameter((Object)linkedCubes, (String)"linkedCubes");
        this.filter = filter2;
        this.linkedCubes = linkedCubes;
        this.units = new ArrayList();
        this._complexUnits = new ComplexUnitContainer(this.filter);
        this._simpleUnits = new SimpleUnitContainer();
        this._otherUnits = new HashMap();
        this.computingUnitValidator = new ComputingUnitValidator(this.filter, false, 2, null);
    }

    public /* synthetic */ UnitDependencyMapperContainer(DimensionFilterCollection dimensionFilterCollection, ILinkedCubeWorkspaceCollection iLinkedCubeWorkspaceCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dimensionFilterCollection = null;
        }
        if ((n & 2) != 0) {
            iLinkedCubeWorkspaceCollection = ILinkedCubeWorkspaceCollection.EmptyLinkedCubeWorkspaceCollection.INSTANCE;
        }
        this(dimensionFilterCollection, iLinkedCubeWorkspaceCollection);
    }

    @NotNull
    public final UnitContainer getComplexUnits() {
        return this._complexUnits;
    }

    @NotNull
    public final UnitContainer getSimpleUnits() {
        return this._simpleUnits;
    }

    @NotNull
    public final Map<CubeMeasureKey, UnitContainer> getOtherUnits() {
        return this._otherUnits;
    }

    public final void mapping(@NotNull IComputingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.computingUnitValidator.check(unit);
        int unitSequence = this.units.size();
        int dimensionIndex = this.isSimpleUnit(unit);
        if (dimensionIndex >= 0) {
            this._simpleUnits.mapping(unit, unitSequence, dimensionIndex);
        } else {
            this._complexUnits.mapping(unit, unitSequence);
        }
        IFactorCollection iFactorCollection = unit.getFactors();
        IOtherCubeFactorCollection iOtherCubeFactorCollection = iFactorCollection instanceof IOtherCubeFactorCollection ? (IOtherCubeFactorCollection)((Object)iFactorCollection) : null;
        if (iOtherCubeFactorCollection != null) {
            IOtherCubeFactorCollection factors2 = iOtherCubeFactorCollection;
            boolean bl = false;
            for (Map.Entry<CubeMeasureKey, IFactorCollection> entry : factors2.getOthers().entrySet()) {
                Object object2;
                CubeMeasureKey cubeMeasureKey = entry.getKey();
                IFactorCollection otherFactors = entry.getValue();
                Map $this$getOrPut$iv = this._otherUnits;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(cubeMeasureKey);
                if (value$iv == null) {
                    boolean bl2 = false;
                    OtherCubeUnitContainer answer$iv = new OtherCubeUnitContainer(this.filter, this.linkedCubes, cubeMeasureKey.getCubeId());
                    $this$getOrPut$iv.put(cubeMeasureKey, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                OtherCubeUnitContainer otherCubeUnitContainer = (OtherCubeUnitContainer)object2;
                otherCubeUnitContainer.mapping(unit, otherFactors, unitSequence);
            }
        }
        this.units.add(unit);
    }

    private final int isSimpleUnit(IComputingUnit unit) {
        OverrideData target = unit.getTarget();
        if (target.getOverrideCount() != 1) {
            return -1;
        }
        int dimensionIndex = -1;
        int n = target.getCount();
        for (int i = 0; i < n; ++i) {
            if (target.get(i) < 0) continue;
            dimensionIndex = i;
            break;
        }
        if (!(dimensionIndex >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        for (Factor factor : unit.getFactors()) {
            if (factor.getData().getOverrideCount() == 1 && factor.getData().get(dimensionIndex) >= 0) continue;
            return -1;
        }
        return dimensionIndex;
    }

    public final int getCount() {
        return this.units.size();
    }

    @NotNull
    public final IComputingUnit get(int index2) {
        IComputingUnit iComputingUnit = this.units.get(index2);
        Intrinsics.checkNotNullExpressionValue((Object)iComputingUnit, (String)"get(...)");
        return iComputingUnit;
    }

    public final int indexOf(@NotNull IComputingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.units.indexOf(unit);
    }

    public UnitDependencyMapperContainer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002X\u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00010\u0001j6\u0012\u0004\u0012\u00020\u0002\u0012,\u0012*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u0006`\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010JF\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00032.\u0010\u0013\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u00062\u0006\u0010\u0014\u001a\u00020\u0005J6\u0010\u0015\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u00062\u0006\u0010\u0016\u001a\u00020\u0002\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitCollection;", "Ljava/util/HashMap;", "Lkd/bos/olapServer2/computingEngine/OverrideDimensionGroup;", "Lkd/bos/olapServer2/computingEngine/IntArrayKey;", "", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "Lkotlin/collections/HashMap;", "()V", "add", "", "factors", "Lkd/bos/olapServer2/computingEngine/IFactorCollection;", "unit", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "unitSequence", "", "Lkd/bos/olapServer2/common/int;", "addToList", "mIndexes", "map", "newItem", "getOrCreateMap", "dIndexes", "bos-olap-core2"})
    private static final class ComplexUnitCollection
    extends HashMap<OverrideDimensionGroup, HashMap<IntArrayKey, FactorUnit[]>> {
        @NotNull
        public final HashMap<IntArrayKey, FactorUnit[]> getOrCreateMap(@NotNull OverrideDimensionGroup dIndexes) {
            Intrinsics.checkNotNullParameter((Object)dIndexes, (String)"dIndexes");
            HashMap map2 = (HashMap)this.get((Object)dIndexes);
            if (map2 == null) {
                map2 = new HashMap();
                ((Map)this).put(dIndexes, map2);
            }
            return map2;
        }

        public final void addToList(@NotNull IntArrayKey mIndexes, @NotNull HashMap<IntArrayKey, FactorUnit[]> map2, @NotNull FactorUnit newItem) {
            Intrinsics.checkNotNullParameter((Object)mIndexes, (String)"mIndexes");
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            Object[] value2 = map2.get(mIndexes);
            if (value2 == null) {
                FactorUnit[] factorUnitArray = new FactorUnit[]{newItem};
                value2 = factorUnitArray;
                ((Map)map2).put(mIndexes, value2);
            } else {
                ((Map)map2).put(mIndexes, ArraysKt.plus((Object[])value2, (Object)newItem));
            }
        }

        public final void add(@NotNull IFactorCollection factors2, @NotNull IComputingUnit unit, int unitSequence) {
            Intrinsics.checkNotNullParameter((Object)factors2, (String)"factors");
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            for (Factor factor : factors2) {
                OverrideData data = factor.getData();
                OverrideDimensionGroup dimensionIndexKey = data.createOverrideDimensionGroup();
                IntArrayKey mIndexes = IntArrayKey.Companion.create(data, dimensionIndexKey);
                HashMap<IntArrayKey, FactorUnit[]> dimensionMap = this.getOrCreateMap(dimensionIndexKey);
                FactorUnit newItem = new FactorUnit(factor, unit, unitSequence);
                this.addToList(mIndexes, dimensionMap, newItem);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitContainer;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "filter", "Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "(Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;)V", "_factorMaps", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitCollection;", "_targetMaps", "createMapper", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "mapping", "", "unit", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "unitSequence", "", "Lkd/bos/olapServer2/common/int;", "ComplexMapper", "bos-olap-core2"})
    private static final class ComplexUnitContainer
    extends UnitContainer {
        @Nullable
        private final DimensionFilterCollection filter;
        @NotNull
        private final ComplexUnitCollection _factorMaps;
        @NotNull
        private final ComplexUnitCollection _targetMaps;

        public ComplexUnitContainer(@Nullable DimensionFilterCollection filter2) {
            this.filter = filter2;
            this._factorMaps = new ComplexUnitCollection();
            this._targetMaps = new ComplexUnitCollection();
        }

        public final void mapping(@NotNull IComputingUnit unit, int unitSequence) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            IFactorCollection factors2 = unit.getFactors();
            this._factorMaps.add(factors2, unit, unitSequence);
            OverrideData target = unit.getTarget();
            OverrideDimensionGroup targetKey = target.createOverrideDimensionGroup();
            HashMap<IntArrayKey, FactorUnit[]> targetMap = this._targetMaps.getOrCreateMap(targetKey);
            IntArrayKey key2 = IntArrayKey.Companion.create(target, targetKey);
            FactorUnit newItem = new FactorUnit(new Factor(target, 0), unit, unitSequence);
            this._targetMaps.addToList(key2, targetMap, newItem);
            super.mapping(unit);
        }

        @Override
        @NotNull
        public Mapper createMapper() {
            return new ComplexMapper();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitContainer$ComplexMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "(Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitContainer;)V", "overrideKeyCache", "Lkd/bos/olapServer2/computingEngine/IntArrayKey;", "findUnitByTarget", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "target", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "fixResult", "", "rowKey", "result", "", "getDependencyComputingUnits", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "getIntArrayKey", "bos-olap-core2"})
        private final class ComplexMapper
        extends Mapper {
            @Nullable
            private IntArrayKey overrideKeyCache;

            private final IntArrayKey getIntArrayKey(IDimensionKeys rowKey) {
                IntArrayKey mIndexes = this.overrideKeyCache;
                if (mIndexes == null) {
                    int[] mArray = new int[rowKey.getCount()];
                    this.overrideKeyCache = mIndexes = new IntArrayKey(mArray, rowKey.getCount());
                }
                return mIndexes;
            }

            @Override
            @NotNull
            public IReferenceIterator<FactorUnit> getDependencyComputingUnits(@NotNull IDimensionKeys rowKey) {
                Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
                IntArrayKey mIndexes = this.getIntArrayKey(rowKey);
                int[] mArray = mIndexes.getData();
                this.resetResult();
                int findCount = 0;
                for (Map.Entry entry : ((Map)ComplexUnitContainer.this._factorMaps).entrySet()) {
                    OverrideDimensionGroup key2 = (OverrideDimensionGroup)entry.getKey();
                    HashMap values = (HashMap)entry.getValue();
                    mIndexes.setCount(key2.getOverrideCount());
                    for (int dimensionIndex : key2.getOverrideDimensionIndexes()) {
                        mArray[i] = rowKey.get(dimensionIndex);
                    }
                    FactorUnit[] factorUnitList = (FactorUnit[])values.get(mIndexes);
                    if (factorUnitList == null) continue;
                    this.addAll(factorUnitList);
                    ++findCount;
                }
                List<FactorUnit> result2 = this.getResultAsList();
                if (findCount > 1) {
                    this.fixResult(rowKey, result2);
                }
                return IReferenceIteratorKt.toReferenceIterator(result2);
            }

            private final void fixResult(IDimensionKeys rowKey, List<FactorUnit> result2) {
                if (ComplexUnitContainer.this.filter == null) {
                    return;
                }
                int n = rowKey.getCount();
                block0: for (int dimPos = 0; dimPos < n; ++dimPos) {
                    DimensionFilter dimFilter = ComplexUnitContainer.this.filter.getByDimensionPosition(dimPos);
                    if (dimFilter == null) continue;
                    Iterator<FactorUnit> factorUnits = result2.iterator();
                    while (factorUnits.hasNext()) {
                        FactorUnit fu = factorUnits.next();
                        if (fu.getFactor().getData().get(dimPos) >= 0) continue;
                        Member member = dimFilter.getDimension().getMembers().get(rowKey.get(dimPos));
                        if (dimFilter.getMembers().contains(member)) continue block0;
                        factorUnits.remove();
                    }
                }
            }

            @Override
            @NotNull
            public FactorUnit findUnitByTarget(@NotNull IDimensionKeys target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                IntArrayKey mIndexes = this.getIntArrayKey(target);
                int[] mArray = mIndexes.getData();
                for (Map.Entry entry : ((Map)ComplexUnitContainer.this._targetMaps).entrySet()) {
                    OverrideDimensionGroup key2 = (OverrideDimensionGroup)entry.getKey();
                    HashMap values = (HashMap)entry.getValue();
                    mIndexes.setCount(key2.getOverrideCount());
                    for (int dimensionIndex : key2.getOverrideDimensionIndexes()) {
                        mArray[i] = target.get(dimensionIndex);
                    }
                    FactorUnit[] factorUnitList = (FactorUnit[])values.get(mIndexes);
                    if (factorUnitList == null || !(!(factorUnitList.length == 0))) continue;
                    return factorUnitList[0];
                }
                String string2 = Res.INSTANCE.getUnitDependencyMapperContainerException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-UnitDependencyMappe\u2026ontainerException_3>(...)");
                Object[] objectArray = new Object[]{target};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0004J\u001b\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0004\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u0011H&J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0004J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0004J\b\u0010\u0018\u001a\u00020\bH\u0004R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "", "()V", "resultCache", "Ljava/util/ArrayList;", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "Lkotlin/collections/ArrayList;", "add", "", "item", "addAll", "items", "", "([Lkd/bos/olapServer2/computingEngine/FactorUnit;)V", "", "findUnitByTarget", "target", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "getDependencyComputingUnits", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "rowKey", "getResult", "getResultAsList", "", "resetResult", "bos-olap-core2"})
    public static abstract class Mapper {
        @NotNull
        private ArrayList<FactorUnit> resultCache = new ArrayList();

        protected final void resetResult() {
            this.resultCache.clear();
        }

        protected final void add(@NotNull FactorUnit item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.resultCache.add(item);
        }

        protected final void addAll(@NotNull FactorUnit[] items2) {
            Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
            if (items2.length == 1) {
                this.resultCache.add(items2[0]);
            } else {
                CollectionsKt.addAll((Collection)this.resultCache, (Object[])items2);
            }
        }

        protected final void addAll(@NotNull List<FactorUnit> items2) {
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            if (items2.size() == 1) {
                this.resultCache.add(items2.get(0));
            } else {
                this.resultCache.addAll((Collection<FactorUnit>)items2);
            }
        }

        @NotNull
        protected final List<FactorUnit> getResultAsList() {
            return this.resultCache;
        }

        @NotNull
        protected final IReferenceIterator<FactorUnit> getResult() {
            return IReferenceIteratorKt.toReferenceIterator((List)this.resultCache);
        }

        @NotNull
        public abstract IReferenceIterator<FactorUnit> getDependencyComputingUnits(@NotNull IDimensionKeys var1);

        @NotNull
        public abstract FactorUnit findUnitByTarget(@NotNull IDimensionKeys var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0007j\u0002`\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "filter", "Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;", "linkedCubes", "Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/computingEngine/DimensionFilterCollection;Lkd/bos/olapServer2/metadata/ILinkedCubeWorkspaceCollection;I)V", "_factorMaps", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$ComplexUnitCollection;", "linkedCube", "Lkd/bos/olapServer2/metadata/Cube;", "getLinkedCube", "()Lkd/bos/olapServer2/metadata/Cube;", "createMapper", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "mapping", "", "unit", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "cubeIdFactors", "Lkd/bos/olapServer2/computingEngine/IFactorCollection;", "unitSequence", "OtherCubeMapper", "bos-olap-core2"})
    private static final class OtherCubeUnitContainer
    extends UnitContainer {
        @Nullable
        private final DimensionFilterCollection filter;
        @NotNull
        private final ILinkedCubeWorkspaceCollection linkedCubes;
        private final int cubeId;
        @NotNull
        private final ComplexUnitCollection _factorMaps;

        public OtherCubeUnitContainer(@Nullable DimensionFilterCollection filter2, @NotNull ILinkedCubeWorkspaceCollection linkedCubes, int cubeId) {
            Intrinsics.checkNotNullParameter((Object)linkedCubes, (String)"linkedCubes");
            this.filter = filter2;
            this.linkedCubes = linkedCubes;
            this.cubeId = cubeId;
            this._factorMaps = new ComplexUnitCollection();
        }

        private final Cube getLinkedCube() {
            return this.linkedCubes.getCube(this.cubeId);
        }

        public final void mapping(@NotNull IComputingUnit unit, @NotNull IFactorCollection cubeIdFactors, int unitSequence) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            Intrinsics.checkNotNullParameter((Object)cubeIdFactors, (String)"cubeIdFactors");
            this._factorMaps.add(cubeIdFactors, unit, unitSequence);
            super.mapping(unit);
        }

        @Override
        @NotNull
        public Mapper createMapper() {
            return new OtherCubeMapper();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\"\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001c\u0010\u0016\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0012H\u0002\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer$OtherCubeMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "(Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer;)V", "findUnitByTarget", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "target", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "fixResult", "", "rowKey", "result", "", "getDependencyComputingUnits", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "include", "", "Lkd/bos/olapServer2/common/bool;", "array1", "", "array2", "", "", "withSameDim", "dims", "bos-olap-core2"})
        @SourceDebugExtension(value={"SMAP\nUnitDependencyMapperContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer$OtherCubeMapper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,659:1\n215#2:660\n215#2,2:665\n216#2:667\n11095#3:661\n11430#3,3:662\n*S KotlinDebug\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$OtherCubeUnitContainer$OtherCubeMapper\n*L\n483#1:660\n491#1:665,2\n483#1:667\n490#1:661\n490#1:662,3\n*E\n"})
        private final class OtherCubeMapper
        extends Mapper {
            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IReferenceIterator<FactorUnit> getDependencyComputingUnits(@NotNull IDimensionKeys rowKey) {
                Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
                this.resetResult();
                int[] rowKeyArray = rowKey.getArray();
                Map $this$forEach$iv = OtherCubeUnitContainer.this._factorMaps;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Object unitFactor;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    OverrideDimensionGroup dims = (OverrideDimensionGroup)entry.getKey();
                    HashMap overrideMembers = (HashMap)entry.getValue();
                    OtherCubeMapper $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243 = this;
                    boolean bl2 = false;
                    if ($this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243.withSameDim(dims.getOverrideDimensionIndexes(), rowKeyArray)) {
                        Object v = overrideMembers.get(new IntArrayKey(rowKeyArray));
                        Intrinsics.checkNotNull(v);
                        FactorUnit[] factorUnitArray = (FactorUnit[])v;
                        int n = factorUnitArray.length;
                        for (int i = 0; i < n; ++i) {
                            unitFactor = factorUnitArray[i];
                            $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243.add((FactorUnit)unitFactor);
                        }
                        continue;
                    }
                    int[] $this$map$iv = dims.getOverrideDimensionIndexes();
                    boolean $i$f$map = false;
                    unitFactor = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void item;
                        void item$iv$iv;
                        void var22_26 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(rowKeyArray[item]);
                    }
                    List overrideIndices = (List)destination$iv$iv;
                    Map $this$forEach$iv2 = overrideMembers;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry entry2 = element$iv2 = iterator3.next();
                        boolean bl4 = false;
                        IntArrayKey rowIndices = (IntArrayKey)entry2.getKey();
                        FactorUnit[] unitFactors = (FactorUnit[])entry2.getValue();
                        OtherCubeMapper $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243;
                        boolean bl5 = false;
                        if (!$this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.include(rowIndices.getData(), overrideIndices)) continue;
                        if (unitFactors.length == 1) {
                            $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.add(unitFactors[0]);
                            continue;
                        }
                        $this$getDependencyComputingUnits_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.addAll(unitFactors);
                    }
                }
                List<FactorUnit> result2 = this.getResultAsList();
                if (result2.size() > 1) {
                    this.fixResult(rowKey, result2);
                }
                return this.getResult();
            }

            private final void fixResult(IDimensionKeys rowKey, List<FactorUnit> result2) {
                if (OtherCubeUnitContainer.this.filter == null) {
                    return;
                }
                int n = rowKey.getCount();
                block0: for (int dimPos = 0; dimPos < n; ++dimPos) {
                    Dimension linkedDimension = (Dimension)OtherCubeUnitContainer.this.getLinkedCube().getDimensions().get(dimPos);
                    DimensionFilter dimFilter = OtherCubeUnitContainer.this.filter.getByName$bos_olap_core2(linkedDimension.getName());
                    if (dimFilter == null) continue;
                    Iterator<FactorUnit> factorUnits = result2.iterator();
                    while (factorUnits.hasNext()) {
                        FactorUnit factorUnit = factorUnits.next();
                        if (factorUnit.getFactor().getData().get(dimPos) >= 0) continue;
                        Member linkedMember = linkedDimension.getMembers().get(rowKey.get(dimPos));
                        Member member = dimFilter.getDimension().getMembers().get(linkedMember.getName());
                        if (dimFilter.getMembers().contains(member)) continue block0;
                        factorUnits.remove();
                    }
                }
            }

            @Override
            @NotNull
            public FactorUnit findUnitByTarget(@NotNull IDimensionKeys target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                throw new NotSupportedException("otherCube not support findUnitByTarget method");
            }

            private final boolean withSameDim(int[] dims, int[] rowKey) {
                if (dims.length != rowKey.length) {
                    return false;
                }
                for (int dim : dims) {
                    if (rowKey[dim] >= 0) continue;
                    return false;
                }
                return true;
            }

            private final boolean include(int[] array1, List<Integer> array2) {
                if (array1.length == 0 && array2.isEmpty()) {
                    return true;
                }
                if (array1.length != array2.size()) {
                    return false;
                }
                int n = array1.length;
                for (int i = 0; i < n; ++i) {
                    if (array1[i] == -1 || array1[i] == ((Number)array2.get(i)).intValue()) continue;
                    return false;
                }
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002N\u0012\"\u0012 \u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u00020\u0001j&\u0012\"\u0012 \u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0002`\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00052\n\u0010\n\u001a\u00060\u0003j\u0002`\u0004J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00052\n\u0010\r\u001a\u00060\u0003j\u0002`\u0004\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitCollection;", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Lkd/bos/olapServer2/common/int;", "", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "Lkotlin/collections/ArrayList;", "()V", "getOrCreateDimensionList", "dimensionIndex", "getOrCreateMemberList", "source", "memberIndex", "bos-olap-core2"})
    private static final class SimpleUnitCollection
    extends ArrayList<Pair<? extends Integer, ? extends List<List<FactorUnit>>>> {
        @NotNull
        public final List<List<FactorUnit>> getOrCreateDimensionList(int dimensionIndex) {
            int insertIndex = 0;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                insertIndex = i;
                Object e = this.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Pair item = (Pair)e;
                if (((Number)item.getFirst()).intValue() == dimensionIndex) {
                    return (List)item.getSecond();
                }
                if (((Number)item.getFirst()).intValue() > dimensionIndex) break;
            }
            Pair newItem = new Pair((Object)dimensionIndex, (Object)new ArrayList());
            this.add(insertIndex, newItem);
            return (List)newItem.getSecond();
        }

        @NotNull
        public final List<FactorUnit> getOrCreateMemberList(@NotNull List<List<FactorUnit>> source2, int memberIndex) {
            List result2;
            int i;
            Intrinsics.checkNotNullParameter(source2, (String)"source");
            if (memberIndex >= source2.size() && (i = source2.size()) <= memberIndex) {
                while (true) {
                    source2.add(null);
                    if (i == memberIndex) break;
                    ++i;
                }
            }
            if ((result2 = source2.get(memberIndex)) == null) {
                result2 = new ArrayList();
                source2.set(memberIndex, result2);
            }
            return result2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eJ\u000e\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "()V", "_factorMaps", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitCollection;", "_targetMaps", "createMapper", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "mapping", "", "unit", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "unitSequence", "", "Lkd/bos/olapServer2/common/int;", "dimensionIndex", "tryGetVerySimpleMapper", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$VerySimpleMapper;", "AbstractSimpleMapper", "SimpleMapper", "VerySimpleMapper", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nUnitDependencyMapperContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,659:1\n1726#2,3:660\n*S KotlinDebug\n*F\n+ 1 UnitDependencyMapperContainer.kt\nkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer\n*L\n246#1:660,3\n*E\n"})
    private static final class SimpleUnitContainer
    extends UnitContainer {
        @NotNull
        private final SimpleUnitCollection _factorMaps = new SimpleUnitCollection();
        @NotNull
        private final SimpleUnitCollection _targetMaps = new SimpleUnitCollection();

        public final void mapping(@NotNull IComputingUnit unit, int unitSequence, int dimensionIndex) {
            Object data;
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            List<List<FactorUnit>> factorMap = this._factorMaps.getOrCreateDimensionList(dimensionIndex);
            for (Factor factor : unit.getFactors()) {
                data = factor.getData();
                if (!(((OverrideData)data).getOverrideCount() == 1)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                int memberIndex = ((OverrideData)data).get(dimensionIndex);
                if (!(memberIndex >= 0)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                List<FactorUnit> factorUnitList = this._factorMaps.getOrCreateMemberList(factorMap, memberIndex);
                FactorUnit newItem = new FactorUnit(factor, unit, unitSequence);
                factorUnitList.add(newItem);
            }
            OverrideData target = unit.getTarget();
            if (!(target.getOverrideCount() == 1)) {
                data = "Failed requirement.";
                throw new IllegalArgumentException(data.toString());
            }
            int targetIndex = target.get(dimensionIndex);
            if (!(targetIndex >= 0)) {
                String memberIndex = "Failed requirement.";
                throw new IllegalArgumentException(memberIndex.toString());
            }
            List<List<FactorUnit>> targetMap = this._targetMaps.getOrCreateDimensionList(dimensionIndex);
            List<FactorUnit> targetList = this._targetMaps.getOrCreateMemberList(targetMap, targetIndex);
            targetList.add(new FactorUnit(new Factor(target, 0), unit, unitSequence));
            super.mapping(unit);
        }

        @Override
        @NotNull
        public Mapper createMapper() {
            VerySimpleMapper verySimpleMapper = this.tryGetVerySimpleMapper();
            return verySimpleMapper != null ? (Mapper)verySimpleMapper : (Mapper)new SimpleMapper();
        }

        private final VerySimpleMapper tryGetVerySimpleMapper() {
            if (this._factorMaps.size() == 1) {
                boolean bl;
                List list2;
                int dimensionIndex;
                block6: {
                    Pair pair = (Pair)this._factorMaps.get(0);
                    dimensionIndex = ((Number)pair.component1()).intValue();
                    list2 = (List)pair.component2();
                    Iterable $this$all$iv = list2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            List it = (List)element$iv;
                            boolean bl2 = false;
                            if (it == null || it.size() <= 1) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    int n = list2.size();
                    FactorUnit[] factorUnitArray = new FactorUnit[n];
                    for (int i = 0; i < n; ++i) {
                        int n2 = i;
                        List item = (List)list2.get(n2);
                        factorUnitArray[n2] = item == null || item.size() == 0 ? null : (FactorUnit)item.get(0);
                    }
                    FactorUnit[] resultArray = factorUnitArray;
                    return new VerySimpleMapper(dimensionIndex, resultArray);
                }
            }
            return null;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$AbstractSimpleMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "(Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;)V", "findUnitByTarget", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "target", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "bos-olap-core2"})
        private abstract class AbstractSimpleMapper
        extends Mapper {
            @Override
            @NotNull
            public FactorUnit findUnitByTarget(@NotNull IDimensionKeys target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                for (Pair pair : SimpleUnitContainer.this._targetMaps) {
                    int dimensionIndex = ((Number)pair.component1()).intValue();
                    List map2 = (List)pair.component2();
                    int memberIndex = target.get(dimensionIndex);
                    List factorUnitList = memberIndex < map2.size() ? (List)map2.get(memberIndex) : null;
                    if (factorUnitList == null || !(!((Collection)factorUnitList).isEmpty())) continue;
                    return (FactorUnit)factorUnitList.get(0);
                }
                String string2 = Res.INSTANCE.getUnitDependencyMapperContainerException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-UnitDependencyMappe\u2026ontainerException_3>(...)");
                Object[] objectArray = new Object[]{target};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$SimpleMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$AbstractSimpleMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;", "(Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;)V", "getDependencyComputingUnits", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "rowKey", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "bos-olap-core2"})
        private final class SimpleMapper
        extends AbstractSimpleMapper {
            @Override
            @NotNull
            public IReferenceIterator<FactorUnit> getDependencyComputingUnits(@NotNull IDimensionKeys rowKey) {
                Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
                this.resetResult();
                for (Pair pair : SimpleUnitContainer.this._factorMaps) {
                    int dimensionIndex = ((Number)pair.component1()).intValue();
                    List map2 = (List)pair.component2();
                    int memberIndex = rowKey.get(dimensionIndex);
                    List factorUnitList = memberIndex < map2.size() ? (List)map2.get(memberIndex) : null;
                    if (factorUnitList == null) continue;
                    this.addAll(factorUnitList);
                }
                return this.getResult();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$VerySimpleMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer$AbstractSimpleMapper;", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;", "dimensionIndex", "", "Lkd/bos/olapServer2/common/int;", "map", "", "Lkd/bos/olapServer2/computingEngine/FactorUnit;", "(Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$SimpleUnitContainer;I[Lkd/bos/olapServer2/computingEngine/FactorUnit;)V", "[Lkd/bos/olapServer2/computingEngine/FactorUnit;", "getDependencyComputingUnits", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "rowKey", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "bos-olap-core2"})
        private final class VerySimpleMapper
        extends AbstractSimpleMapper {
            private final int dimensionIndex;
            @NotNull
            private final FactorUnit[] map;

            public VerySimpleMapper(@NotNull int dimensionIndex, FactorUnit[] map2) {
                Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
                this.dimensionIndex = dimensionIndex;
                this.map = map2;
            }

            @Override
            @NotNull
            public IReferenceIterator<FactorUnit> getDependencyComputingUnits(@NotNull IDimensionKeys rowKey) {
                FactorUnit factorUnitList;
                Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
                int memberIndex = rowKey.get(this.dimensionIndex);
                FactorUnit factorUnit = factorUnitList = memberIndex < this.map.length ? this.map[memberIndex] : null;
                if (factorUnitList != null) {
                    return new SingleIterator<FactorUnit>(factorUnitList);
                }
                return this.getResult();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH&J\u0015\u0010\r\u001a\u00020\u00022\n\u0010\u000e\u001a\u00060\u0005j\u0002`\u000fH\u0086\u0002J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$UnitContainer;", "", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "()V", "count", "", "getCount", "()I", "units", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "createMapper", "Lkd/bos/olapServer2/computingEngine/UnitDependencyMapperContainer$Mapper;", "get", "index", "Lkd/bos/olapServer2/common/int;", "iterator", "", "mapping", "", "unit", "bos-olap-core2"})
    public static abstract class UnitContainer
    implements Iterable<IComputingUnit>,
    KMappedMarker {
        @NotNull
        private final ArrayList<IComputingUnit> units = new ArrayList();

        protected void mapping(@NotNull IComputingUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            this.units.add(unit);
        }

        @Override
        @NotNull
        public Iterator<IComputingUnit> iterator() {
            Iterator<IComputingUnit> iterator2 = this.units.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            return iterator2;
        }

        public final int getCount() {
            return this.units.size();
        }

        @NotNull
        public final IComputingUnit get(int index2) {
            IComputingUnit iComputingUnit = this.units.get(index2);
            Intrinsics.checkNotNullExpressionValue((Object)iComputingUnit, (String)"get(...)");
            return iComputingUnit;
        }

        @NotNull
        public abstract Mapper createMapper();
    }
}

