/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.batchTasks;

import java.io.Closeable;
import java.util.Collection;
import kd.bos.olapServer2.computingEngine.AggComputingUnit;
import kd.bos.olapServer2.computingEngine.ComputeMode;
import kd.bos.olapServer2.computingEngine.ComputingLevel;
import kd.bos.olapServer2.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer2.computingEngine.ExpressionComputingUnit;
import kd.bos.olapServer2.computingEngine.OverrideData;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer2.computingEngine.thread.ComputingWorkspace;
import kd.bos.olapServer2.dataSources.AggAxis;
import kd.bos.olapServer2.dataSources.AggExpression;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.DragonLambdaExpression;
import kd.bos.olapServer2.dataSources.IExpressionItem;
import kd.bos.olapServer2.dataSources.JsLambdaExpression;
import kd.bos.olapServer2.dataSources.LambdaExpression;
import kd.bos.olapServer2.dataSources.MultiDimensionAggExpression;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTaskBuilder;", "", "command", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "ctx", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "computingLevel", "Lkd/bos/olapServer2/computingEngine/ComputingLevel;", "(Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;Lkd/bos/olapServer2/transactions/WriteTransaction;Lkd/bos/olapServer2/computingEngine/ComputingLevel;)V", "_state", "", "axis", "Lkd/bos/olapServer2/dataSources/AggAxis;", "getComputingLevel", "()Lkd/bos/olapServer2/computingEngine/ComputingLevel;", "add", "", "aggExpression", "Lkd/bos/olapServer2/dataSources/AggExpression;", "checkAggExpressionCommand", "Lkd/bos/olapServer2/metadata/Dimension;", "mainDimension", "expressItem", "checkScopeAndExpress", "target", "Lkd/bos/olapServer2/computingEngine/OverrideData;", "item", "Lkd/bos/olapServer2/dataSources/LambdaExpression;", "convert", "Lkd/bos/olapServer2/dataSources/IExpressionItem;", "getComputingUnit", "Lkd/bos/olapServer2/computingEngine/ExpressionComputingUnit;", "initTaskBuilder", "run", "bos-olap-core2"})
public final class ComputingTaskBuilder {
    @NotNull
    private final ComputingCommandInfo command;
    @NotNull
    private final ComputingContext ctx;
    @Nullable
    private final WriteTransaction transaction;
    @NotNull
    private final ComputingLevel computingLevel;
    private int _state;
    @NotNull
    private final AggAxis axis;

    public ComputingTaskBuilder(@NotNull ComputingCommandInfo command, @NotNull ComputingContext ctx, @Nullable WriteTransaction transaction, @NotNull ComputingLevel computingLevel) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)computingLevel, (String)"computingLevel");
        this.command = command;
        this.ctx = ctx;
        this.transaction = transaction;
        this.computingLevel = computingLevel;
        this.axis = new AggAxis();
    }

    public /* synthetic */ ComputingTaskBuilder(ComputingCommandInfo computingCommandInfo, ComputingContext computingContext, WriteTransaction writeTransaction, ComputingLevel computingLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            writeTransaction = null;
        }
        if ((n & 8) != 0) {
            computingLevel = new ComputingLevel(computingContext.getCubeWorkspace().getMetadata(), computingCommandInfo, computingContext.getLinkedCubes());
        }
        this(computingCommandInfo, computingContext, writeTransaction, computingLevel);
    }

    @NotNull
    public final ComputingLevel getComputingLevel() {
        return this.computingLevel;
    }

    @NotNull
    public final Object convert(@NotNull IExpressionItem expressItem) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)expressItem, (String)"expressItem");
        Cube cube = this.ctx.getCubeWorkspace().getMetadata();
        IExpressionItem iExpressionItem = expressItem;
        if (iExpressionItem instanceof MultiDimensionAggExpression) {
            object2 = MultiDimensionAggComputingUnit.Companion.getMultiAggComputingUnit(cube, (MultiDimensionAggExpression)expressItem, this.ctx.getMainDimension(), this.computingLevel.getFilter());
        } else if (iExpressionItem instanceof AggExpression) {
            Dimension aggMainDimension = this.checkAggExpressionCommand(this.ctx.getMainDimension(), (AggExpression)expressItem);
            object2 = new AggComputingUnit(cube.getDimensions(), (AggExpression)expressItem, aggMainDimension, ComputeMode.Default);
        } else if (iExpressionItem instanceof LambdaExpression) {
            object2 = this.getComputingUnit((LambdaExpression)expressItem);
        } else {
            String string2 = Res.INSTANCE.getComputingCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingCommandExecutorException_1>(...)");
            Object[] objectArray = new Object[]{expressItem.getClass()};
            throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
        }
        return object2;
    }

    public final void add(@NotNull AggExpression aggExpression) {
        Intrinsics.checkNotNullParameter((Object)aggExpression, (String)"aggExpression");
        if (aggExpression.canChangeToMultiAgg()) {
            this.axis.getExpressionItems().add(aggExpression);
        } else {
            this.computingLevel.addAnyUnit(this.convert(aggExpression));
        }
    }

    public final void initTaskBuilder() {
        if (!((Collection)this.axis.getExpressionItems()).isEmpty()) {
            MultiDimensionAggExpression newExpression = new MultiDimensionAggExpression();
            newExpression.addAxis(this.axis);
            this.computingLevel.addAnyUnit(this.convert(newExpression));
        }
    }

    private final Dimension checkAggExpressionCommand(Dimension mainDimension, AggExpression expressItem) {
        if (mainDimension == null) {
            String string2 = Res.INSTANCE.getComputingTaskBuilderException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingTaskBuilderException_2>(...)");
            throw Res.INSTANCE.getNotSupportedException(string2, new Object[0]);
        }
        if (this.computingLevel.getFilter().contains(mainDimension)) {
            String string3 = Res.INSTANCE.getCheckScopeAndExpress_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CheckScopeAndExpress_1>(...)");
            Object[] objectArray = new Object[]{String.valueOf(expressItem), mainDimension.getName()};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        return mainDimension;
    }

    private final ExpressionComputingUnit getComputingUnit(LambdaExpression item) {
        ExpressionComputingUnit expressionComputingUnit;
        LambdaExpression lambdaExpression = item;
        if (lambdaExpression instanceof JsLambdaExpression) {
            expressionComputingUnit = this.ctx.getJsParser().parse((JsLambdaExpression)item);
        } else if (lambdaExpression instanceof DragonLambdaExpression) {
            expressionComputingUnit = this.ctx.getDragonParser().parse((DragonLambdaExpression)item);
        } else {
            String string2 = Res.INSTANCE.getComputingCommandExecutorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingCommandExecutorException_2>(...)");
            Object[] objectArray = new Object[]{item.getClass().getSimpleName()};
            throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
        }
        ExpressionComputingUnit result2 = expressionComputingUnit;
        this.checkScopeAndExpress(result2.getTarget(), item);
        return result2;
    }

    private final void checkScopeAndExpress(OverrideData target, LambdaExpression item) {
        DimensionCollection dims = this.ctx.getCubeWorkspace().getMetadata().getDimensions();
        DimensionFilterCollection filters = this.computingLevel.getFilter();
        int n = target.getCount();
        for (int i = 0; i < n; ++i) {
            if (target.get(i) <= -1 || !filters.contains((Dimension)dims.get(i))) continue;
            String string2 = Res.INSTANCE.getCheckScopeAndExpress_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CheckScopeAndExpress_1>(...)");
            Object[] objectArray = new Object[]{item.getExpressLeft() + " = " + item.getExpression(), ((Dimension)dims.get(i)).getName()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.initTaskBuilder();
        if (!(this._state == 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.computingLevel.getCount() == 0 && this.computingLevel.getMultiAggUnits().isEmpty()) {
            return;
        }
        this.computingLevel.check();
        Closeable closeable = new ComputingWorkspace(this.ctx, this.computingLevel, this.ctx.getTempPool(), this.transaction);
        Throwable throwable = null;
        try {
            ComputingWorkspace computingWorkspace = (ComputingWorkspace)closeable;
            boolean bl = false;
            this._state = 1;
            StandardCommandStatistics.INSTANCE.reportTimeState(CommandStatisticsItem.Companion.getCalculating());
            computingWorkspace.compute();
            this._state = 2;
            StandardCommandStatistics.INSTANCE.reportTimeState(CommandStatisticsItem.Companion.getWriting());
            computingWorkspace.copyTempCubeDataToMainCube();
            StandardCommandStatistics.INSTANCE.reportTimeState(CommandStatisticsItem.Companion.getFinishing());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this._state = 3;
    }
}

