/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.batchTasks;

import kd.bos.olapServer2.collections.ILongIterator;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.query.ForecastingLoadingRowIndexesEventArgs;
import kd.bos.olapServer2.query.IPossibleRowIndexIterator;
import kd.bos.olapServer2.query.IRowIndexIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J \u0010\u001b\u001a\u00060\u000bj\u0002`\r2\u0006\u0010\u001c\u001a\u00020\u00102\n\u0010\u001d\u001a\u00060\u000bj\u0002`\rH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002J\f\u0010\u001f\u001a\u00060 j\u0002`!H\u0016J\u001c\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00102\n\u0010\u001d\u001a\u00060\u000bj\u0002`\rH\u0002R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u000bj\u0002`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000bj\u0002`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/computingEngine/batchTasks/LongBatchLockedResourceIterator;", "TSource", "Lkd/bos/olapServer2/collections/ILongIterator;", "Lkd/bos/olapServer2/query/IRowIndexIterator;", "Lkd/bos/olapServer2/query/IPossibleRowIndexIterator;", "source", "(Lkd/bos/olapServer2/collections/ILongIterator;)V", "_current", "", "Lkd/bos/olapServer2/common/long;", "_forecastingLoadingCheckPoint", "", "_index", "Lkd/bos/olapServer2/common/int;", "_size", "cacheArray", "", "current", "getCurrent", "()J", "e", "Lkd/bos/olapServer2/query/ForecastingLoadingRowIndexesEventArgs;", "forecastingLoading", "Lkd/bos/olapServer2/common/EventHandlerList;", "getForecastingLoading", "()Lkd/bos/olapServer2/common/EventHandlerList;", "Lkd/bos/olapServer2/collections/ILongIterator;", "load", "array", "size", "loadArray", "next", "", "Lkd/bos/olapServer2/common/bool;", "nextRange", "", "bos-olap-core2"})
public final class LongBatchLockedResourceIterator<TSource extends ILongIterator>
implements IRowIndexIterator,
IPossibleRowIndexIterator {
    @NotNull
    private final TSource source;
    @NotNull
    private final long[] cacheArray;
    private long _current;
    private int _size;
    private int _index;
    @NotNull
    private final EventHandlerList<IPossibleRowIndexIterator, ForecastingLoadingRowIndexesEventArgs> forecastingLoading;
    private int _forecastingLoadingCheckPoint;
    @NotNull
    private final ForecastingLoadingRowIndexesEventArgs e;

    public LongBatchLockedResourceIterator(@NotNull TSource source2) {
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        this.source = source2;
        this.cacheArray = new long[512];
        if (!(!(this.cacheArray.length == 0))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this._current = this.cacheArray[0];
        this.forecastingLoading = new EventHandlerList();
        this._forecastingLoadingCheckPoint = -1;
        this.e = new ForecastingLoadingRowIndexesEventArgs(0L, 0L);
    }

    @Override
    @NotNull
    public EventHandlerList<IPossibleRowIndexIterator, ForecastingLoadingRowIndexesEventArgs> getForecastingLoading() {
        return this.forecastingLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int load(long[] array, int size) {
        TSource TSource = this.source;
        synchronized (TSource) {
            boolean bl = false;
            int realSize = 0;
            while (realSize < size && this.source.next()) {
                array[realSize++] = this.source.getCurrent();
            }
            this._forecastingLoadingCheckPoint = 0;
            int n = realSize;
            return n;
        }
    }

    private final long[] loadArray() {
        this._size = this.load(this.cacheArray, this.cacheArray.length);
        this._index = 0;
        return this.cacheArray;
    }

    @Override
    public boolean next() {
        long[] array = this.cacheArray;
        if (this._index >= this._size) {
            array = this.loadArray();
            if (this._size == 0) {
                return false;
            }
        }
        this._current = array[this._index];
        if (this._forecastingLoadingCheckPoint == this._index) {
            this.nextRange(array, this._size);
        }
        int n = this._index;
        this._index = n + 1;
        return true;
    }

    private final void nextRange(long[] array, int size) {
        int i = this._index;
        long start = array[i];
        long next = start + 1L;
        while (++i < size && array[i] == next) {
            long l = next;
            next = l + 1L;
        }
        if (next - start >= 4L) {
            this.e.setStart(start);
            this.e.setEnd(next - 1L);
            this.getForecastingLoading().invoke(this, this.e);
        }
        this._forecastingLoadingCheckPoint = i;
    }

    @Override
    public long getCurrent() {
        return this._current;
    }
}

