/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.batchTasks;

import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.computingEngine.IComputingScope;
import kd.bos.olapServer2.computingEngine.IComputingUnit;
import kd.bos.olapServer2.computingEngine.UnitDependencyMapperContainer;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingScope;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingTask;
import kd.bos.olapServer2.computingEngine.thread.ComputingResourceContainer;
import kd.bos.olapServer2.computingEngine.thread.ComputingWorkspace;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.storages.tempStorages.MutableLinkedListFactorRow;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/computingEngine/batchTasks/StandardComputingTask;", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTask;", "computingWorkspace", "Lkd/bos/olapServer2/computingEngine/thread/ComputingWorkspace;", "(Lkd/bos/olapServer2/computingEngine/thread/ComputingWorkspace;)V", "execute", "", "unit", "Lkd/bos/olapServer2/computingEngine/IComputingUnit;", "scope", "Lkd/bos/olapServer2/computingEngine/IComputingScope;", "executeJobCore", "", "res", "Lkd/bos/olapServer2/computingEngine/thread/ComputingResourceContainer;", "ctx", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;", "onStarting", "bos-olap-core2"})
public final class StandardComputingTask
extends ComputingTask {
    @NotNull
    private final ComputingWorkspace computingWorkspace;

    public StandardComputingTask(@NotNull ComputingWorkspace computingWorkspace) {
        Intrinsics.checkNotNullParameter((Object)computingWorkspace, (String)"computingWorkspace");
        this.computingWorkspace = computingWorkspace;
    }

    @Override
    public void onStarting() {
        super.onStarting();
        this.computingWorkspace.getSharedResourceContainer().getTargetList().flush();
    }

    @Override
    protected void executeJobCore(@NotNull ComputingResourceContainer res, @NotNull ComputingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MutableLinkedListFactorRow targetList = this.computingWorkspace.getSharedResourceContainer().pollSubTargetList();
        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
        ComputingScope scope = new ComputingScope(ctx.getCube(), ctx.getMainDimension(), this.computingWorkspace.getSharedResourceContainer().getJoinCubes());
        while (targetList != null) {
            MutableLinkedListFactorRow.CalcUnitRowIterator source2 = targetList.iterator();
            UnitDependencyMapperContainer units = this.computingWorkspace.getDependencyContainer();
            while (source2.next() && continueToken.canContinue()) {
                IDimensionKeys targetKey = source2.getTargetKey();
                IComputingUnit unit = units.get(source2.getCalcUnitId());
                scope.switch(unit, targetKey, source2.getFactorArray());
                Object mainMeasureValue = this.execute(unit, scope);
                targetList.updateTargetValue(source2.getIndex(), mainMeasureValue);
            }
            ctx.getFactorCount().addAndGet(targetList.getFactorCount());
            targetList = this.computingWorkspace.getSharedResourceContainer().pollSubTargetList();
        }
    }

    private final Object execute(IComputingUnit unit, IComputingScope scope) {
        Object value2 = null;
        try {
            value2 = unit.execute(scope);
        }
        catch (ArithmeticException ex) {
            String message2 = ex.getMessage();
            if (message2 == null) {
                String string2 = Res.INSTANCE.getComputingTaskException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingTaskException_3>(...)");
                Object[] objectArray = new Object[]{unit};
                throw Res.INSTANCE.getRuntimeException(string2, ex, objectArray);
            }
            if (Intrinsics.areEqual((Object)message2, (Object)"BigInteger divide by zero") || Intrinsics.areEqual((Object)message2, (Object)"Division by zero")) {
                String string3 = Res.INSTANCE.getComputingTaskException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ComputingTaskException_2>(...)");
                Object[] objectArray = new Object[]{unit};
                throw Res.INSTANCE.getRuntimeException(string3, ex, objectArray);
            }
            String string4 = Res.INSTANCE.getComputingTaskException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ComputingTaskException_1>(...)");
            Object[] objectArray = new Object[]{unit, ex.getMessage()};
            throw Res.INSTANCE.getRuntimeException(string4, ex, objectArray);
        }
        catch (Exception ex) {
            String string5 = Res.INSTANCE.getComputingTaskException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-ComputingTaskException_1>(...)");
            Object[] objectArray = new Object[]{unit, ex.getMessage()};
            throw Res.INSTANCE.getRuntimeException(string5, ex, objectArray);
        }
        return value2 == CommonTypesKt.getUndefined() ? null : value2;
    }
}

