/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.dynamicCalc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.computingEngine.dynamicCalc.DSCacheQuerySession;
import kd.bos.olapServer2.computingEngine.dynamicCalc.DynamicCalcSession;
import kd.bos.olapServer2.computingEngine.dynamicCalc.ExpandedDimensionFilter;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.query.models.ContainerFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.query.models.ModelOptimizer;
import kd.bos.olapServer2.query.models.PartitionFilter;
import kd.bos.olapServer2.selects.IQuerySession;
import kd.bos.olapServer2.selects.Query;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.IDSCacheCredibleSnapshot;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0016\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006J$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0016\u0010\u0014\u001a\u00060\u0005j\u0002`\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010\u0014\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0017\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/computingEngine/dynamicCalc/DynamicCalcQuerySessionBuilder;", "", "()V", "confirmScenario", "Lkotlin/Pair;", "", "Lkd/bos/olapServer2/common/bool;", "snapshot", "Lkd/bos/olapServer2/storages/dynamicCalcAndStored/IDSCacheCredibleSnapshot;", "createQuerySession", "Lkd/bos/olapServer2/selects/IQuerySession;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "resourcePool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "query", "Lkd/bos/olapServer2/selects/Query;", "isParallel", "isSimpleFilter", "createQuerySession4Base", "isOutputDS", "filter", "Lkd/bos/olapServer2/query/models/Filter;", "isOutputOnlyFirstMeasure", "queryOptimize", "source", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDynamicCalcQuerySessionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicCalcQuerySessionBuilder.kt\nkd/bos/olapServer2/computingEngine/dynamicCalc/DynamicCalcQuerySessionBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1549#2:135\n1620#2,3:136\n*S KotlinDebug\n*F\n+ 1 DynamicCalcQuerySessionBuilder.kt\nkd/bos/olapServer2/computingEngine/dynamicCalc/DynamicCalcQuerySessionBuilder\n*L\n76#1:135\n76#1:136,3\n*E\n"})
public final class DynamicCalcQuerySessionBuilder {
    @NotNull
    public static final DynamicCalcQuerySessionBuilder INSTANCE = new DynamicCalcQuerySessionBuilder();

    private DynamicCalcQuerySessionBuilder() {
    }

    @NotNull
    public final IQuerySession createQuerySession(@NotNull CubeWorkspace cubeWorkspace, @NotNull ByteBufferResourcePool resourcePool, @NotNull Query query2, boolean isParallel, boolean isSimpleFilter) {
        IQuerySession iQuerySession;
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)resourcePool, (String)"resourcePool");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Cube cube = cubeWorkspace.getMetadata();
        boolean requireDS = cube.getRequireDS();
        if (CommonTypesKt.getDynamicCalcEnabled() && !query2.getExcludeDynamicCalcResult()) {
            if (requireDS && this.isOutputDS(query2) && this.isOutputOnlyFirstMeasure(query2)) {
                IDSCacheCredibleSnapshot snapshot = cubeWorkspace.getDSCacheCredibleSnapshot();
                Pair<Boolean, Boolean> pair = this.confirmScenario(snapshot);
                boolean forDSAsD = (Boolean)pair.component1();
                boolean forDSAsS = (Boolean)pair.component2();
                ExpandedDimensionFilter helper = new ExpandedDimensionFilter(query2.getFilter(), cube, query2.getIncludeDynamicMemberWhenNullFilter(), forDSAsD, forDSAsS);
                iQuerySession = helper.getContainCalc() || query2.getExcludeJunkDataWhenOnlyQueryBase() ? (IQuerySession)new DSCacheQuerySession(cubeWorkspace, resourcePool, query2, snapshot, helper, isParallel, isSimpleFilter) : this.createQuerySession4Base(query2, cubeWorkspace, isParallel);
            } else {
                ExpandedDimensionFilter helper = new ExpandedDimensionFilter(query2.getFilter(), cube, query2.getIncludeDynamicMemberWhenNullFilter(), false, false, 24, null);
                iQuerySession = helper.getContainCalc() || query2.getExcludeJunkDataWhenOnlyQueryBase() ? (IQuerySession)DynamicCalcSession.Companion.create4OnlyDSAsD(cubeWorkspace, resourcePool, query2, helper, isSimpleFilter, isParallel) : (requireDS ? this.createQuerySession4Base(query2, cubeWorkspace, isParallel) : cubeWorkspace.createQuerySession(this.queryOptimize(query2), isParallel));
            }
        } else {
            iQuerySession = cubeWorkspace.createQuerySession(this.queryOptimize(query2), isParallel);
        }
        return iQuerySession;
    }

    /*
     * WARNING - void declaration
     */
    private final IQuerySession createQuerySession4Base(Query query2, CubeWorkspace cubeWorkspace, boolean isParallel) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.queryOptimize(query2);
        Iterable iterable = cubeWorkspace.getMetadata().getBasePartitionItems();
        Filter filter2 = query2.getFilter();
        PartitionFilter.Companion companion = PartitionFilter.Companion;
        Query query3 = query2;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IPartitionItem iPartitionItem = (IPartitionItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        query3.setFilter(companion.wrap(filter2, (List<Integer>)collection, cubeWorkspace.getMetadata().getPartitionItems()));
        return cubeWorkspace.createQuerySession(query2, isParallel);
    }

    private final Pair<Boolean, Boolean> confirmScenario(IDSCacheCredibleSnapshot snapshot) {
        return snapshot.getCrediblePartitionPairs().isEmpty() ? new Pair((Object)true, (Object)false) : (snapshot.getNotCrediblePartitions().isEmpty() ? new Pair((Object)false, (Object)true) : new Pair((Object)true, (Object)true));
    }

    private final boolean isOutputOnlyFirstMeasure(Query query2) {
        return query2.getMeasures().getCount() == 1 && query2.getMeasures().get(0).getPosition() == 0;
    }

    private final boolean isOutputDS(Query query2) {
        return query2.getIncludeDynamicMemberWhenNullFilter() ? true : this.isOutputDS(query2.getFilter());
    }

    private final boolean isOutputDS(Filter filter2) {
        if (filter2 == null) {
            return false;
        }
        Filter filter3 = filter2;
        if (filter3 instanceof DimensionFilter) {
            return ((DimensionFilter)filter2).getDimension().getExistAnyDStoredMember();
        }
        if (filter3 instanceof ContainerFilter) {
            for (Filter it : ((ContainerFilter)filter2).getChildren()) {
                if (!this.isOutputDS(it)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final Query queryOptimize(Query source2) {
        source2.setFilter(new ModelOptimizer(source2.getFilter()).optimize());
        return source2;
    }
}

