/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.dynamicCalc;

import java.util.ArrayList;
import java.util.List;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.Axis;
import kd.bos.olapServer2.computingEngine.multiDimensionAgg.MultiDimensionAggComputingUnit;
import kd.bos.olapServer2.metadata.expressions.ExpressionUnit;
import kd.bos.olapServer2.query.models.AndFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.query.models.ModelOptimizer;
import kd.bos.olapServer2.query.models.OrFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/computingEngine/dynamicCalc/FilterWalker4Expanded;", "", "()V", "expandedDimFilter", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "sourceDimFilter", "axis", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/Axis;", "walk", "Lkd/bos/olapServer2/query/models/Filter;", "sourceFilter", "unit", "Lkd/bos/olapServer2/computingEngine/multiDimensionAgg/MultiDimensionAggComputingUnit;", "walkCore", "bos-olap-core2"})
public final class FilterWalker4Expanded {
    @NotNull
    public static final FilterWalker4Expanded INSTANCE = new FilterWalker4Expanded();

    private FilterWalker4Expanded() {
    }

    @Nullable
    public final Filter walk(@Nullable Filter sourceFilter, @NotNull MultiDimensionAggComputingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return sourceFilter == null ? null : (unit.getAxes().isEmpty() ? sourceFilter : new ModelOptimizer(this.walkCore(sourceFilter, unit)).optimize());
    }

    private final Filter walkCore(Filter sourceFilter, MultiDimensionAggComputingUnit unit) {
        Filter filter2;
        Filter filter3 = sourceFilter;
        if (filter3 instanceof OrFilter) {
            ArrayList<Filter> newContainer = new ArrayList<Filter>(((OrFilter)sourceFilter).getSize());
            for (Filter child : sourceFilter.getChildren()) {
                newContainer.add(this.walkCore(child, unit));
            }
            filter2 = new OrFilter((List<Filter>)newContainer);
        } else if (filter3 instanceof AndFilter) {
            ArrayList<Filter> newContainer = new ArrayList<Filter>(((AndFilter)sourceFilter).getSize());
            for (Filter child : sourceFilter.getChildren()) {
                newContainer.add(this.walkCore(child, unit));
            }
            filter2 = new AndFilter((List<Filter>)newContainer);
        } else if (filter3 instanceof DimensionFilter) {
            Axis axis = unit.tryGetAxis(((DimensionFilter)sourceFilter).getDimension());
            filter2 = this.expandedDimFilter((DimensionFilter)sourceFilter, axis);
        } else {
            throw new RuntimeException("Not Support Filter: " + sourceFilter);
        }
        return filter2;
    }

    private final DimensionFilter expandedDimFilter(DimensionFilter sourceDimFilter, Axis axis) {
        DimensionFilter expandedDimensionFilter = sourceDimFilter.cloneWithoutFrozen();
        if (axis != null) {
            for (ExpressionUnit expression : axis.getUnits()) {
                if (!sourceDimFilter.getMembers().contains(expression.getTarget())) continue;
                expandedDimensionFilter.getMembers().addAll(expression.getFactorBitmap());
            }
        }
        return expandedDimensionFilter;
    }
}

