/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.scriptBindings;

import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer.grammar.DragonFunction;
import kd.bos.olapServer.grammar.IExecuteContext;
import kd.bos.olapServer.grammar.exception.AbstractDragonException;
import kd.bos.olapServer.grammar.expr.IExpr;
import kd.bos.olapServer2.computingEngine.IComputingScope;
import kd.bos.olapServer2.computingEngine.scriptBindings.DragonObjectBinding;
import kd.bos.olapServer2.computingEngine.scriptBindings.ScriptBuiltin;
import kd.bos.olapServer2.server.OlapSession;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001:\f\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005J)\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin;", "", "()V", "cachedDragonEngine", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkd/bos/olapServer/grammar/DragonEngine;", "getDragonEngine", "parse", "Lkd/bos/olapServer/grammar/expr/IExpr;", "expression", "", "Lkd/bos/olapServer2/common/string;", "registerFunctions", "", "provider", "releaseDragonEngine", "engine", "valueDragon", "Lkd/bos/olapServer2/computingEngine/IComputingScope;", "subExprs", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer2/computingEngine/IComputingScope;[Lkd/bos/olapServer/grammar/expr/IExpr;Lkd/bos/olapServer/grammar/IExecuteContext;)Ljava/lang/Object;", "AbsFun", "CubeFun", "DecimalFun", "DivFun", "IsEmptyFun", "IsNullFun", "PropertyFun", "RoundFun", "StartsWithFun", "TryToDecimalFun", "VFun", "ValueFun", "bos-olap-core2"})
public final class DragonScriptBuiltin {
    @NotNull
    public static final DragonScriptBuiltin INSTANCE = new DragonScriptBuiltin();
    @NotNull
    private static final AtomicReference<DragonEngine> cachedDragonEngine = new AtomicReference();

    private DragonScriptBuiltin() {
    }

    private final Object valueDragon(IComputingScope $this$valueDragon, IExpr[] subExprs, IExecuteContext ctx) {
        if (subExprs.length == 0) {
            String string2 = Res.INSTANCE.getScriptBuiltinException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
            Object[] objectArray = new Object[]{"value(v : object) : object"};
            throw Res.INSTANCE.getNullPointerException(string2, objectArray);
        }
        if (subExprs.length > 1) {
            String string3 = Res.INSTANCE.getScriptBuiltException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ScriptBuiltException_2>(...)");
            Object[] objectArray = new Object[]{"value"};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        if (!DragonEngine.Companion.isStringExpr(subExprs[0])) {
            String string4 = Res.INSTANCE.getScriptBuiltException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ScriptBuiltException_3>(...)");
            Object[] objectArray = new Object[]{"value", 1, "string"};
            throw Res.INSTANCE.getRuntimeException(string4, objectArray);
        }
        Object object2 = subExprs[0].execute(ctx);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }");
        return $this$valueDragon.getValue((String)object2);
    }

    @NotNull
    public final DragonEngine getDragonEngine() {
        DragonEngine cache = cachedDragonEngine.getAndSet(null);
        if (cache == null) {
            DragonEngine engine = new DragonEngine();
            DragonEngine.Companion.setCurrentLocale(OlapSession.Companion.getCurrentLocale());
            this.registerFunctions(engine);
            return engine;
        }
        return cache;
    }

    public final void releaseDragonEngine(@NotNull DragonEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        cachedDragonEngine.set(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IExpr parse(@NotNull String expression) {
        IExpr iExpr;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        DragonEngine engine = this.getDragonEngine();
        try {
            iExpr = engine.parse(expression);
        }
        catch (AbstractDragonException e) {
            String realExceptionMsg = DragonEngine.Companion.getDragonEngineExceptionMsg(e);
            String string2 = Res.INSTANCE.getExpressionParserException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ExpressionParserException_3>(...)");
            Object[] objectArray = new Object[]{expression, realExceptionMsg};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        catch (Exception e) {
            String string3 = Res.INSTANCE.getExpressionParserException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ExpressionParserException_3>(...)");
            Object[] objectArray = new Object[]{expression, e.getMessage()};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        finally {
            this.releaseDragonEngine(engine);
        }
        return iExpr;
    }

    private final void registerFunctions(DragonEngine provider) {
        provider.register((DragonFunction)new ValueFun());
        provider.register((DragonFunction)new VFun());
        provider.register((DragonFunction)new DecimalFun());
        provider.register((DragonFunction)new AbsFun());
        provider.register((DragonFunction)new IsEmptyFun());
        provider.register((DragonFunction)new IsNullFun());
        provider.register((DragonFunction)new RoundFun());
        provider.register((DragonFunction)new DivFun());
        provider.register((DragonFunction)new TryToDecimalFun());
        provider.register((DragonFunction)new CubeFun());
        provider.register((DragonFunction)new PropertyFun());
        provider.register((DragonFunction)new StartsWithFun());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$AbsFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class AbsFun
    extends DragonFunction {
        private int returnDataType;

        public AbsFun() {
            super("abs");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg = subExprs[0].execute(ctx);
            return ScriptBuiltin.INSTANCE.abs(arg);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 1) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"abs(value: object): object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$CubeFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class CubeFun
    extends DragonFunction {
        private int returnDataType;

        public CubeFun() {
            super("cube");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            String string2 = Res.INSTANCE.getScriptBuiltinException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_2>(...)");
            throw Res.INSTANCE.getNotSupportedException(string2, new Object[0]);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$DecimalFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class DecimalFun
    extends DragonFunction {
        private int returnDataType;

        public DecimalFun() {
            super("decimal");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @NotNull
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg = subExprs[0].execute(ctx);
            return ScriptBuiltin.INSTANCE.decimal(arg);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 1) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"decimal(value: object): object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$DivFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class DivFun
    extends DragonFunction {
        private int returnDataType;

        public DivFun() {
            super("div");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object left = subExprs[0].execute(ctx);
            Object right = subExprs[1].execute(ctx);
            Object valueOnRightIsZero = subExprs[2].execute(ctx);
            if (subExprs.length == 4) {
                int n;
                Object arg4 = subExprs[3].execute(ctx);
                if (arg4 instanceof Integer) {
                    n = ((Number)arg4).intValue();
                } else if (arg4 instanceof Number) {
                    n = ((Number)arg4).intValue();
                } else {
                    String string2 = Res.INSTANCE.getScriptBuiltException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltException_3>(...)");
                    Object[] objectArray = new Object[]{"round", 4, "int"};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                int digits = n;
                object2 = ScriptBuiltin.INSTANCE.div(left, right, valueOnRightIsZero, digits);
            } else {
                object2 = ScriptBuiltin.INSTANCE.div(left, right, valueOnRightIsZero);
            }
            return object2;
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 3 && subExprs.length != 4) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"div(left : object, right : object, valueOnRightIsZero : object [, digits : int]) : object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$IsEmptyFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class IsEmptyFun
    extends DragonFunction {
        private int returnDataType = 6;

        public IsEmptyFun() {
            super("isEmpty");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @NotNull
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg = subExprs[0].execute(ctx);
            return ScriptBuiltin.INSTANCE.isEmpty(arg);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 1) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"isEmpty(value : object) : bool"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$IsNullFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class IsNullFun
    extends DragonFunction {
        private int returnDataType = 6;

        public IsNullFun() {
            super("isNull");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @NotNull
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg = subExprs[0].execute(ctx);
            return ScriptBuiltin.INSTANCE.isNull(arg);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 1) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"isNull(value : object) : bool"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$PropertyFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class PropertyFun
    extends DragonFunction {
        private int returnDataType;

        public PropertyFun() {
            super("property");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object object2 = subExprs[0].execute(ctx);
            if (object2 == null) {
                String string2 = Res.INSTANCE.getScriptBuiltException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltException_3>(...)");
                Object[] objectArray = new Object[]{"obj", 1, "object"};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            Object obj = object2;
            Object arg2 = subExprs[1].execute(ctx);
            if (!(arg2 instanceof String)) {
                String string3 = Res.INSTANCE.getScriptBuiltException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ScriptBuiltException_3>(...)");
                Object[] objectArray = new Object[]{"name", 2, "String"};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            String name2 = (String)arg2;
            return ScriptBuiltin.INSTANCE.property(obj, name2);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 2) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"property(obj : object, name : String) : object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$RoundFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class RoundFun
    extends DragonFunction {
        private int returnDataType;

        public RoundFun() {
            super("round");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            int n;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object value2 = subExprs[0].execute(ctx);
            Object arg2 = subExprs[1].execute(ctx);
            if (arg2 instanceof Integer) {
                n = ((Number)arg2).intValue();
            } else if (arg2 instanceof Number) {
                n = ((Number)arg2).intValue();
            } else {
                String string2 = Res.INSTANCE.getScriptBuiltException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltException_3>(...)");
                Object[] objectArray = new Object[]{"round", 2, "int"};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            int digits = n;
            return ScriptBuiltin.INSTANCE.round(value2, digits);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 2) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"round(value : object, digits : int) : object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$StartsWithFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "Lkd/bos/olapServer2/common/bool;", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Boolean;", "bos-olap-core2"})
    public static final class StartsWithFun
    extends DragonFunction {
        private int returnDataType = 6;

        public StartsWithFun() {
            super("startsWith");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @NotNull
        public Boolean execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg1 = subExprs[0].execute(ctx);
            if (!(arg1 instanceof String)) {
                if (arg1 == null) {
                    return false;
                }
                String string2 = Res.INSTANCE.getScriptBuiltException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltException_3>(...)");
                Object[] objectArray = new Object[]{"str", 1, "String"};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            String str = (String)arg1;
            Object arg2 = subExprs[1].execute(ctx);
            if (!(arg2 instanceof String)) {
                String string3 = Res.INSTANCE.getScriptBuiltException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ScriptBuiltException_3>(...)");
                Object[] objectArray = new Object[]{"prefix", 2, "String"};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            String prefix = (String)arg2;
            if (subExprs.length < 3) {
                bl = false;
            } else {
                Object arg3 = subExprs[2].execute(ctx);
                if (arg3 instanceof Boolean) {
                    bl = (Boolean)arg3;
                } else {
                    String string4 = Res.INSTANCE.getScriptBuiltException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ScriptBuiltException_3>(...)");
                    Object[] objectArray = new Object[]{"ignoreCase", 3, "Boolean"};
                    throw Res.INSTANCE.getRuntimeException(string4, objectArray);
                }
            }
            boolean ignoreCase = bl;
            return StringsKt.startsWith((String)str, (String)prefix, (boolean)ignoreCase);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 2 && subExprs.length != 3) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"startsWith(str: String, prefix: String, ignoreCase: Boolean = false): Boolean"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$TryToDecimalFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class TryToDecimalFun
    extends DragonFunction {
        private int returnDataType;

        public TryToDecimalFun() {
            super("tryToDecimal");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            Object arg = subExprs[0].execute(ctx);
            Object object2 = subExprs.length == 2 ? subExprs[1].execute(ctx) : null;
            return ScriptBuiltin.INSTANCE.tryToDecimalOrDefault(arg, object2);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            if (subExprs.length != 1 && subExprs.length != 2) {
                String string2 = Res.INSTANCE.getScriptBuiltinException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ScriptBuiltinException_1>(...)");
                Object[] objectArray = new Object[]{"tryToDecimal(value: object [, default: object]): object"};
                throw Res.INSTANCE.getNullPointerException(string2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$VFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class VFun
    extends DragonFunction {
        private int returnDataType;

        public VFun() {
            super("v");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            IComputingScope scope = ((DragonObjectBinding)ctx).getScope();
            return INSTANCE.valueDragon(scope, subExprs, ctx);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/scriptBindings/DragonScriptBuiltin$ValueFun;", "Lkd/bos/olapServer/grammar/DragonFunction;", "()V", "returnDataType", "", "getReturnDataType", "()I", "setReturnDataType", "(I)V", "checkSubExprsDataType", "", "subExprs", "", "Lkd/bos/olapServer/grammar/expr/IExpr;", "([Lkd/bos/olapServer/grammar/expr/IExpr;)V", "execute", "", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "(Lkd/bos/olapServer/grammar/IExecuteContext;[Lkd/bos/olapServer/grammar/expr/IExpr;)Ljava/lang/Object;", "bos-olap-core2"})
    public static final class ValueFun
    extends DragonFunction {
        private int returnDataType;

        public ValueFun() {
            super("value");
        }

        public int getReturnDataType() {
            return this.returnDataType;
        }

        public void setReturnDataType(int n) {
            this.returnDataType = n;
        }

        @Nullable
        public Object execute(@NotNull IExecuteContext ctx, @NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
            IComputingScope scope = ((DragonObjectBinding)ctx).getScope();
            return INSTANCE.valueDragon(scope, subExprs, ctx);
        }

        public void checkSubExprsDataType(@NotNull IExpr[] subExprs) {
            Intrinsics.checkNotNullParameter((Object)subExprs, (String)"subExprs");
        }
    }
}

