/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingContext;
import kd.bos.olapServer2.computingEngine.batchTasks.ComputingTask;
import kd.bos.olapServer2.computingEngine.thread.ComputingResourceContainer;
import kd.bos.olapServer2.computingEngine.thread.OlapThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\f\u0010\"\u001a\u00060#j\u0002`$H\u0016J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010&\u001a\u00020\u0016H\u0002J\u0006\u0010'\u001a\u00020\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\nj\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/computingEngine/thread/ComputingWorkerStarter;", "Lkd/bos/olapServer2/common/IContinueToken;", "ctx", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;", "_privateResources", "", "Lkd/bos/olapServer2/computingEngine/thread/ComputingResourceContainer;", "(Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingContext;[Lkd/bos/olapServer2/computingEngine/thread/ComputingResourceContainer;)V", "[Lkd/bos/olapServer2/computingEngine/thread/ComputingResourceContainer;", "_resIndex", "", "_timeOutStamp", "", "cex", "", "getCex", "()Ljava/lang/Throwable;", "setCex", "(Ljava/lang/Throwable;)V", "jobs", "", "Lkd/bos/olapServer2/computingEngine/thread/OlapThreadPoolExecutor$OlapFutureTask;", "", "maxWorkerCount", "Lkd/bos/olapServer2/common/int;", "parentOlapContext", "Lkd/bos/olapServer2/common/OlapContext;", "parentToken", "task", "Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTask;", "getTask", "()Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTask;", "setTask", "(Lkd/bos/olapServer2/computingEngine/batchTasks/ComputingTask;)V", "canContinue", "", "Lkd/bos/olapServer2/common/bool;", "reset", "startWorker", "waitWorkersAndClose", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nComputingWorkerStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputingWorkerStarter.kt\nkd/bos/olapServer2/computingEngine/thread/ComputingWorkerStarter\n+ 2 DebugContext.kt\nkd/bos/olapServer2/common/DebugContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n16#2,4:134\n16#2,4:138\n16#2,4:142\n16#2,4:148\n16#2,4:152\n16#2,4:156\n1855#3,2:146\n*S KotlinDebug\n*F\n+ 1 ComputingWorkerStarter.kt\nkd/bos/olapServer2/computingEngine/thread/ComputingWorkerStarter\n*L\n26#1:134,4\n51#1:138,4\n78#1:142,4\n92#1:148,4\n58#1:152,4\n73#1:156,4\n80#1:146,2\n*E\n"})
public final class ComputingWorkerStarter
implements IContinueToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComputingContext ctx;
    @NotNull
    private final ComputingResourceContainer[] _privateResources;
    @Nullable
    private final OlapContext parentOlapContext;
    @NotNull
    private final IContinueToken parentToken;
    private long _timeOutStamp;
    @NotNull
    private final List<OlapThreadPoolExecutor.OlapFutureTask<Unit>> jobs;
    private int _resIndex;
    private final int maxWorkerCount;
    @Nullable
    private Throwable cex;
    public ComputingTask task;
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem calcThreadStartTimeConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("Calc_ThreadStartTime", 100L, 1L, Long.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem calcThreadNextTimeConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("Calc_ThreadNextTime", 50L, 1L, Long.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem calcThreadCountEachTimeConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("Calc_ThreadCountEachTime", 12L, 1L, 64L, null, false, false, null, 240, null);

    public ComputingWorkerStarter(@NotNull ComputingContext ctx, @NotNull ComputingResourceContainer[] _privateResources) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)_privateResources, (String)"_privateResources");
        this.ctx = ctx;
        this._privateResources = _privateResources;
        this.parentOlapContext = OlapContext.Companion.getCurrentContext();
        IContinueToken iContinueToken = OlapContext.Companion.tryGetContext(IContinueToken.class);
        if (iContinueToken == null) {
            iContinueToken = CancellableToken.INSTANCE.getContinueToken();
        }
        this.parentToken = iContinueToken;
        this._timeOutStamp = System.nanoTime() + ComputingWorkerStarter.Companion.getCalcThreadStartTime() * 1000000L;
        this.jobs = new ArrayList();
        this._resIndex = 1;
        this.maxWorkerCount = this._privateResources.length;
    }

    @Nullable
    public final Throwable getCex() {
        return this.cex;
    }

    public final void setCex(@Nullable Throwable throwable) {
        this.cex = throwable;
    }

    @NotNull
    public final ComputingTask getTask() {
        ComputingTask computingTask = this.task;
        if (computingTask != null) {
            return computingTask;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"task");
        return null;
    }

    public final void setTask(@NotNull ComputingTask computingTask) {
        Intrinsics.checkNotNullParameter((Object)computingTask, (String)"<set-?>");
        this.task = computingTask;
    }

    public final void reset(@NotNull ComputingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean $i$f$onDebug = false;
        this.setTask(task);
        this._resIndex = 1;
        this.jobs.clear();
        this._timeOutStamp = System.nanoTime() + ComputingWorkerStarter.Companion.getCalcThreadStartTime() * 1000000L;
    }

    @Override
    public boolean canContinue() {
        this.parentToken.canContinue();
        if (this._resIndex < this.maxWorkerCount && System.nanoTime() > this._timeOutStamp && this.getTask().getHasSomeJobs()) {
            long l = Companion.getCalcThreadCountEachTime();
            for (long i = 0L; i < l && this._resIndex < this.maxWorkerCount; ++i) {
                this.startWorker();
            }
            this._timeOutStamp = System.nanoTime() + Companion.getCalcThreadNextTime() * 1000000L;
        }
        return true;
    }

    private final void startWorker() {
        boolean $i$f$onDebug = false;
        int resIndex = this._resIndex;
        int n = this._resIndex;
        this._resIndex = n + 1;
        ComputingResourceContainer res = this._privateResources[n];
        ComputingTask currentTask = this.getTask();
        Future<Unit> future = ComputingTask.Companion.getExecutor().submit(() -> ComputingWorkerStarter.startWorker$lambda$4(this, resIndex, currentTask, res));
        Intrinsics.checkNotNull(future, (String)"null cannot be cast to non-null type kd.bos.olapServer2.computingEngine.thread.OlapThreadPoolExecutor.OlapFutureTask<kotlin.Unit>");
        this.jobs.add((OlapThreadPoolExecutor.OlapFutureTask)future);
    }

    public final void waitWorkersAndClose() {
        boolean $i$f$onDebug = false;
        Iterable $this$forEach$iv = this.jobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OlapThreadPoolExecutor.OlapFutureTask it = (OlapThreadPoolExecutor.OlapFutureTask)element$iv;
            boolean bl = false;
            if (!it.isStarting()) continue;
            it.get();
        }
        $i$f$onDebug = false;
        this.getTask().close();
        Throwable cex2 = this.cex;
        if (cex2 != null) {
            throw cex2;
        }
    }

    private static final Unit startWorker$lambda$4(ComputingWorkerStarter this$0, int $resIndex, ComputingTask $currentTask, ComputingResourceContainer $res) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentTask, (String)"$currentTask");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        boolean $i$f$onDebug = false;
        OlapContext.Companion.newContext(this$0.parentOlapContext, (Function0)new Function0<Unit>($currentTask, $res, this$0){
            final /* synthetic */ ComputingTask $currentTask;
            final /* synthetic */ ComputingResourceContainer $res;
            final /* synthetic */ ComputingWorkerStarter this$0;
            {
                this.$currentTask = $currentTask;
                this.$res = $res;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$currentTask.executeJob(this.$res, ComputingWorkerStarter.access$getCtx$p(this.this$0));
            }
        }, (Function1)new Function1<Throwable, Unit>(this$0){
            final /* synthetic */ ComputingWorkerStarter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull Throwable ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                ICancellable iCancellable = OlapContext.Companion.tryGetContext(ICancellable.class);
                if (iCancellable != null) {
                    iCancellable.cancel(ex);
                }
                ComputingWorkerStarter computingWorkerStarter = this.this$0;
                ComputingWorkerStarter computingWorkerStarter2 = this.this$0;
                ComputingWorkerStarter computingWorkerStarter3 = computingWorkerStarter;
                synchronized (computingWorkerStarter3) {
                    boolean bl = false;
                    if (computingWorkerStarter2.getCex() == null) {
                        computingWorkerStarter2.setCex(ex);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        $i$f$onDebug = false;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ComputingContext access$getCtx$p(ComputingWorkerStarter $this) {
        return $this.ctx;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0018\u0010\u0010\u001a\u00060\u0004j\u0002`\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/computingEngine/thread/ComputingWorkerStarter$Companion;", "", "()V", "calcThreadCountEachTime", "", "Lkd/bos/olapServer2/common/long;", "getCalcThreadCountEachTime", "()J", "calcThreadCountEachTimeConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "getCalcThreadCountEachTimeConfigItem", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "calcThreadNextTime", "getCalcThreadNextTime", "calcThreadNextTimeConfigItem", "getCalcThreadNextTimeConfigItem", "calcThreadStartTime", "getCalcThreadStartTime", "calcThreadStartTimeConfigItem", "getCalcThreadStartTimeConfigItem", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getCalcThreadStartTimeConfigItem() {
            return calcThreadStartTimeConfigItem;
        }

        private final long getCalcThreadStartTime() {
            return this.getCalcThreadStartTimeConfigItem().getValue();
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getCalcThreadNextTimeConfigItem() {
            return calcThreadNextTimeConfigItem;
        }

        public final long getCalcThreadNextTime() {
            return this.getCalcThreadNextTimeConfigItem().getValue();
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getCalcThreadCountEachTimeConfigItem() {
            return calcThreadCountEachTimeConfigItem;
        }

        public final long getCalcThreadCountEachTime() {
            return this.getCalcThreadCountEachTimeConfigItem().getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

