/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.computingEngine.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/computingEngine/thread/DefaultThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadNamePrefix", "", "Lkd/bos/olapServer2/common/string;", "priority", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/lang/String;I)V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "bos-olap-core2"})
public final class DefaultThreadFactory
implements ThreadFactory {
    @NotNull
    private final String threadNamePrefix;
    private final int priority;
    @NotNull
    private final ThreadGroup group;
    @NotNull
    private final AtomicInteger threadNumber;

    public DefaultThreadFactory(@NotNull String threadNamePrefix, int priority) {
        ThreadGroup threadGroup;
        Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
        this.threadNamePrefix = threadNamePrefix;
        this.priority = priority;
        this.threadNumber = new AtomicInteger(1);
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            ThreadGroup threadGroup2 = s.getThreadGroup();
            threadGroup = threadGroup2;
            Intrinsics.checkNotNullExpressionValue((Object)threadGroup2, (String)"getThreadGroup(...)");
        } else {
            ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
            threadGroup = threadGroup3;
            Intrinsics.checkNotNullExpressionValue((Object)threadGroup3, (String)"getThreadGroup(...)");
        }
        this.group = threadGroup;
    }

    public /* synthetic */ DefaultThreadFactory(String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        this(string2, n);
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread t2 = new Thread(this.group, r, this.threadNamePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t2.isDaemon()) {
            t2.setDaemon(false);
        }
        t2.setPriority(this.priority);
        return t2;
    }
}

