/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.dataEntities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.dataEntities.ZipIntSerializer;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\t2\n\u0010\u0013\u001a\u00060\u0004j\u0002`\u0014J\u0011\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00072\n\u0010\f\u001a\u00060\u0004j\u0002`\u00142\n\u0010\u0019\u001a\u00060\u0004j\u0002`\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/dataEntities/ZipIntArraySerializerBuilder;", "", "()V", "_offset", "", "_serializers", "", "Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "add", "", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "maxValue", "maxValues", "", "addFixedMember", "member", "Lkd/bos/olapServer2/metadata/Member;", "addFixedValue", "fixedValue", "Lkd/bos/olapServer2/common/int;", "build", "", "()[Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "buildZipIntSerializer", "offset", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nZipIntArraySerializerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipIntArraySerializerBuilder.kt\nkd/bos/olapServer2/dataEntities/ZipIntArraySerializerBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n37#2,2:137\n*S KotlinDebug\n*F\n+ 1 ZipIntArraySerializerBuilder.kt\nkd/bos/olapServer2/dataEntities/ZipIntArraySerializerBuilder\n*L\n57#1:137,2\n*E\n"})
public final class ZipIntArraySerializerBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ZipIntSerializer> _serializers = new ArrayList();
    private int _offset;

    public final void addFixedMember(@NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        this.addFixedValue(member.getPosition());
    }

    public final void addFixedValue(int fixedValue) {
        if (!(fixedValue >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this._serializers.add(ZipIntSerializer.Companion.createByFix(fixedValue));
    }

    public final void add(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        if (dimension.isSupportSimpleMember()) {
            this.add(Integer.MAX_VALUE);
        } else if (dimension.getMembers().getRealCount() == 1) {
            this.addFixedMember((Member)CollectionsKt.first((Iterable)dimension.getMembers()));
        } else {
            this.add(dimension.getMembers().getNextUnusedPosition());
        }
    }

    public final void add(@NotNull int[] maxValues) {
        Intrinsics.checkNotNullParameter((Object)maxValues, (String)"maxValues");
        for (int maxValue : maxValues) {
            this.add(maxValue);
        }
    }

    public final void add(int maxValue) {
        ZipIntSerializer result2 = this.buildZipIntSerializer(maxValue, this._offset);
        this._serializers.add(result2);
        this._offset += result2.getBitCount();
    }

    @NotNull
    public final ZipIntSerializer[] build() {
        Collection $this$toTypedArray$iv = this._serializers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ZipIntSerializer[0]);
    }

    private final ZipIntSerializer buildZipIntSerializer(int maxValue, int offset) {
        ZipIntSerializer zipIntSerializer;
        int bitCount;
        int twoDataIndex = 0;
        int twoShrCount = 0;
        int firstMark = 0;
        int twoMark = 0;
        if (!(maxValue > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(offset >= 0)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        int n = bitCount = maxValue == 1 ? 0 : Companion.getNeedBitCount(maxValue);
        if (bitCount == 0) {
            return ZipIntSerializer.Companion.createByFix(0);
        }
        int firstDataIndex = offset / 32;
        int firstBitOffset = offset % 32;
        if (32 - firstBitOffset - bitCount < 0) {
            twoDataIndex = firstDataIndex + 1;
            twoShrCount = 32 - firstBitOffset;
            twoMark = ~(-1 << bitCount - twoShrCount);
            zipIntSerializer = ZipIntSerializer.Companion.createByTwo(bitCount, firstDataIndex, firstBitOffset, twoDataIndex, twoShrCount, twoMark);
        } else {
            firstMark = ~(-1 << bitCount);
            zipIntSerializer = ZipIntSerializer.Companion.createByOne(bitCount, firstDataIndex, firstBitOffset, firstMark);
        }
        return zipIntSerializer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bJ\u001d\u0010\r\u001a\u00060\nj\u0002`\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/dataEntities/ZipIntArraySerializerBuilder$Companion;", "", "()V", "createSerializer", "", "Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "(Lkd/bos/olapServer2/metadata/Cube;)[Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;", "getNeedBitCount", "", "Lkd/bos/olapServer2/common/int;", "maxValue", "getZipIntArraySize", "serializers", "([Lkd/bos/olapServer2/dataEntities/ZipIntSerializer;)I", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final int getZipIntArraySize(@NotNull ZipIntSerializer[] serializers) {
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            int result2 = 0;
            for (ZipIntSerializer elem : serializers) {
                result2 += elem.getBitCount();
            }
            return (result2 - 1) / 32 + 1;
        }

        @NotNull
        public final ZipIntSerializer[] createSerializer(@NotNull Cube cube) {
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            ZipIntArraySerializerBuilder builder = new ZipIntArraySerializerBuilder();
            for (Dimension dim : cube.getDimensions()) {
                builder.add(dim);
            }
            return builder.build();
        }

        public final int getNeedBitCount(int maxValue) {
            if (!(maxValue >= 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            int v = maxValue;
            int count = 0;
            while (v != 0) {
                v >>= 1;
                ++count;
            }
            return count;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

