/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.dataSources;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Reader;
import java.math.BigDecimal;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataSources.IntStringParser;
import kd.bos.olapServer2.metadata.OlapDataTypes;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\b\u001a\u001b\u001c\u001d\u001e\u001f !B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016J\u001f\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader;", "", "arrayTypes", "", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "reader", "Ljava/io/Reader;", "clientVersion", "", "Lkd/bos/olapServer2/common/int;", "([Lkd/bos/olapServer2/metadata/OlapDataTypes;Ljava/io/Reader;I)V", "_currentToken", "Lcom/fasterxml/jackson/core/JsonToken;", "[Lkd/bos/olapServer2/metadata/OlapDataTypes;", "converters", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "[Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "moveToFirstElement", "next", "", "Lkd/bos/olapServer2/common/bool;", "read", "values", "([Ljava/lang/Object;)Z", "Companion", "DecimalConverter", "Int32Converter", "Int64Converter", "ObjectConverter", "StringConverterV1", "StringConverterV3", "TypeConverter", "bos-olap-core2"})
public final class ArrayJsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapDataTypes[] arrayTypes;
    @NotNull
    private final JsonParser parser;
    @NotNull
    private final TypeConverter[] converters;
    @Nullable
    private JsonToken _currentToken;
    @NotNull
    private static final BigDecimal MaxDecimal = new BigDecimal(Long.MAX_VALUE);
    @NotNull
    private static final BigDecimal MinDecimal = new BigDecimal(Long.MIN_VALUE);
    private static final int MAX_SCALE = 15;

    public ArrayJsonReader(@NotNull OlapDataTypes[] arrayTypes, @NotNull Reader reader, int clientVersion) {
        Intrinsics.checkNotNullParameter((Object)arrayTypes, (String)"arrayTypes");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.arrayTypes = arrayTypes;
        JsonParser jsonParser = JsonHelper.INSTANCE.getDefaultFactory().createParser(reader);
        Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"createParser(...)");
        this.parser = jsonParser;
        int n = this.arrayTypes.length;
        TypeConverter[] typeConverterArray = new TypeConverter[n];
        ArrayJsonReader arrayJsonReader = this;
        for (int i = 0; i < n; ++i) {
            TypeConverter typeConverter;
            int n2 = i;
            switch (clientVersion) {
                case 1: {
                    typeConverter = TypeConverter.Companion.getConverterV1(this.arrayTypes[n2]);
                    break;
                }
                case 3: {
                    typeConverter = TypeConverter.Companion.getConverter(this.arrayTypes[n2]);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            typeConverterArray[n2] = typeConverter;
        }
        arrayJsonReader.converters = typeConverterArray;
    }

    public /* synthetic */ ArrayJsonReader(OlapDataTypes[] olapDataTypesArray, Reader reader, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        this(olapDataTypesArray, reader, n);
    }

    public final boolean next() {
        JsonToken token;
        this._currentToken = token = this.moveToFirstElement();
        return token != null;
    }

    public final boolean read(@NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!(values.length == this.arrayTypes.length)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JsonToken token = this._currentToken;
        if (token != null) {
            int n = this.arrayTypes.length;
            for (int i = 0; i < n; ++i) {
                if (token == null || !token.isScalarValue()) {
                    String string3 = Res.INSTANCE.getArrayJsonReaderException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ArrayJsonReaderException_1>(...)");
                    Object[] objectArray = new Object[]{this.arrayTypes.length, i};
                    throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                }
                TypeConverter converter = this.converters[i];
                if (token.id() == converter.getTokenId() || converter.isSupportToken(token)) {
                    try {
                        values[i] = converter.convert(this.parser);
                    }
                    catch (Exception ex) {
                        String string4 = Res.INSTANCE.getArrayJsonReaderException_2();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ArrayJsonReaderException_2>(...)");
                        Object[] objectArray = new Object[]{i, converter.getTypeName(), ex.getMessage()};
                        throw Res.INSTANCE.getRuntimeException(string4, ex, objectArray);
                    }
                } else if (token == JsonToken.VALUE_NULL) {
                    values[i] = null;
                } else {
                    String string5 = Res.INSTANCE.getArrayJsonReaderException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-ArrayJsonReaderException_3>(...)");
                    Object[] objectArray = new Object[]{i, converter.getTypeName()};
                    throw Res.INSTANCE.getRuntimeException(string5, objectArray);
                }
                token = this.parser.nextToken();
            }
            if (token == null || token != JsonToken.END_ARRAY) {
                String string6 = Res.INSTANCE.getArrayJsonReaderException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-ArrayJsonReaderException_4>(...)");
                Object[] objectArray = new Object[]{this.arrayTypes.length};
                throw Res.INSTANCE.getRuntimeException(string6, objectArray);
            }
            return true;
        }
        return false;
    }

    private final JsonToken moveToFirstElement() {
        boolean state = false;
        JsonToken token = this.parser.nextToken();
        while (token != null) {
            if (token != JsonToken.START_ARRAY || state) {
                if (token.isScalarValue() && state) {
                    return token;
                }
                String string2 = Res.INSTANCE.getArrayJsonReaderException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ArrayJsonReaderException_5>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
            state = true;
            token = this.parser.nextToken();
        }
        if (state) {
            String string3 = Res.INSTANCE.getArrayJsonReaderException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ArrayJsonReaderException_5>(...)");
            throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$Companion;", "", "()V", "MAX_SCALE", "", "MaxDecimal", "Ljava/math/BigDecimal;", "getMaxDecimal", "()Ljava/math/BigDecimal;", "MinDecimal", "getMinDecimal", "objectConverter", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/core/JsonParser;", "getObjectConverter", "()Lkotlin/jvm/functions/Function1;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigDecimal getMaxDecimal() {
            return MaxDecimal;
        }

        @NotNull
        public final BigDecimal getMinDecimal() {
            return MinDecimal;
        }

        @NotNull
        public final Function1<JsonParser, Object> getObjectConverter() {
            return (Function1)new Function1<JsonParser, Object>((Object)TypeConverter.Companion.getObject$bos_olap_core2()){

                @Nullable
                public final Object invoke(@NotNull JsonParser p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ObjectConverter)this.receiver).convert(p0);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$DecimalConverter;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class DecimalConverter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "decimal";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_FLOAT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser2) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            return Decimal6f.valueOf((String)parser2.getValueAsString(null));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$Int32Converter;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class Int32Converter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "int32";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_INT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT;
        }

        @Override
        @NotNull
        public Object convert(@NotNull JsonParser parser2) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            return parser2.getIntValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$Int64Converter;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class Int64Converter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "int64";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_INT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT;
        }

        @Override
        @NotNull
        public Object convert(@NotNull JsonParser parser2) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            return parser2.getLongValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0014\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$ObjectConverter;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "convertToDecimal", "str", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class ObjectConverter
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "object";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_NUMBER_FLOAT.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING || token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser2) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            JsonToken jsonToken = parser2.getCurrentToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    String string2 = parser2.getValueAsString(null);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValueAsString(...)");
                    object2 = this.convertToDecimal(string2);
                    break;
                }
                case 2: {
                    long value2 = parser2.getLongValue();
                    return (Integer.MIN_VALUE <= value2 ? value2 <= Integer.MAX_VALUE : false) ? (Number)((int)value2) : (Number)value2;
                }
                case 3: {
                    object2 = parser2.getValueAsString();
                    break;
                }
                case 4: 
                case 5: {
                    object2 = parser2.getBooleanValue();
                    break;
                }
                default: {
                    throw new NotSupportedException();
                }
            }
            return object2;
        }

        private final Object convertToDecimal(String str) {
            try {
                int i = str.length() - 1;
                int n = str.length() - 1 - 6;
                if (n <= i) {
                    while (true) {
                        char c;
                        if ((c = str.charAt(i)) == 'E' ? true : c == 'e') {
                            return TypeConverter.Companion.convertToBigDecimal$bos_olap_core2(str);
                        }
                        if (c == '.') {
                            Decimal6f decimal6f = Decimal6f.valueOf((String)str);
                            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
                            return decimal6f;
                        }
                        if (i == n) break;
                        --i;
                    }
                }
                return TypeConverter.Companion.convertToBigDecimal$bos_olap_core2(str);
            }
            catch (NumberFormatException _) {
                return TypeConverter.Companion.convertToBigDecimal$bos_olap_core2(str);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonToken.values().length];
                try {
                    nArray[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonToken.VALUE_STRING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonToken.VALUE_TRUE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonToken.VALUE_FALSE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$StringConverterV1;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class StringConverterV1
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "string";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_STRING.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_STRING;
        }

        @Override
        @Nullable
        public Object convert(@NotNull JsonParser parser2) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            return parser2.getValueAsString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$StringConverterV3;", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "bos-olap-core2"})
    private static final class StringConverterV3
    extends TypeConverter {
        @Override
        @NotNull
        public String getTypeName() {
            return "string";
        }

        @Override
        public int getTokenId() {
            return JsonToken.VALUE_STRING.id();
        }

        @Override
        public boolean isSupportToken(@NotNull JsonToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING;
        }

        @Override
        @NotNull
        public Object convert(@NotNull JsonParser parser2) {
            Object object2;
            JsonToken token;
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            JsonToken jsonToken = token = parser2.getCurrentToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    object2 = parser2.getIntValue();
                    break;
                }
                case 2: {
                    String str = parser2.getValueAsString();
                    Intrinsics.checkNotNull((Object)str);
                    object2 = IntStringParser.INSTANCE.parse(str);
                    break;
                }
                default: {
                    String string2 = Res.INSTANCE.getUnsupportedDataTypeException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-UnsupportedDataTypeException_1>(...)");
                    Object[] objectArray = new Object[]{token.asString()};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
            }
            return object2;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonToken.values().length];
                try {
                    nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0014\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0016\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00060\tj\u0002`\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "", "()V", "TokenId", "", "Lkd/bos/olapServer2/common/int;", "getTokenId", "()I", "TypeName", "", "Lkd/bos/olapServer2/common/string;", "getTypeName", "()Ljava/lang/String;", "convert", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "isSupportToken", "", "Lkd/bos/olapServer2/common/bool;", "token", "Lcom/fasterxml/jackson/core/JsonToken;", "Companion", "bos-olap-core2"})
    private static abstract class TypeConverter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final DecimalConverter Decimal = new DecimalConverter();
        @NotNull
        private static final Int32Converter Int32 = new Int32Converter();
        @NotNull
        private static final ObjectConverter Object = new ObjectConverter();
        @NotNull
        private static final StringConverterV1 StringV1 = new StringConverterV1();
        @NotNull
        private static final StringConverterV3 StringV3 = new StringConverterV3();
        @NotNull
        private static final Int64Converter Int64 = new Int64Converter();

        @NotNull
        public abstract String getTypeName();

        public abstract int getTokenId();

        public abstract boolean isSupportToken(@NotNull JsonToken var1);

        @Nullable
        public abstract Object convert(@NotNull JsonParser var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter$Companion;", "", "()V", "Decimal", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$DecimalConverter;", "Int32", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$Int32Converter;", "Int64", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$Int64Converter;", "Object", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$ObjectConverter;", "getObject$bos_olap_core2", "()Lkd/bos/olapServer2/dataSources/ArrayJsonReader$ObjectConverter;", "StringV1", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$StringConverterV1;", "StringV3", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$StringConverterV3;", "convertToBigDecimal", "Ljava/math/BigDecimal;", "str", "", "Lkd/bos/olapServer2/common/string;", "convertToBigDecimal$bos_olap_core2", "getConverter", "Lkd/bos/olapServer2/dataSources/ArrayJsonReader$TypeConverter;", "type", "Lkd/bos/olapServer2/metadata/OlapDataTypes;", "getConverterV1", "bos-olap-core2"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TypeConverter getConverter(@NotNull OlapDataTypes type) {
                TypeConverter typeConverter;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        typeConverter = this.getObject$bos_olap_core2();
                        break;
                    }
                    case 2: {
                        typeConverter = Decimal;
                        break;
                    }
                    case 3: {
                        typeConverter = Int32;
                        break;
                    }
                    case 4: {
                        typeConverter = StringV3;
                        break;
                    }
                    case 5: {
                        typeConverter = Int64;
                        break;
                    }
                    default: {
                        throw new NotSupportedException();
                    }
                }
                return typeConverter;
            }

            @NotNull
            public final TypeConverter getConverterV1(@NotNull OlapDataTypes type) {
                TypeConverter typeConverter;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        typeConverter = this.getObject$bos_olap_core2();
                        break;
                    }
                    case 2: {
                        typeConverter = Decimal;
                        break;
                    }
                    case 3: {
                        typeConverter = Int32;
                        break;
                    }
                    case 4: {
                        typeConverter = StringV1;
                        break;
                    }
                    case 5: {
                        typeConverter = Int64;
                        break;
                    }
                    default: {
                        throw new NotSupportedException();
                    }
                }
                return typeConverter;
            }

            @NotNull
            public final ObjectConverter getObject$bos_olap_core2() {
                return Object;
            }

            @NotNull
            public final BigDecimal convertToBigDecimal$bos_olap_core2(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                BigDecimal value2 = new BigDecimal(str);
                if (!DragonEngine.Companion.isInScope(value2)) {
                    String string2 = Res.INSTANCE.getArrayJsonReaderException_8();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ArrayJsonReaderException_8>(...)");
                    Object[] objectArray = new Object[]{ArrayJsonReader.Companion.getMinDecimal(), ArrayJsonReader.Companion.getMaxDecimal(), this};
                    throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
                }
                BigDecimal bigDecimal = DragonEngine.Companion.tryInScale(value2);
                if (bigDecimal == null) {
                    String string3 = Res.INSTANCE.getArrayJsonReaderException_9();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ArrayJsonReaderException_9>(...)");
                    Object[] objectArray = new Object[]{15, this};
                    throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
                }
                return bigDecimal;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[OlapDataTypes.values().length];
                    try {
                        nArray[OlapDataTypes.object.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OlapDataTypes.decimal.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OlapDataTypes.int32.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OlapDataTypes.string.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OlapDataTypes.int64.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

