/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.function;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.common.PropertyBag;
import kd.bos.olapServer2.function.FunctionInfo;
import kd.bos.olapServer2.function.IFunctionExecutor;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.CubeDataScopeBuilder;
import kd.bos.olapServer2.metadata.builds.DimensionFilterPropertiesJsonSerializer;
import kd.bos.olapServer2.metadata.builds.DiscretePointPropertiesJsonSerializer;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.MembersJsonProxy;
import kd.bos.olapServer2.metadata.builds.PointsJsonProxy;
import kd.bos.olapServer2.metadata.builds.SliceScopeV2PropertiesJsonSerializer;
import kd.bos.olapServer2.metadata.builds.XDimensionFilterJsonProxy;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/function/CubeDataScopeFunctionExecutor;", "Lkd/bos/olapServer2/function/IFunctionExecutor;", "()V", "description", "", "Lkd/bos/olapServer2/common/string;", "getDescription", "()Ljava/lang/String;", "name", "getName", "execute", "Lkd/bos/olapServer2/common/ImmutablePropertyBag;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "parameters", "getFunctionInfo", "Lkd/bos/olapServer2/function/FunctionInfo;", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeDataScopeFunctionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeDataScopeFunctionExecutor.kt\nkd/bos/olapServer2/function/CubeDataScopeFunctionExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n*S KotlinDebug\n*F\n+ 1 CubeDataScopeFunctionExecutor.kt\nkd/bos/olapServer2/function/CubeDataScopeFunctionExecutor\n*L\n51#1:77\n51#1:78,2\n*E\n"})
public final class CubeDataScopeFunctionExecutor
implements IFunctionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String scope_name = "name";

    @Override
    @NotNull
    public String getName() {
        return "getCubeDataScopes";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string2 = Res.INSTANCE.getCubeDataScopeFunctionExecutorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeDataScopeFuncti\u2026ExecutorDescription>(...)");
        return string2;
    }

    @Override
    @NotNull
    public FunctionInfo getFunctionInfo() {
        FunctionInfo functionInfo = new FunctionInfo(this.getName(), this.getDescription(), false, false, null, null, 60, null);
        String string2 = Res.INSTANCE.getCubeDataScopeParam_1();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeDataScopeParam_1>(...)");
        return functionInfo.addParameter(new FunctionInfo.ParameterItem(scope_name, string2, "string", false, false)).addResult(new FunctionInfo.ResultItem("result", null, "json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImmutablePropertyBag execute(@NotNull OlapWorkspace olapWorkspace, @Nullable CubeWorkspace cubeWorkspace, @NotNull ImmutablePropertyBag parameters2) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        PropertyBag propertyBag = new PropertyBag(null, 1, null);
        if (cubeWorkspace == null) {
            String string2 = Res.INSTANCE.getCubeWorkspaceNullException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeWorkspaceNullException_1>(...)");
            throw Res.INSTANCE.getNullPointerException(string2, new Object[0]);
        }
        ObjectMapper mapper = Companion.createMapper(cubeWorkspace.getMetadata());
        Closeable closeable = cubeWorkspace.getMetadataStorage().createWriterContext();
        Throwable throwable = null;
        try {
            Collection collection;
            IMetadataWriterContext it = (IMetadataWriterContext)closeable;
            boolean bl = false;
            CubeBuilder builder = it.getCubeBuilder();
            String name2 = (String)parameters2.get((Object)scope_name);
            if (((CharSequence)name2).length() > 0) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = builder.getCubeDataScopes();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    CubeDataScopeBuilder scope = (CubeDataScopeBuilder)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)scope.getName(), (Object)name2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = builder.getCubeDataScopes();
            }
            Collection result2 = collection;
            String string3 = mapper.writeValueAsString((Object)result2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
            propertyBag.set("result", string3);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return propertyBag;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/function/CubeDataScopeFunctionExecutor$Companion;", "", "()V", "scope_name", "", "createMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper createMapper(@NotNull Cube cube) {
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(PointsJsonProxy.class, (JsonSerializer)new DiscretePointPropertiesJsonSerializer(cube));
            simpleModule.addSerializer(XDimensionFilterJsonProxy.class, (JsonSerializer)new DimensionFilterPropertiesJsonSerializer(cube));
            simpleModule.addSerializer(MembersJsonProxy.class, (JsonSerializer)new SliceScopeV2PropertiesJsonSerializer(cube));
            mapper.registerModule((Module)simpleModule);
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

