/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.function;

import java.util.ArrayList;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.common.PropertyBag;
import kd.bos.olapServer2.function.FunctionInfo;
import kd.bos.olapServer2.function.IFunctionExecutor;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItemCollection;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IPartitionCubeWorkspaceCollection;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.IDSCacheCredibleSnapshot;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor;", "Lkd/bos/olapServer2/function/IFunctionExecutor;", "()V", "description", "", "Lkd/bos/olapServer2/common/string;", "getDescription", "()Ljava/lang/String;", "name", "getName", "execute", "Lkd/bos/olapServer2/common/ImmutablePropertyBag;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "parameters", "getCredibilityInfo", "Lkd/bos/olapServer2/common/PropertyBag;", "getFunctionInfo", "Lkd/bos/olapServer2/function/FunctionInfo;", "BaseAndCachePartitionPair", "Companion", "PartitionInfo", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDSCacheInfoFunctionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSCacheInfoFunctionExecutor.kt\nkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 DSCacheInfoFunctionExecutor.kt\nkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor\n*L\n64#1:99,2\n67#1:101,2\n*E\n"})
public final class DSCacheInfoFunctionExecutor
implements IFunctionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String notCrediblePartition = "not_credible_partition";
    @NotNull
    private static final String crediblePartition = "credible_partition";
    @NotNull
    private static final String totalBaseRowCount = "total_Base_rowCount";
    @NotNull
    private static final String totalDSCacheRowCount = "total_DSCache_rowCount";
    @NotNull
    private static final String cacheProportion = "cache_proportion";

    @Override
    @NotNull
    public String getName() {
        return "getDSCacheInfo";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string2 = Res.INSTANCE.getDSCacheInfoFunctionExecutorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-DSCacheInfoFunctionExecutorDescription>(...)");
        return string2;
    }

    @Override
    @NotNull
    public ImmutablePropertyBag execute(@NotNull OlapWorkspace olapWorkspace, @Nullable CubeWorkspace cubeWorkspace, @NotNull ImmutablePropertyBag parameters2) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        if (cubeWorkspace == null) {
            String string2 = Res.INSTANCE.getCubeWorkspaceNullException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeWorkspaceNullException_1>(...)");
            throw Res.INSTANCE.getNullPointerException(string2, new Object[0]);
        }
        return this.getCredibilityInfo(cubeWorkspace);
    }

    private final PropertyBag getCredibilityInfo(CubeWorkspace cubeWorkspace) {
        Cube cube = cubeWorkspace.getMetadata();
        IPartitionItemCollection partitionItems = cube.getPartitionItems();
        IPartitionCubeWorkspaceCollection<AbstractCubeWorkspace> partitionCubeWorkspace = cubeWorkspace.getPartitionWorkspaces();
        Ref.LongRef baseRowCount = new Ref.LongRef();
        Ref.LongRef dSCacheRowCount = new Ref.LongRef();
        PropertyBag propertyBag = new PropertyBag(null, 1, null);
        IDSCacheCredibleSnapshot snapshot = cubeWorkspace.getDSCacheCredibleSnapshot();
        ArrayList<BaseAndCachePartitionPair> crediblePairs = new ArrayList<BaseAndCachePartitionPair>();
        ArrayList<BaseAndCachePartitionPair> notCrediblePairs = new ArrayList<BaseAndCachePartitionPair>();
        Iterable $this$forEach$iv = snapshot.getCrediblePartitionPairs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int a = ((Number)pair.component1()).intValue();
            crediblePairs.add(DSCacheInfoFunctionExecutor.getCredibilityInfo$getBaseAndCachePartitionPair(partitionCubeWorkspace, partitionItems, baseRowCount, cube, dSCacheRowCount, a));
        }
        $this$forEach$iv = snapshot.getNotCrediblePartitions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int a = ((Number)element$iv).intValue();
            boolean bl = false;
            notCrediblePairs.add(DSCacheInfoFunctionExecutor.getCredibilityInfo$getBaseAndCachePartitionPair(partitionCubeWorkspace, partitionItems, baseRowCount, cube, dSCacheRowCount, a));
        }
        String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString(notCrediblePairs);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        propertyBag.set(notCrediblePartition, string2);
        String string3 = JsonHelper.INSTANCE.getMapper().writeValueAsString(crediblePairs);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
        propertyBag.set(crediblePartition, string3);
        propertyBag.set(totalBaseRowCount, String.valueOf(baseRowCount.element));
        propertyBag.set(totalDSCacheRowCount, String.valueOf(dSCacheRowCount.element));
        propertyBag.set(cacheProportion, String.valueOf((double)dSCacheRowCount.element * 1.0 / (double)baseRowCount.element));
        return propertyBag;
    }

    @Override
    @NotNull
    public FunctionInfo getFunctionInfo() {
        return new FunctionInfo(this.getName(), this.getDescription(), false, false, null, null, 60, null).addResult(new FunctionInfo.ResultItem(notCrediblePartition, Res.INSTANCE.getDSCacheInfoFunctionExecutorResult_1(), "json")).addResult(new FunctionInfo.ResultItem(crediblePartition, Res.INSTANCE.getDSCacheInfoFunctionExecutorResult_2(), "json")).addResult(new FunctionInfo.ResultItem(totalBaseRowCount, Res.INSTANCE.getDSCacheInfoFunctionExecutorResult_3(), "string")).addResult(new FunctionInfo.ResultItem(totalDSCacheRowCount, Res.INSTANCE.getDSCacheInfoFunctionExecutorResult_4(), "string")).addResult(new FunctionInfo.ResultItem(cacheProportion, Res.INSTANCE.getDSCacheInfoFunctionExecutorResult_5(), "string"));
    }

    private static final BaseAndCachePartitionPair getCredibilityInfo$getBaseAndCachePartitionPair(IPartitionCubeWorkspaceCollection<? extends AbstractCubeWorkspace> partitionCubeWorkspace, IPartitionItemCollection partitionItems, Ref.LongRef baseRowCount, Cube cube, Ref.LongRef dSCacheRowCount, int baseId) {
        PartitionInfo partitionInfo;
        PartitionInfo partitionInfo2;
        AbstractCubeWorkspace baseCubeWorkspace = partitionCubeWorkspace.tryGet(baseId);
        if (baseCubeWorkspace == null) {
            partitionInfo2 = new PartitionInfo(partitionItems.get(baseId).getKey(), 0L, 0L);
        } else {
            long rowCount = baseCubeWorkspace.getRowCount();
            baseRowCount.element += rowCount;
            partitionInfo2 = new PartitionInfo(partitionItems.get(baseId).getKey(), baseCubeWorkspace.getResourcePool().getDsVersion(), rowCount);
        }
        PartitionInfo baseInfo = partitionInfo2;
        IPartitionItem cachePartitionItem = cube.getDSCachePartition(partitionItems.get(baseId));
        if (Intrinsics.areEqual((Object)cachePartitionItem, (Object)EmptyPartitionItem.INSTANCE)) {
            partitionInfo = new PartitionInfo("no cache", -1L, -1L);
        } else {
            AbstractCubeWorkspace cacheCubeWorkspace = partitionCubeWorkspace.tryGet(cachePartitionItem.getId());
            if (cacheCubeWorkspace == null) {
                partitionInfo = new PartitionInfo(partitionItems.get(cachePartitionItem.getId()).getKey(), 0L, 0L);
            } else {
                long rowCount = cacheCubeWorkspace.getRowCount();
                dSCacheRowCount.element += rowCount;
                partitionInfo = new PartitionInfo(partitionItems.get(cachePartitionItem.getId()).getKey(), cacheCubeWorkspace.getResourcePool().getDsVersion(), rowCount);
            }
        }
        PartitionInfo cacheInfo = partitionInfo;
        return new BaseAndCachePartitionPair(baseInfo, cacheInfo);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$BaseAndCachePartitionPair;", "", "base", "Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$PartitionInfo;", "dsCache", "(Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$PartitionInfo;Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$PartitionInfo;)V", "getBase", "()Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$PartitionInfo;", "getDsCache", "bos-olap-core2"})
    private static final class BaseAndCachePartitionPair {
        @NotNull
        private final PartitionInfo base;
        @NotNull
        private final PartitionInfo dsCache;

        public BaseAndCachePartitionPair(@NotNull PartitionInfo base, @NotNull PartitionInfo dsCache) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)dsCache, (String)"dsCache");
            this.base = base;
            this.dsCache = dsCache;
        }

        @NotNull
        public final PartitionInfo getBase() {
            return this.base;
        }

        @NotNull
        public final PartitionInfo getDsCache() {
            return this.dsCache;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$Companion;", "", "()V", "cacheProportion", "", "crediblePartition", "notCrediblePartition", "totalBaseRowCount", "totalDSCacheRowCount", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\tR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/function/DSCacheInfoFunctionExecutor$PartitionInfo;", "", "key", "", "Lkd/bos/olapServer2/common/string;", "dsVersion", "", "Lkd/bos/olapServer2/common/long;", "rowCount", "(Ljava/lang/String;JJ)V", "getDsVersion", "()J", "getKey", "()Ljava/lang/String;", "getRowCount", "bos-olap-core2"})
    private static final class PartitionInfo {
        @NotNull
        private final String key;
        private final long dsVersion;
        private final long rowCount;

        public PartitionInfo(@NotNull String key2, long dsVersion, long rowCount) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            this.key = key2;
            this.dsVersion = dsVersion;
            this.rowCount = rowCount;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final long getDsVersion() {
            return this.dsVersion;
        }

        public final long getRowCount() {
            return this.rowCount;
        }
    }
}

