/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles;

import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.DynamicSizeRange;
import kd.bos.olapServer2.dataEntities.DynamicSizeRangeCollection;
import kd.bos.olapServer2.memoryMappedFiles.IDynamicIntMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\u0013j\u0002`\u00142\n\u0010&\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010'\u001a\u00020(H\u0016J0\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\b2\n\u0010+\u001a\u00060\u0013j\u0002`,2\n\u0010-\u001a\u00060.j\u0002`/2\u0006\u0010'\u001a\u00020(H\u0002J0\u00100\u001a\u00020$2\u0006\u0010*\u001a\u00020\b2\n\u0010+\u001a\u00060\u0013j\u0002`,2\n\u0010-\u001a\u00060.j\u0002`/2\u0006\u0010'\u001a\u00020(H\u0002J0\u00101\u001a\u00020$2\u0006\u0010*\u001a\u00020\b2\n\u0010+\u001a\u00060\u0013j\u0002`,2\n\u0010-\u001a\u00060.j\u0002`/2\u0006\u0010'\u001a\u00020(H\u0002J0\u00102\u001a\u00020$2\u0006\u0010*\u001a\u00020\b2\n\u0010+\u001a\u00060\u0013j\u0002`,2\n\u0010-\u001a\u00060.j\u0002`/2\u0006\u0010'\u001a\u00020(H\u0002J(\u00103\u001a\u00020$2\n\u0010%\u001a\u00060\u0013j\u0002`\u00142\n\u0010&\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010'\u001a\u00020(H\u0002J\u0019\u00104\u001a\u00060.j\u0002`/2\n\u00105\u001a\u00060\u0013j\u0002`\u0014H\u0096\u0002J \u00106\u001a\u00060.j\u0002`/2\u0006\u00107\u001a\u0002082\n\u00105\u001a\u00060\u0013j\u0002`\u0014H\u0002J \u00109\u001a\u00060.j\u0002`/2\u0006\u00107\u001a\u0002082\n\u00105\u001a\u00060\u0013j\u0002`\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/ImmutableListDynamicInt;", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/IDynamicIntMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/IDynamicIntMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_batchGetCache", "", "_buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "get_buffer", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "set_buffer", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;)V", "_bytes", "get_bytes", "()[B", "_count", "", "Lkd/bos/olapServer2/common/rowIdx;", "get_count", "()J", "set_count", "(J)V", "count", "getCount", "getMetadata", "()Lkd/bos/olapServer2/memoryMappedFiles/IDynamicIntMetadata;", "ranges", "Lkd/bos/olapServer2/dataEntities/DynamicSizeRangeCollection;", "getRanges", "()Lkd/bos/olapServer2/dataEntities/DynamicSizeRangeCollection;", "getRes", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "batchGet", "", "start", "end", "result", "", "batchGet1Byte", "bytes", "position", "Lkd/bos/olapServer2/common/long;", "size", "", "Lkd/bos/olapServer2/common/int;", "batchGet2Byte", "batchGet3Byte", "batchGet4Byte", "batchGetOther", "get", "index", "get3Byte", "range", "Lkd/bos/olapServer2/dataEntities/DynamicSizeRange;", "get4Byte", "bos-olap-core2"})
public class ImmutableListDynamicInt
implements IImmutableListInt {
    @NotNull
    private final IDynamicIntMetadata metadata;
    @NotNull
    private final IDynamicByteBufferResource res;
    @NotNull
    private IByteBuffer _buffer;
    @NotNull
    private final DynamicSizeRangeCollection ranges;
    private long _count;
    @NotNull
    private final byte[] _bytes;
    @NotNull
    private final byte[] _batchGetCache;

    public ImmutableListDynamicInt(@NotNull IDynamicIntMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.metadata = metadata;
        this.res = res;
        this.ranges = new DynamicSizeRangeCollection();
        this._count = this.metadata.getCount();
        this._bytes = new byte[4];
        if (this._count > 0L) {
            this.ranges.build(this.metadata.getTwoByteStart(), this.metadata.getThreeByteStart(), this.metadata.getFourByteStart());
        }
        this._buffer = this.res.getContentBuffer();
        this._batchGetCache = new byte[256];
    }

    @NotNull
    protected final IDynamicIntMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    protected final IDynamicByteBufferResource getRes() {
        return this.res;
    }

    @NotNull
    protected final IByteBuffer get_buffer() {
        return this._buffer;
    }

    protected final void set_buffer(@NotNull IByteBuffer iByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)iByteBuffer, (String)"<set-?>");
        this._buffer = iByteBuffer;
    }

    @NotNull
    protected final DynamicSizeRangeCollection getRanges() {
        return this.ranges;
    }

    protected final long get_count() {
        return this._count;
    }

    protected final void set_count(long l) {
        this._count = l;
    }

    @NotNull
    protected final byte[] get_bytes() {
        return this._bytes;
    }

    @Override
    public int get(long index2) {
        int n;
        if (!(0L <= index2 ? index2 < this._count : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object range = this.ranges.getRange(index2);
        switch (((DynamicSizeRange)range).getElementByteSize()) {
            case 1: {
                n = CommonTypesKt.toIntNoNegative(this._buffer.getByte(((DynamicSizeRange)range).getElementPosition(index2)));
                break;
            }
            case 2: {
                n = CommonTypesKt.toIntNoNegative(this._buffer.getShort(((DynamicSizeRange)range).getElementPosition(index2)));
                break;
            }
            case 3: {
                n = this.get3Byte((DynamicSizeRange)range, index2);
                break;
            }
            case 4: {
                n = this._buffer.getInt(((DynamicSizeRange)range).getElementPosition(index2));
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
            }
        }
        return n;
    }

    private final int get4Byte(DynamicSizeRange range, long index2) {
        byte[] bytes2 = this._bytes;
        this._buffer.getByteArray(range.getElementPosition(index2), bytes2, 0, range.getElementByteSize());
        return (bytes2[3] & 0xFF) << 24 | (bytes2[2] & 0xFF) << 16 | (bytes2[1] & 0xFF) << 8 | bytes2[0] & 0xFF;
    }

    private final int get3Byte(DynamicSizeRange range, long index2) {
        byte[] bytes2 = this._bytes;
        this._buffer.getByteArray(range.getElementPosition(index2), bytes2, 0, range.getElementByteSize());
        return bytes2[0] & 0xFF | (bytes2[1] & 0xFF) << 8 | (bytes2[2] & 0xFF) << 16;
    }

    @Override
    public void batchGet(long start, long end, @NotNull int[] result2) {
        block8: {
            block7: {
                Object rangeEnd;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (!((0L <= start ? start <= end : false) && end < this._count)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Object rangeStart = this.ranges.getRange(start);
                if (rangeStart != (rangeEnd = this.ranges.getRange(end))) break block7;
                long position = ((DynamicSizeRange)rangeStart).getElementPosition(start);
                int size = CommonTypesKt.toIntNoNegative(end - start + 1L);
                switch (((DynamicSizeRange)rangeStart).getElementByteSize()) {
                    case 1: {
                        this.batchGet1Byte(this._batchGetCache, position, size, result2);
                        break block8;
                    }
                    case 2: {
                        this.batchGet2Byte(this._batchGetCache, position, size, result2);
                        break block8;
                    }
                    case 3: {
                        this.batchGet3Byte(this._batchGetCache, position, size, result2);
                        break block8;
                    }
                    case 4: {
                        this.batchGet4Byte(this._batchGetCache, position, size, result2);
                        break block8;
                    }
                    default: {
                        String string3 = Res.INSTANCE.getCommonException_4();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_4>(...)");
                        throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
                    }
                }
            }
            this.batchGetOther(start, end, result2);
        }
    }

    private final void batchGet1Byte(byte[] bytes2, long position, int size, int[] result2) {
        this._buffer.getByteArray(position, bytes2, 0, size);
        for (int i = 0; i < size; ++i) {
            result2[i] = bytes2[i] & 0xFF;
        }
    }

    private final void batchGet2Byte(byte[] bytes2, long position, int size, int[] result2) {
        this._buffer.getByteArray(position, bytes2, 0, size * 2);
        int byteIndex = 0;
        for (int i = 0; i < size; ++i) {
            result2[i] = (bytes2[byteIndex + 1] & 0xFF) << 8 | bytes2[byteIndex] & 0xFF;
            byteIndex += 2;
        }
    }

    private final void batchGet3Byte(byte[] bytes2, long position, int size, int[] result2) {
        this._buffer.getByteArray(position, bytes2, 0, size * 3);
        int byteIndex = 0;
        for (int i = 0; i < size; ++i) {
            result2[i] = (bytes2[byteIndex + 2] & 0xFF) << 16 | (bytes2[byteIndex + 1] & 0xFF) << 8 | bytes2[byteIndex] & 0xFF;
            byteIndex += 3;
        }
    }

    private final void batchGet4Byte(byte[] bytes2, long position, int size, int[] result2) {
        this._buffer.getByteArray(position, bytes2, 0, size * 4);
        int byteIndex = 0;
        for (int i = 0; i < size; ++i) {
            result2[i] = (bytes2[byteIndex + 3] & 0xFF) << 24 | (bytes2[byteIndex + 2] & 0xFF) << 16 | (bytes2[byteIndex + 1] & 0xFF) << 8 | bytes2[byteIndex] & 0xFF;
            byteIndex += 4;
        }
    }

    private final void batchGetOther(long start, long end, int[] result2) {
        int index2 = 0;
        long i = start;
        if (i <= end) {
            while (true) {
                result2[index2++] = this.get(i);
                if (i == end) break;
                ++i;
            }
        }
    }

    @Override
    public long getCount() {
        return this._count;
    }
}

