/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.collections.IConverter;
import kd.bos.olapServer2.collections.ILongConverter;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.memoryMappedFiles.LongConverterSimd;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0002H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0016\u0010\u001b\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\u00020\u001cJ\u0012\u0010\u001d\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010\u001d\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0014\u0010 \u001a\u00020\u00022\n\u0010!\u001a\u00060\u000bj\u0002`\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/LongConverter;", "Lkd/bos/olapServer2/collections/ILongConverter;", "", "dimensionInfo", "", "([[I)V", "_fixedMembers", "_mappings", "Lkd/bos/olapServer2/memoryMappedFiles/LongConverter$MemberMap;", "[Lkd/bos/olapServer2/memoryMappedFiles/LongConverter$MemberMap;", "max", "", "Lkd/bos/olapServer2/common/long;", "getMax", "()J", "maxValue", "Ljava/math/BigInteger;", "getMaxValue", "()Ljava/math/BigInteger;", "batchToX", "", "rows", "result", "", "([[I[J)V", "createDimensionKeys", "createSimdVersion", "toObjectConverter", "Lkd/bos/olapServer2/collections/IConverter;", "toX", "y", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "toY", "x", "MemberMap", "ObjectConverter", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nLongConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongConverter.kt\nkd/bos/olapServer2/memoryMappedFiles/LongConverter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,186:1\n37#2,2:187\n*S KotlinDebug\n*F\n+ 1 LongConverter.kt\nkd/bos/olapServer2/memoryMappedFiles/LongConverter\n*L\n52#1:187,2\n*E\n"})
public final class LongConverter
implements ILongConverter<int[]> {
    @NotNull
    private final int[] _fixedMembers;
    @NotNull
    private final MemberMap[] _mappings;

    public LongConverter(@NotNull int[][] dimensionInfo) {
        Intrinsics.checkNotNullParameter((Object)dimensionInfo, (String)"dimensionInfo");
        this._fixedMembers = new int[((Object[])dimensionInfo).length];
        List list2 = new ArrayList();
        long carry = 1L;
        int n = ((Object[])dimensionInfo).length;
        block4: for (int i = 0; i < n; ++i) {
            int i2 = i;
            int[] dim = dimensionInfo[i];
            switch (dim.length) {
                case 0: {
                    throw new NotSupportedException();
                }
                case 1: {
                    this._fixedMembers[i2] = ArraysKt.first((int[])dim);
                    continue block4;
                }
                default: {
                    MemberMap map2 = new MemberMap(i2, dim, carry);
                    if (map2.getStep() == 1) {
                        this._fixedMembers[i2] = map2.getMinValue();
                        continue block4;
                    }
                    carry *= (long)map2.getStep();
                    list2.add(map2);
                }
            }
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this._mappings = thisCollection$iv.toArray(new MemberMap[0]);
    }

    @NotNull
    public final IConverter<Long, int[]> toObjectConverter() {
        return new ObjectConverter(this);
    }

    @NotNull
    public final BigInteger getMaxValue() {
        BigInteger carry = BigInteger.ONE;
        for (MemberMap mapping : this._mappings) {
            BigInteger bigInteger = carry;
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = BigInteger.valueOf(mapping.getStep());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger.multiply(bigInteger2), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = carry;
        Intrinsics.checkNotNull((Object)bigInteger);
        return bigInteger;
    }

    private final int[] createDimensionKeys() {
        int[] nArray = Arrays.copyOf(this._fixedMembers, this._fixedMembers.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        return nArray;
    }

    @Override
    public long getMax() {
        return this.getMaxValue().longValueExact();
    }

    @Override
    public long toX(@NotNull int[] y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        long result2 = 0L;
        for (MemberMap mapping : this._mappings) {
            result2 += mapping.toX(y);
        }
        return result2;
    }

    @Override
    public final long toX(@NotNull IDimensionKeys y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        long result2 = 0L;
        MemberMap[] memberMapArray = this._mappings;
        int n = memberMapArray.length;
        for (int i = 0; i < n; ++i) {
            MemberMap mapping;
            MemberMap $this$toX_u24lambda_u240 = mapping = memberMapArray[i];
            boolean bl = false;
            result2 += $this$toX_u24lambda_u240.getCarry() * (long)(y.get($this$toX_u24lambda_u240.getDimensionPosition()) - $this$toX_u24lambda_u240.getMinValue());
        }
        return result2;
    }

    public final void batchToX(@NotNull int[][] rows, @NotNull long[] result2) {
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        ArraysKt.fill$default((long[])result2, (long)0L, (int)0, (int)0, (int)6, null);
        for (MemberMap mapping : this._mappings) {
            int[] values = rows[mapping.getDimensionPosition()];
            long minValue = mapping.getMinValue();
            long carry = mapping.getCarry();
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                result2[n2] = result2[n2] + ((long)values[i] - minValue) * carry;
            }
        }
    }

    @Override
    @NotNull
    public int[] toY(long x) {
        long pre = 0L;
        long carry = 0L;
        int[] data = this.createDimensionKeys();
        MemberMap[] m = this._mappings;
        if (!(m.length == 0)) {
            MemberMap mapping = m[m.length - 1];
            int value2 = 0;
            pre = mapping.getCarry();
            value2 = (int)(x / pre);
            data[mapping.getDimensionPosition()] = value2 + mapping.getMinValue();
            for (int i = m.length - 2; -1 < i; --i) {
                mapping = m[i];
                carry = mapping.getCarry();
                value2 = (int)(x % pre / carry);
                data[mapping.getDimensionPosition()] = value2 + mapping.getMinValue();
                pre = carry;
            }
        }
        return data;
    }

    @NotNull
    public final ILongConverter<int[]> createSimdVersion() {
        return LongConverterSimd.INSTANCE.create(this._mappings, this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0015\u0010\u0013\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/LongConverter$MemberMap;", "", "dimensionPosition", "", "Lkd/bos/olapServer2/common/int;", "members", "", "carry", "", "Lkd/bos/olapServer2/common/long;", "(I[IJ)V", "getCarry", "()J", "getDimensionPosition", "()I", "maxValue", "getMaxValue", "minValue", "getMinValue", "step", "getStep", "toString", "", "toX", "y", "bos-olap-core2"})
    public static final class MemberMap {
        private final int dimensionPosition;
        private final long carry;
        private final int minValue;
        private final int maxValue;

        public MemberMap(int dimensionPosition, @NotNull int[] members2, long carry) {
            Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
            this.dimensionPosition = dimensionPosition;
            this.carry = carry;
            Integer n = ArraysKt.minOrNull((int[])members2);
            this.minValue = n != null ? n : 0;
            Integer n2 = ArraysKt.maxOrNull((int[])members2);
            this.maxValue = n2 != null ? n2 : 0;
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        public final long getCarry() {
            return this.carry;
        }

        public final int getMinValue() {
            return this.minValue;
        }

        public final int getMaxValue() {
            return this.maxValue;
        }

        public final int getStep() {
            return this.maxValue - this.minValue + 1;
        }

        public final long toX(@NotNull int[] y) {
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            return this.carry * (long)(y[this.dimensionPosition] - this.minValue);
        }

        @NotNull
        public String toString() {
            return "{pos:" + this.dimensionPosition + ", min:" + this.minValue + ", max:" + this.maxValue + ", step:" + this.getStep() + ", carry:" + this.carry + '}';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u0012\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\b\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u00060\u0002j\u0002`\u0003H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/LongConverter$ObjectConverter;", "Lkd/bos/olapServer2/collections/IConverter;", "", "Lkd/bos/olapServer2/common/long;", "", "owner", "Lkd/bos/olapServer2/collections/ILongConverter;", "(Lkd/bos/olapServer2/collections/ILongConverter;)V", "toX", "y", "([I)Ljava/lang/Long;", "toY", "x", "bos-olap-core2"})
    private static final class ObjectConverter
    implements IConverter<Long, int[]> {
        @NotNull
        private final ILongConverter<int[]> owner;

        public ObjectConverter(@NotNull ILongConverter<int[]> owner) {
            Intrinsics.checkNotNullParameter(owner, (String)"owner");
            this.owner = owner;
        }

        @Override
        @NotNull
        public Long toX(@NotNull int[] y) {
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            return this.owner.toX(y);
        }

        @Override
        @NotNull
        public int[] toY(long x) {
            return this.owner.toY(x);
        }
    }
}

