/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableArrayInt;
import kd.bos.olapServer2.memoryMappedFiles.IArrayMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.containers.DefaultResizeStrategy;
import kd.bos.olapServer2.memoryMappedFiles.containers.ResizeStrategy;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0019\u0010\u001c\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u001d\u001a\u00060\u000bj\u0002`\fH\u0096\u0002J\u0014\u0010\u001e\u001a\u00020\u00172\n\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0016J!\u0010 \u001a\u00020\u00172\n\u0010\u001d\u001a\u00060\u000bj\u0002`\f2\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/MutableArrayInt;", "Lkd/bos/olapServer2/collections/IMutableArrayInt;", "Ljava/io/Flushable;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/IArrayMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/IArrayMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_dirty", "", "_length", "", "Lkd/bos/olapServer2/common/rowIdx;", "entriesBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "length", "getLength", "()J", "resizeStrategy", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ResizeStrategy;", "getResizeStrategy", "()Lkd/bos/olapServer2/memoryMappedFiles/containers/ResizeStrategy;", "fill", "", "value", "", "Lkd/bos/olapServer2/common/int;", "flush", "get", "index", "resize", "newSize", "set", "Companion", "bos-olap-core2"})
public final class MutableArrayInt
implements IMutableArrayInt,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IArrayMetadata metadata;
    @NotNull
    private final IDynamicByteBufferResource res;
    @NotNull
    private IByteBuffer entriesBuffer;
    private long _length;
    private boolean _dirty;
    private static final long entryBytes = 4L;

    public MutableArrayInt(@NotNull IArrayMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.metadata = metadata;
        this.res = res;
        this._length = this.metadata.getLength();
        this.entriesBuffer = this.res.getContentBuffer();
    }

    @Override
    public int get(long index2) {
        if (!(0L <= index2 ? index2 < this._length : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.entriesBuffer.getInt(index2 * 4L);
    }

    @Override
    public void set(long index2, int value2) {
        if (!(0L <= index2 ? index2 < this._length : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.entriesBuffer.putInt(index2 * 4L, value2);
        this._dirty = true;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    private final ResizeStrategy getResizeStrategy() {
        return DefaultResizeStrategy.INSTANCE;
    }

    @Override
    public void resize(long newSize) {
        if (newSize > this._length) {
            long newBytesSize = this.getResizeStrategy().getNextCapacity(0L, newSize * 4L);
            if (newBytesSize < 0L) {
                String string2 = Res.INSTANCE.getCommonException_11();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_11>(...)");
                Object[] objectArray = new Object[]{newSize * 4L};
                throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
            }
            if (this.entriesBuffer.getCapacity() < newBytesSize) {
                this.entriesBuffer = this.res.resize(newBytesSize);
            }
            this._length = newSize;
            this._dirty = true;
        }
    }

    @Override
    public void fill(int value2) {
        switch (value2) {
            case 0: {
                this.entriesBuffer.clearData();
                break;
            }
            case -1: {
                this.entriesBuffer.fill(0L, this._length * 4L, (byte)-1);
                break;
            }
            default: {
                IByteBuffer buffer = this.entriesBuffer;
                long l = this._length;
                for (long i = 0L; i < l; ++i) {
                    buffer.putInt(i * 4L, value2);
                }
            }
        }
    }

    @Override
    public void flush() {
        if (this._dirty) {
            this.metadata.setLength(this._length);
            IArrayMetadata iArrayMetadata = this.metadata;
            long l = iArrayMetadata.getVersion();
            iArrayMetadata.setVersion(l + 1L);
            this._dirty = false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/MutableArrayInt$Companion;", "", "()V", "entryBytes", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

