/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableListInt;
import kd.bos.olapServer2.dataEntities.DynamicSizeRange;
import kd.bos.olapServer2.memoryMappedFiles.IDynamicIntMetadata;
import kd.bos.olapServer2.memoryMappedFiles.ImmutableListDynamicInt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding.RunLengthMutableListInt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0014\u0010\u0015\u001a\u00020\u00132\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/MutableListDynamicInt;", "Lkd/bos/olapServer2/memoryMappedFiles/ImmutableListDynamicInt;", "Lkd/bos/olapServer2/collections/IMutableListInt;", "Ljava/io/Flushable;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/IDynamicIntMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/IDynamicIntMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_lastRange", "Lkd/bos/olapServer2/dataEntities/DynamicSizeRange;", "_maxValue", "", "Lkd/bos/olapServer2/common/int;", "add", "", "Lkd/bos/olapServer2/common/rowIdx;", "value", "flush", "", "resize", "resizeBytes", "bos-olap-core2"})
public class MutableListDynamicInt
extends ImmutableListDynamicInt
implements IMutableListInt,
Flushable {
    @NotNull
    private DynamicSizeRange _lastRange;
    private int _maxValue;

    public MutableListDynamicInt(@NotNull IDynamicIntMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        super(metadata, res);
        if (this.get_count() == 0L) {
            this._maxValue = -1;
            this._lastRange = new DynamicSizeRange(0L, 1L, 99, 0L);
        } else {
            int n;
            this._lastRange = this.getRanges().get(this.getRanges().getCount() - 1);
            switch (this._lastRange.getElementByteSize()) {
                case 1: {
                    n = 256;
                    break;
                }
                case 2: {
                    n = 65536;
                    break;
                }
                case 3: {
                    n = 0x1000000;
                    break;
                }
                case 4: {
                    n = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    String string2 = Res.INSTANCE.getCommonException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_4>(...)");
                    throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                }
            }
            this._maxValue = n;
        }
    }

    @Override
    public long add(int value2) {
        IByteBuffer buffer;
        if (!(value2 >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (value2 >= this._maxValue) {
            this.resizeBytes(value2);
        }
        long index2 = this.get_count();
        byte[] bytes2 = this.get_bytes();
        long pos = this._lastRange.getElementPosition(index2);
        if (pos + (long)4 > (buffer = this.get_buffer()).getCapacity()) {
            this.resize();
            buffer = this.get_buffer();
        }
        switch (this._lastRange.getElementByteSize()) {
            case 1: {
                buffer.putByte(pos, (byte)value2);
                break;
            }
            case 2: {
                buffer.putShort(pos, (short)value2);
                break;
            }
            case 3: {
                bytes2[0] = (byte)value2;
                bytes2[1] = (byte)(value2 >> 8);
                bytes2[2] = (byte)(value2 >> 16);
                buffer.putByteArray(pos, bytes2, 0, 3);
                break;
            }
            case 4: {
                buffer.putInt(pos, value2);
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
            }
        }
        this.set_count(index2 + 1L);
        return index2;
    }

    private final void resize() {
        long oneSegmentMaxBytes;
        long minCapacity;
        long capacity = this.get_buffer().getCapacity();
        if (capacity < (minCapacity = capacity + (oneSegmentMaxBytes = 262144L))) {
            long newSize = RunLengthMutableListInt.Companion.getNextCapacity(minCapacity);
            this.set_buffer(this.getRes().resize(newSize));
        }
    }

    private final void resizeBytes(int value2) {
        int n;
        int n2 = value2;
        boolean bl = 0 <= n2 ? n2 < 256 : false;
        if (bl) {
            n = 1;
        } else {
            boolean bl2 = 256 <= n2 ? n2 < 65536 : false;
            if (bl2) {
                n = 2;
            } else {
                boolean bl3 = 65536 <= n2 ? n2 < 0x1000000 : false;
                if (bl3) {
                    n = 3;
                } else {
                    boolean bl4 = 0x1000000 <= n2 ? n2 <= Integer.MAX_VALUE : false;
                    if (bl4) {
                        n = 4;
                    } else {
                        String string2 = Res.INSTANCE.getCommonException_5();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_5>(...)");
                        Object[] objectArray = new Object[]{value2};
                        throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                    }
                }
            }
        }
        int elementSize = n;
        if (elementSize == this._lastRange.getElementByteSize()) {
            return;
        }
        this.getRanges().add(this.get_count(), elementSize);
        this._lastRange = this.getRanges().get(this.getRanges().getCount() - 1);
        switch (this._lastRange.getElementByteSize()) {
            case 1: {
                this._maxValue = 256;
                break;
            }
            case 2: {
                this._maxValue = 65536;
                this.getMetadata().setTwoByteStart(this.get_count());
                break;
            }
            case 3: {
                this._maxValue = 0x1000000;
                this.getMetadata().setThreeByteStart(this.get_count());
                break;
            }
            case 4: {
                this._maxValue = Integer.MAX_VALUE;
                this.getMetadata().setFourByteStart(this.get_count());
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
            }
        }
    }

    @Override
    public void flush() {
        this.getMetadata().setCount(this.get_count());
    }
}

