/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles;

import kd.bos.olapServer2.collections.IMutableArrayInt;
import kd.bos.olapServer2.collections.IMutableArrayLong;
import kd.bos.olapServer2.collections.IMutableMapLong2Long;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.memoryMappedFiles.MutableArrayInt;
import kd.bos.olapServer2.memoryMappedFiles.MutableArrayLong;
import kd.bos.olapServer2.memoryMappedFiles.VirtualArrayMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0019\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eH\u0096\u0002J \u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0014\u001a\u00060\rj\u0002`\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eH\u0002J\u0018\u0010\u0018\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0019\u001a\u00060\rj\u0002`\u000eH\u0002J\u0014\u0010\u001a\u001a\u00020\u000b2\n\u0010\u001b\u001a\u00060\rj\u0002`\u000eH\u0002J!\u0010\u001c\u001a\u00020\u000b2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u001d\u001a\u00060\rj\u0002`\u000eH\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/MutableSparseMapLong2Long;", "Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "indexRes", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "dataRes", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "data", "Lkd/bos/olapServer2/collections/IMutableArrayLong;", "indexes", "Lkd/bos/olapServer2/collections/IMutableArrayInt;", "clear", "", "get", "", "Lkd/bos/olapServer2/common/long;", "key", "getDataInnerPosition", "segmentOffset", "", "Lkd/bos/olapServer2/common/int;", "segmentInnerPosition", "getSegmentIndex", "index", "getSegmentInnerPosition", "resizeData", "segmentIndex", "resizeIndexes", "newSize", "set", "value", "Companion", "bos-olap-core2"})
public final class MutableSparseMapLong2Long
implements IMutableMapLong2Long {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDynamicByteBufferResource dataRes;
    @NotNull
    private final IMutableArrayInt indexes;
    @NotNull
    private IMutableArrayLong data;
    private static final int maskSize = 16;
    private static final long segmentSize = 65536L;
    private static final long mask = 65535L;
    private static final long defaultValue = -1L;

    public MutableSparseMapLong2Long(@NotNull IDynamicByteBufferResource indexRes, @NotNull IDynamicByteBufferResource dataRes) {
        Intrinsics.checkNotNullParameter((Object)indexRes, (String)"indexRes");
        Intrinsics.checkNotNullParameter((Object)dataRes, (String)"dataRes");
        this.dataRes = dataRes;
        this.indexes = new MutableArrayInt(new VirtualArrayMetadata(0L, 0L, 2, null), indexRes);
        this.data = new MutableArrayLong(new VirtualArrayMetadata(0L, 0L, 2, null), this.dataRes);
    }

    private final long getSegmentIndex(long index2) {
        return index2 >> 16;
    }

    private final long getSegmentInnerPosition(long index2) {
        return index2 & 0xFFFFL;
    }

    private final long getDataInnerPosition(int segmentOffset, long segmentInnerPosition) {
        return ((long)segmentOffset << 16) + segmentInnerPosition;
    }

    @Override
    public void set(long key2, long value2) {
        int segmentOffset;
        if (!(key2 >= 0L && value2 >= -1L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long segmentIndex = this.getSegmentIndex(key2);
        long segmentInnerPosition = this.getSegmentInnerPosition(key2);
        if (segmentIndex >= this.indexes.getLength()) {
            if (value2 == -1L) {
                return;
            }
            this.resizeIndexes(segmentIndex + 1L);
        }
        if ((segmentOffset = this.indexes.get(segmentIndex)) == -1) {
            if (value2 == -1L) {
                return;
            }
            segmentOffset = this.resizeData(segmentIndex);
        }
        this.data.set(this.getDataInnerPosition(segmentOffset, segmentInnerPosition), value2);
    }

    private final int resizeData(long segmentIndex) {
        int newSegmentOffset = CommonTypesKt.toIntNoNegative(this.data.getLength() / 65536L);
        this.indexes.set(segmentIndex, newSegmentOffset);
        long newDataLength = this.data.getLength() + 65536L;
        this.data.resize(newDataLength);
        long l = (long)(newSegmentOffset + 1) * 65536L;
        for (long i = (long)newSegmentOffset * 65536L; i < l; ++i) {
            this.data.set(i, -1L);
        }
        return newSegmentOffset;
    }

    @Override
    public long get(long key2) {
        if (!(key2 >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long segmentIndex = this.getSegmentIndex(key2);
        if (this.indexes.getLength() <= segmentIndex) {
            return -1L;
        }
        long segmentInnerPosition = this.getSegmentInnerPosition(key2);
        int segmentOffset = this.indexes.get(segmentIndex);
        return segmentOffset == -1 ? -1L : this.data.get(this.getDataInnerPosition(segmentOffset, segmentInnerPosition));
    }

    @Override
    public void clear() {
        long l = this.indexes.getLength();
        for (long i = 0L; i < l; ++i) {
            this.indexes.set(i, -1);
        }
        this.data = new MutableArrayLong(new VirtualArrayMetadata(0L, 0L, 2, null), this.dataRes);
    }

    private final void resizeIndexes(long newSize) {
        if (!(0L <= newSize ? newSize <= Integer.MAX_VALUE : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long oldCapacity = this.indexes.getLength();
        long newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - newSize < 0L) {
            newCapacity = newSize;
        }
        if (newCapacity - (long)Integer.MAX_VALUE > 0L) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.indexes.resize(newCapacity);
        long l = this.indexes.getLength();
        for (long i = oldCapacity; i < l; ++i) {
            this.indexes.set(i, -1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/MutableSparseMapLong2Long$Companion;", "", "()V", "defaultValue", "", "mask", "maskSize", "", "segmentSize", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

