/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.nio.ReadOnlyBufferException;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedDatabase;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u0000 02\u00020\u0001:\u00010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bJ$\u0010\u0016\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u0006H\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001c\u001a\u00060\u0005j\u0002`\u0006J\u001c\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J4\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0005j\u0002`\u00062\n\u0010!\u001a\u00060\u0005j\u0002`\u0006H\u0016J*\u0010\"\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001c\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001e\u001a\u00060#j\u0002`$J\u001a\u0010%\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020&J2\u0010%\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020&2\n\u0010 \u001a\u00060'j\u0002`(2\n\u0010!\u001a\u00060'j\u0002`(J4\u0010)\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020*2\n\u0010 \u001a\u00060'j\u0002`(2\n\u0010!\u001a\u00060'j\u0002`(H\u0004J\u0014\u0010+\u001a\u00020\u00052\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u0006H\u0004J\u001c\u0010,\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020&H\u0016J4\u0010,\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u001e\u001a\u00020&2\n\u0010 \u001a\u00060'j\u0002`(2\n\u0010!\u001a\u00060'j\u0002`(H\u0016J \u0010-\u001a\u00020\u001a2\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010.\u001a\u00020/H\u0016R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer;", "", "db", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "address", "", "Lkd/bos/olapServer2/common/long;", "capacity", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedDatabase;JJ)V", "getAddress", "()J", "getCapacity", "getDb", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "isReadOnly", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "unsafe", "Lsun/misc/Unsafe;", "getUnsafe", "()Lsun/misc/Unsafe;", "checkIndex", "i", "nb", "clearData", "", "position", "size", "copy", "value", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "length", "fill", "", "Lkd/bos/olapServer2/common/byte;", "getByteArray", "", "", "Lkd/bos/olapServer2/common/int;", "getIntArrayL", "", "ix", "putByteArray", "throwIndexOutException", "toString", "", "Companion", "bos-olap-core2"})
public abstract class AbstractByteBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MappedDatabase db;
    private final long address;
    private final long capacity;
    @NotNull
    private final Unsafe unsafe;
    @NotNull
    private static final byte[] zeroBytes = new byte[0x100000];

    public AbstractByteBuffer(@NotNull MappedDatabase db, long address, long capacity) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
        this.address = address;
        this.capacity = capacity;
        if (this.db.isClosed()) {
            String string2 = Res.INSTANCE.getAbstractByteBufferException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AbstractByteBufferException_3>(...)");
            throw Res.INSTANCE.getIndexOutOfBoundsException(string2, new Object[0]);
        }
        if (this.address < 0L || this.capacity < 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafe = Bits.INSTANCE.getUnsafe();
    }

    @NotNull
    protected final MappedDatabase getDb() {
        return this.db;
    }

    public final long getAddress() {
        return this.address;
    }

    public final long getCapacity() {
        return this.capacity;
    }

    public abstract boolean isReadOnly();

    @NotNull
    protected final Unsafe getUnsafe() {
        return this.unsafe;
    }

    protected final long checkIndex(long i, long nb) {
        if (i < 0L || nb > this.capacity - i || this.db.isClosed()) {
            this.throwIndexOutException(i, nb);
        }
        return i;
    }

    private final void throwIndexOutException(long i, long nb) {
        if (this.db.isClosed()) {
            String string2 = Res.INSTANCE.getAbstractByteBufferException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AbstractByteBufferException_3>(...)");
            throw Res.INSTANCE.getIndexOutOfBoundsException(string2, new Object[0]);
        }
        String string3 = Res.INSTANCE.getAbstractByteBufferException_2();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-AbstractByteBufferException_2>(...)");
        Object[] objectArray = new Object[]{i, nb, this.capacity, this.capacity};
        throw Res.INSTANCE.getIndexOutOfBoundsException(string3, objectArray);
    }

    protected final long ix(long i) {
        return this.address + i;
    }

    public final void getByteArray(long position, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getByteArray(position, value2, 0, value2.length);
    }

    protected final void getIntArrayL(long position, @NotNull int[] value2, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkIndex(position, (long)length * (long)4);
        if (length == 0) {
            return;
        }
        AbstractByteBuffer.checkBounds(offset, length, value2.length);
        if (length * 4 > 6) {
            long copySize = 0L;
            long srcStart = position;
            long dstStart = (long)Bits.INSTANCE.getBYTE_ARRAY_OFFSET() + (long)offset * (long)4;
            for (long copyLength = (long)length * (long)4; copyLength > 0L; copyLength -= copySize) {
                copySize = copyLength > 0x100000L ? 0x100000L : copyLength;
                this.unsafe.copyMemory(null, this.ix(srcStart), value2, dstStart, copySize);
                srcStart += copySize;
                dstStart += copySize;
            }
        } else {
            long realPosition = this.address + position;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                value2[i] = this.unsafe.getInt(realPosition);
                realPosition += (long)4;
            }
        }
    }

    public final void getByteArray(long position, @NotNull byte[] value2, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkIndex(position, length);
        if (length == 0) {
            return;
        }
        AbstractByteBuffer.checkBounds(offset, length, value2.length);
        if (length > 6) {
            long copySize = 0L;
            long srcStart = position;
            long dstStart = (long)Bits.INSTANCE.getBYTE_ARRAY_OFFSET() + (long)offset;
            for (long copyLength = (long)length; copyLength > 0L; copyLength -= copySize) {
                copySize = copyLength > 0x100000L ? 0x100000L : copyLength;
                this.unsafe.copyMemory(null, this.ix(srcStart), value2, dstStart, copySize);
                srcStart += copySize;
                dstStart += copySize;
            }
        } else {
            long realPosition = this.address + position;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                long l = realPosition;
                realPosition = l + 1L;
                value2[i] = this.unsafe.getByte(l);
            }
        }
    }

    public void putByteArray(long position, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.putByteArray(position, value2, 0, value2.length);
    }

    public void putByteArray(long position, @NotNull byte[] value2, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkIndex(position, length);
        if (length == 0) {
            return;
        }
        AbstractByteBuffer.checkBounds(offset, length, value2.length);
        if (length > 6) {
            long copySize = 0L;
            long srcStart = (long)Bits.INSTANCE.getBYTE_ARRAY_OFFSET() + (long)offset;
            long dstStart = position;
            for (long copyLength = (long)length; copyLength > 0L; copyLength -= copySize) {
                copySize = copyLength > 0x100000L ? 0x100000L : copyLength;
                this.unsafe.copyMemory(value2, srcStart, null, this.ix(dstStart), copySize);
                srcStart += copySize;
                dstStart += copySize;
            }
        } else {
            long realPosition = this.ix(position);
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                long l = realPosition;
                realPosition = l + 1L;
                this.unsafe.putByte(l, value2[i]);
            }
        }
    }

    public void copy(long position, @NotNull IByteBuffer value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.copy(position, value2, 0L, value2.getCapacity());
    }

    public void copy(long position, @NotNull IByteBuffer value2, long offset, long length) {
        AbstractByteBuffer other;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        AbstractByteBuffer abstractByteBuffer = other = value2 instanceof AbstractByteBuffer ? (AbstractByteBuffer)((Object)value2) : null;
        if (other == null || other.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(position, length);
        if (length == 0L) {
            return;
        }
        AbstractByteBuffer.checkBounds(offset, length, value2.getCapacity());
        this.unsafe.copyMemory(other.ix(offset), this.ix(position), length);
    }

    public final void clearData() {
        this.clearData(0L, this.capacity);
    }

    public final void clearData(long position, long size) {
        this.fill(position, size, (byte)0);
    }

    public final void fill(long position, long size, byte value2) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(position, size);
        this.unsafe.setMemory(this.ix(position), size, value2);
    }

    @NotNull
    public String toString() {
        return "address: " + this.address + ", capacity: " + this.capacity;
    }

    @JvmStatic
    protected static final void checkBounds(long off, long len, long size) {
        Companion.checkBounds(off, len, size);
    }

    @JvmStatic
    protected static final void checkBounds(int off, int len, int size) {
        Companion.checkBounds(off, len, size);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0005J,\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\fj\u0002`\r2\n\u0010\n\u001a\u00060\fj\u0002`\r2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer$Companion;", "", "()V", "zeroBytes", "", "checkBounds", "", "off", "", "Lkd/bos/olapServer2/common/int;", "len", "size", "", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final void checkBounds(long off, long len, long size) {
            if ((off | len | off + len | size - (off + len)) < 0L) {
                String string2 = Res.INSTANCE.getAbstractByteBufferException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AbstractByteBufferException_2>(...)");
                Object[] objectArray = new Object[]{off, len, size, size};
                throw Res.INSTANCE.getIndexOutOfBoundsException(string2, objectArray);
            }
        }

        @JvmStatic
        protected final void checkBounds(int off, int len, int size) {
            if ((off | len | off + len | size - (off + len)) < 0) {
                String string2 = Res.INSTANCE.getAbstractByteBufferException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AbstractByteBufferException_2>(...)");
                Object[] objectArray = new Object[]{off, len, size, size};
                throw Res.INSTANCE.getIndexOutOfBoundsException(string2, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

