/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.io.File;
import java.nio.ByteOrder;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.memoryMappedFiles.IHeadFieldCollection;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.FileInfo;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB!\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\u0010\r\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010#\u001a\u00020$J\n\u0010%\u001a\u00060\u0006j\u0002`\u0007J\b\u0010&\u001a\u00020$H\u0016J\u0014\u0010'\u001a\u00020\u00102\n\u0010(\u001a\u00060\u0012j\u0002`\u0017H\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u00020\u00102\n\u0010(\u001a\u00060\u0012j\u0002`\u0017H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0012j\u0002`\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00060\u0012j\u0002`\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0018\u0010\r\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010 R\u0018\u0010!\u001a\u00060\u0012j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResource;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferResource;", "fileName", "", "Lkd/bos/olapServer2/common/string;", "isReadonly", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/lang/String;Z)V", "fileInfo", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/FileInfo;", "mappedFile", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;", "isReadOnly", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/FileInfo;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;Z)V", "_contentBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_headSize", "", "contentBuffer", "getContentBuffer", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "contentSize", "Lkd/bos/olapServer2/common/long;", "getContentSize", "()J", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "headSize", "getHeadSize", "()Z", "length", "getLength", "close", "", "exists", "force", "mapContentBuffer", "minSize", "open", "headFields", "Lkd/bos/olapServer2/memoryMappedFiles/IHeadFieldCollection;", "resize", "toString", "bos-olap-core2"})
public final class ByteBufferResource
implements IByteBufferResource {
    @NotNull
    private final FileInfo fileInfo;
    @NotNull
    private final MappedFile mappedFile;
    private final boolean isReadOnly;
    @NotNull
    private final File file;
    private long _headSize;
    @Nullable
    private IByteBuffer _contentBuffer;

    public ByteBufferResource(@NotNull FileInfo fileInfo, @NotNull MappedFile mappedFile, boolean isReadOnly) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)mappedFile, (String)"mappedFile");
        this.fileInfo = fileInfo;
        this.mappedFile = mappedFile;
        this.isReadOnly = isReadOnly;
        this.file = this.fileInfo.getFile();
        this._headSize = -1L;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ByteBufferResource(@NotNull String fileName, boolean isReadonly) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this(new FileInfo(PathsKt.fileSafeConstructor(fileName)), new MappedFile(fileName), isReadonly);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean exists() {
        return this.fileInfo.exists();
    }

    @Override
    public long getLength() {
        return this.fileInfo.getLength();
    }

    private final long getHeadSize() {
        if (this._headSize < 0L) {
            throw new NotSupportedException();
        }
        return this._headSize;
    }

    private final long getContentSize() {
        return this.getLength() == 0L ? 0L : this.getLength() - this.getHeadSize();
    }

    @Override
    @NotNull
    public IByteBuffer open(@NotNull IHeadFieldCollection headFields) {
        long headSize;
        Intrinsics.checkNotNullParameter((Object)headFields, (String)"headFields");
        this._headSize = headSize = headFields.getNextOffset();
        boolean bl = this.isReadOnly();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        IByteBuffer buffer = this.mappedFile.map(0L, headSize, bl, byteOrder);
        this.fileInfo.open(headFields, buffer);
        return buffer;
    }

    @Override
    @NotNull
    public IByteBuffer getContentBuffer() {
        return this.mapContentBuffer(this.getContentSize());
    }

    private final IByteBuffer mapContentBuffer(long minSize) {
        IByteBuffer oldBuffer = this._contentBuffer;
        if (oldBuffer != null && oldBuffer.getCapacity() >= minSize) {
            return oldBuffer;
        }
        long position = this.getHeadSize();
        boolean bl = this.isReadOnly();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        IByteBuffer newBuffer = this.mappedFile.map(position, minSize, bl, byteOrder);
        if (!this.isReadOnly()) {
            this.fileInfo.clearLengthCache();
        }
        this._contentBuffer = newBuffer;
        return newBuffer;
    }

    @Override
    @NotNull
    public IByteBuffer resize(long minSize) {
        return this.mapContentBuffer(minSize);
    }

    public final void close() {
        this.mappedFile.close();
    }

    @Override
    public void force() {
        if (this.isReadOnly()) {
            throw new NotSupportedException();
        }
        this.mappedFile.force();
    }

    @NotNull
    public String toString() {
        return "ByteBufferResource : " + this.file;
    }
}

